SET SESSION FOREIGN_KEY_CHECKS=0;

/* Drop Indexes */

DROP INDEX IX_LOGIN_HISTORY_1 ON TB_LOGIN_HISTORY;
DROP INDEX IX_PASSWORD_HISTORY_1 ON TB_PASSWORD_HISTORY;
DROP INDEX IX_USER_1 ON TB_USER;
DROP INDEX IX_USER_2 ON TB_USER;



/* Drop Tables */

DROP TABLE TB_REPORT;
DROP TABLE TB_WORK;
DROP TABLE MS_PROJECT;
DROP TABLE TB_LOGIN_HISTORY;
DROP TABLE TB_PASSWORD_HISTORY;
DROP TABLE TB_USER;




/* Create Tables */

CREATE TABLE MS_PROJECT
(
	ID INT NOT NULL AUTO_INCREMENT COMMENT '識別子',
	NAME VARCHAR(200) NOT NULL COMMENT '名称',
	CREATED DATE COMMENT '作成日',
	UPDATED TIMESTAMP COMMENT '更新日',
	-- Y / N
	DELETED ENUM('Y','N') DEFAULT 'N' NOT NULL COMMENT '削除フラグ : Y / N',
	PRIMARY KEY (ID)
) COMMENT = 'プロジェクト' DEFAULT CHARACTER SET utf8;


CREATE TABLE TB_LOGIN_HISTORY
(
	ID INT NOT NULL AUTO_INCREMENT COMMENT '識別子',
	TB_USER_ID INT NOT NULL COMMENT '識別子(FK)',
	-- Y / N 
	SUCCESSED ENUM('Y','N') DEFAULT 'N' COMMENT '成功 : Y / N ',
	CREATED DATE COMMENT '作成日',
	UPDATED TIMESTAMP COMMENT '更新日',
	-- Y / N
	DELETED ENUM('Y','N') DEFAULT 'N' NOT NULL COMMENT '削除フラグ : Y / N',
	PRIMARY KEY (ID)
) COMMENT = 'ログイン履歴' DEFAULT CHARACTER SET utf8;


CREATE TABLE TB_PASSWORD_HISTORY
(
	ID INT NOT NULL AUTO_INCREMENT COMMENT '識別子',
	TB_USER_ID INT NOT NULL COMMENT '識別子(FK)',
	PASSWORD VARCHAR(200) COMMENT 'パスワード',
	CREATED DATE COMMENT '作成日',
	UPDATED TIMESTAMP COMMENT '更新日',
	-- Y / N
	DELETED ENUM('Y','N') DEFAULT 'N' NOT NULL COMMENT '削除フラグ : Y / N',
	PRIMARY KEY (ID)
) COMMENT = 'パスワード履歴' DEFAULT CHARACTER SET utf8;


CREATE TABLE TB_REPORT
(
	ID INT NOT NULL AUTO_INCREMENT COMMENT '識別子',
	TB_USER_ID INT NOT NULL COMMENT '識別子(FK)',
	REPORT_DATE DATE COMMENT 'レポート日',
	MS_PROJECT_ID INT NOT NULL COMMENT '識別子(FK:PROJECT）',
	TB_WORK_ID INT NOT NULL COMMENT '識別子(FK:work)',
	CREATED DATE COMMENT '作成日',
	UPDATED TIMESTAMP COMMENT '更新日',
	-- Y / N
	DELETED ENUM('Y','N') DEFAULT 'N' NOT NULL COMMENT '削除フラグ : Y / N',
	PRIMARY KEY (ID)
) COMMENT = 'レポート' DEFAULT CHARACTER SET utf8;


CREATE TABLE TB_USER
(
	ID INT NOT NULL AUTO_INCREMENT COMMENT '識別子',
	ACCOUNT VARCHAR(200) COMMENT 'アカウント',
	MAILADDRESS VARCHAR(200) COMMENT 'メールアドレス',
	PASSWORD VARCHAR(200) NOT NULL COMMENT 'パスワード',
	-- Y / N 
	TEMPORARY_FLG ENUM('Y','N') DEFAULT 'Y' COMMENT '仮登録フラグ : Y / N ',
	-- Y / N 
	LOCK_FLG ENUM('Y','N') DEFAULT 'N' COMMENT 'ロックフラグ : Y / N ',
	FAIL_CNT INT DEFAULT 0 COMMENT 'ログイン失敗回数',
	CREATED DATE COMMENT '作成日',
	UPDATED TIMESTAMP COMMENT '更新日',
	-- Y / N
	DELETED ENUM('Y','N') DEFAULT 'N' NOT NULL COMMENT '削除フラグ : Y / N',
	PRIMARY KEY (ID)
) COMMENT = 'ユーザー' DEFAULT CHARACTER SET utf8;


CREATE TABLE TB_WORK
(
	ID INT NOT NULL AUTO_INCREMENT COMMENT '識別子',
	MS_PROJECT_ID INT NOT NULL COMMENT '識別子(FK:PROJECT)',
	NAME VARCHAR(200) COMMENT '名称',
	ACCESSED TIMESTAMP DEFAULT NOW() COMMENT 'アクセス時間',
	CREATED DATE COMMENT '作成日',
	UPDATED TIMESTAMP COMMENT '更新日',
	-- Y / N
	DELETED ENUM('Y','N') DEFAULT 'N' NOT NULL COMMENT '削除フラグ : Y / N',
	PRIMARY KEY (ID)
) COMMENT = '作業' DEFAULT CHARACTER SET utf8;



/* Create Foreign Keys */

ALTER TABLE TB_REPORT
	ADD FOREIGN KEY (MS_PROJECT_ID)
	REFERENCES MS_PROJECT (ID)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


ALTER TABLE TB_WORK
	ADD FOREIGN KEY (MS_PROJECT_ID)
	REFERENCES MS_PROJECT (ID)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


ALTER TABLE TB_LOGIN_HISTORY
	ADD FOREIGN KEY (TB_USER_ID)
	REFERENCES TB_USER (ID)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


ALTER TABLE TB_PASSWORD_HISTORY
	ADD FOREIGN KEY (TB_USER_ID)
	REFERENCES TB_USER (ID)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


ALTER TABLE TB_REPORT
	ADD FOREIGN KEY (TB_USER_ID)
	REFERENCES TB_USER (ID)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


ALTER TABLE TB_REPORT
	ADD FOREIGN KEY (TB_WORK_ID)
	REFERENCES TB_WORK (ID)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;



/* Create Indexes */

CREATE INDEX IX_LOGIN_HISTORY_1 ON TB_LOGIN_HISTORY (TB_USER_ID ASC, SUCCESSED ASC);
CREATE INDEX IX_PASSWORD_HISTORY_1 ON TB_PASSWORD_HISTORY (TB_USER_ID ASC, PASSWORD ASC);
CREATE INDEX IX_USER_1 ON TB_USER (ACCOUNT ASC, PASSWORD ASC);
CREATE INDEX IX_USER_2 ON TB_USER (MAILADDRESS ASC, PASSWORD ASC);



