/*
 * OpenI2CRADIO
 * UI Handler
 * (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2
 */

#include "ui.h"

keyin_defs keyin_old[2];
keyin_defs keyin_now;
char keyin_fifo[16];
char keyin_nowp;
char keyin_readp;
char keyin_counter;

void keyin_init(void)
{
    char i;
    /* Initialize vars*/
    for(i = 0; i < 3; i++) {
        keyin_old[0].byte[i] = 0x00;
        keyin_old[1].byte[i] = 0x00;
        keyin_now.byte[i] = 0x00;
    }
    for(i = 0; i < 16; i++) keyin_fifo[i] = 0x00;
    keyin_nowp = 0;
    keyin_readp = 0;
    keyin_counter = 0;

}

void keyin_ioinit(void)
{
    /* Initialize IOPORTS*/
    PORTA = 0x00;
    LATA = 0x00;
    ANSELA = AN_A_VAL;
    TRISA = TRIS_A_VAL;

    PORTB = 0x00;
    LATB = 0x00;
    ANSELB = AN_B_VAL;
    TRISB = TRIS_B_VAL;

    PORTC = 0x00;
    LATC = 0x00;
    ANSELC = AN_C_VAL;
    TRISC = TRIS_C_VAL_O;
}

/*
 * Push to keyin fifo; not used atomic-writing.
 */
void push_keyinfifo(char b)
{
    keyin_nowp++;
    if((keyin_nowp > 15) || (keyin_nowp < 0))keyin_nowp = 0;
    keyin_fifo[keyin_nowp] = b;
    keyin_counter++;
    if(keyin_counter > 16) keyin_counter = 16;
}

/*
 * Pop from keyin fifo; not used atomic-reading.
 */
char pop_keyinfifo(void)
{
    char c;
    if(keyin_counter <= 0) {
        keyin_counter = 0;
        return charcode_null ;
    }
    if(keyin_readp > 15) keyin_readp = 15;
    c = keyin_fifo[keyin_readp];
    keyin_readp++;
    if(keyin_readp > 15) keyin_readp = 0;
    keyin_counter--;
    if(keyin_counter < 0)keyin_counter = 0;
    return c;
}

void print_numeric(int i)
{
    if(i == 0){
        unsigned char c;
        c = '0';
        _CURSOR_LEFT();
        _PUTCHAR(c);
        _CURSOR_RIGHT();
    } else {
        int l;
        unsigned char supress = 0;
         _CURSOR_LEFT();
        if(i < 0){
            _PUTCHAR('-');
            i = -i;
        }
        l = i / 10000;
        i = i % 10000;
        if(l != 0) {
            _PUTCHAR((l & 0x0f)+ '0');
            supress = 1;
        }
        l = i / 1000;
        i = i % 1000;
        if(supress != 0){
             _PUTCHAR((l & 0x0f)+ '0');
        } else if(l != 0){
             _PUTCHAR((l & 0x0f)+ '0');
            supress = 1;

        }
        l = i / 100;
        i = i % 100;
        if(supress != 0){
             _PUTCHAR((l & 0x0f)+ '0');
        } else if(l != 0){
             _PUTCHAR((l & 0x0f)+ '0');
            supress = 1;

        }
        l = i / 10;
        i = i % 10;
        if(supress != 0){
             _PUTCHAR((l & 0x0f)+ '0');
        } else if(l != 0){
             _PUTCHAR((l & 0x0f)+ '0');
            supress = 1;

        }
        _PUTCHAR((i & 0x0f) + '0');
        _CURSOR_RIGHT();
    }

}

void printstr(char *s)
{
    int p = 0;
    _CURSOR_RIGHT();
    if(s == NULL) return;
    do {
        if(s[p] == '\0') break;
        _PUTCHAR(s[p]);
        p++;
    } while(p < 255);
}

/*
 * Read IOPORTS for KEY.
 */
void readkey_io(void)
{
    char i;
    unsigned char portvar;
    unsigned char latchvar;
    unsigned char high;
    unsigned char low;
    if(keyin_counter > 16) keyin_counter = 0;
    for(i = 0; i < 3; i++){
        keyin_old[1].byte[i] = keyin_old[0].byte[i];
        keyin_old[0].byte[i] = keyin_now.byte[i];
        keyin_now.byte[i] = 0x00;
     }
     /* SCANLINE A*/
    latchvar = LATA | 0x02;
    LATA = latchvar;
    portvar = PORTA;
    low = (portvar & 0x3c) >>2;
    latchvar = LATA & 0xfd;
    LATA = latchvar;
    /* SCANLINE B*/
    latchvar = LATB | 0x02;
    LATB = latchvar;
    portvar = PORTA;
    high = (portvar & 0x3c) >>2;
    latchvar = LATB & 0xfd;
    LATB = latchvar;
    /* Pos */
    keyin_now.byte[0] = (low << 4) | high;

    /* SCANLINE C*/
    latchvar = LATB | 0x04;
    LATA = latchvar;
    portvar = PORTA;
    low = (portvar & 0x3c) >>2;
    latchvar = LATB & 0xfb;
    LATA = latchvar;
    /* SCANLINE D*/
    latchvar = LATB | 0x20;
    LATB = latchvar;
    portvar = PORTA;
    high = (portvar & 0x3c) >>2;
    latchvar = LATB & 0xdf;
    LATB = latchvar;
    /* Pos */
    keyin_now.byte[1] = (low << 4) | high;

    /* Special KEYS */
    keyin_now.BIT0F = PORTBbits.RB1;
    keyin_now.BIT1F = PORTBbits.RB2;
    keyin_now.BIT2F = PORTBbits.RB3;
    keyin_now.BIT3F = 0; // Reserve
}

unsigned char readkey_compare(void)
{
    char b;
    char c;
    char d;
    char e;
    unsigned char shift;
    unsigned char f;
    f = 0;
    e = 0;
    for(d = 0; d < 3; d++) {
        shift = 0x01;
        for(b = 0; b < 8; b++){
            c = 0;
            if((keyin_now.byte[c] & shift) != 0) c++;
            if((keyin_old[0].byte[c] & shift) != 0) c++;
            if((keyin_old[1].byte[c] & shift) != 0) c++;
            if(c >= 2) {
            /*
             * Clear older-inputs on .
             */
                f |= 1;
                keyin_old[0].byte[c] &= ~shift;
                keyin_old[1].byte[c] &= ~shift;
                keyin_now.byte[c] &= ~shift;
                if(e == 0) {
                    push_keyinfifo(charcode_0);
                } else if(e <= 15) {
                    push_keyinfifo(b);
                } else if(e < 20) {
                    push_keyinfifo(e + 1);
                }
            }
            shift <<= 1;
            e++;
        }
    }
    /**/
    return f;
}

/*
 * Notes:
 * Initialize sequence:
 * keyin_init();
 * keyin_ioinit();
 * 
 * Read-key-sequence:
 * In interrupt/unsleep hook(call per Nms):
 * readkey_io();
 * readkey_compare();
 *
 * In application handler:
 * c = pop_keyinfifo();
 * if(c != 0) do(c);
 */