/*
 * OpenI2CRADIO
 * I2C-LCD ACM1602 Handler
 * (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2
 */

#ifndef LCD_ACM1602_H
#define	LCD_ACM1602_H

#include <stdarg.h>
#include <stdio.h>
#include <delay.h>
#include <string.h>

#include "i2c_io.h"


#ifdef	__cplusplus
extern "C" {
#endif

void acm1602_cls(unsigned char addr);
void acm1602_putchar(unsigned char addr, unsigned char c);
void acm1602_locate(unsigned char addr, char x, char y);
void acm1602_home(unsigned char addr);
void acm1602_printf(unsigned char addr, const char *fmt, ...);
void acm1602_cursordir(unsigned char addr, unsigned char right);
void acm1602_init(unsigned char addr, unsigned char cls);



#ifdef	__cplusplus
}
#endif

#endif	/* LCD_ACM1602_H */

