/*
 * OpenI2CRADIO
 * I2C Header
 * (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2
 */
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */

#include <i2c.h>

#ifndef I2C_IO_H
#define	I2C_IO_H

#ifdef	__cplusplus
extern "C" {
#endif
/*
 * #1
 */
#define I2C_CLOCK_PARAM 19 // 8MHz/(4*(1+I2C_CLOCK_PARAM)) -> 100KHz
#define I2C_DEFAULT_MODE I2C_MASTER
#define I2C_SLEW_DEFAULT I2C_SLEW_ON

#define OPENASMASTER() i2c_open(I2C_DEFAULT_MODE, I2C_SLEW_DEFAULT, I2C_CLOCK_PARAM)
#define CLOSEASMASTER() i2c_close()
extern void i2c1_init(void);
extern void i2c2_init(void);

#ifdef	__cplusplus
}
#endif

#endif	/* I2C_IO_H */

