/*
 * OpenI2CRADIO
 * I/O Port defines.
 * (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2
 */

#ifndef IODEF_H
#define	IODEF_H

#ifdef	__cplusplus
extern "C" {
#endif


/*
 * MAP OF IOPORT
 * PORTA/B/C USED.
 * PORTA: RA2-RA5 : READ
 *        RA1 : SLOT D(OUT)
 *        RA0 : ADC(IN)
 *        RA6-RA7 : CLOCK
 * PORTB: RB4-RB5 : RESERVED
 *        RB6-RB7 : FOR ICSP
 *        RB3 : DEL / BAND
 *        RB2 : FUNC
 *        RB1 : Light
 *        RB0 : Light Out
 * PORTC  RC0 : LED
 *        RC1 : SLOT A
 *        RC2 : SLOT B
 *        RC5 : SLOT C
 *        RC3-RC4 : SCL/SDA
 *        RC6-RC7 : USART
 */

#define TRIS_A_VAL 0b11111101
#define AN_A_VAL 0b00000001
#define TRIS_B_VAL 0b11111110
#define AN_B_VAL 0b00000000
#define TRIS_C_VAL_O 0b11000000 /* FOR I2C-WRITE */
#define TRIS_C_VAL_I 0b11011000 /* FOR I2C-WRITE */
#define AN_C_VAL 0b00000000

typedef  union {
    struct {
    unsigned BIT0A:1;
    unsigned BIT1A:1;
    unsigned BIT2A:1;
    unsigned BIT3A:1;

    unsigned BIT0B:1;
    unsigned BIT1B:1;
    unsigned BIT2B:1;
    unsigned BIT3B:1;

    unsigned BIT0C:1;
    unsigned BIT1C:1;
    unsigned BIT2C:1;
    unsigned BIT3C:1;

    unsigned BIT0D:1;
    unsigned BIT1D:1;
    unsigned BIT2D:1;
    unsigned BIT3D:1;

    /*
     * special keys
     */
    unsigned BIT0F:1;
    unsigned BIT1F:1;
    unsigned BIT2F:1;
    unsigned BIT3F:1;
    unsigned :1;
    unsigned :1;
    unsigned :1;
    unsigned :1;
    };
    unsigned char byte[3];
} keyin_defs;

enum {
    charcode_null = 0,
    charcode_1,
    charcode_2,
    charcode_3,
    charcode_4,
    charcode_5,
    charcode_6,
    charcode_7,
    charcode_8,
    charcode_9,
    charcode_a,
    charcode_b,
    charcode_c,
    charcode_d,
    charcode_e,
    charcode_f,
    charcode_0,
    charcode_s0, // RB1
    charcode_s1, // RB2
    charcode_s2, // RB3
    charcode_s3, // Reserve
};


#ifdef	__cplusplus
}
#endif

#endif	/* IODEF_H */

