/* 
 * File:   akc6955.h
 * Author: whatisthis
 *
 * Created on 2013/06/11, 10:24
 */

#ifndef AKC6955_H
#define	AKC6955_H

#ifdef	__cplusplus
extern "C" {
#endif

#define AKC6955_ADDRESS 0x20

/*
 * Register definisions.
 */
#define AKC6955_POWER  0
#define AKC6955_BAND   1
#define AKC6955_CH_HI  2
#define AKC6955_CH_LO  3
#define AKC6955_UCH_ST 4
#define AKC6955_UCS_EN 5
#define AKC6955_VOLUME 6
#define AKC6955_STEREO 7
#define AKC6955_THRESH 8
#define AKC6955_ENABLE 9
// 10 = RESERVE
#define AKC6955_SPACE  11
// 12 = RESERVE
#define AKC6955_PRE 13
// 14-19 = RESERVE

// Read only registers
#define AKC6955_RCH_HI   20
#define AKC6955_RCH_LO   21
#define AKC6955_CNR_AM   22
#define AKC6955_CNR_FM   23
#define AKC6955_PGALEVEL 24
#define AKC6955_VBAT     25
#define AKC6955_FDNUM    26
#define AKC6955_RSSI     27

/*
 * BAND DEFINES
 */

    enum {
        AKC6955_BAND_LW = 0, // 150~285KHz, 3KHz order
        AKC6955_BAND_MW1,    // 520~1710KHz, 5KHz order
        AKC6955_BAND_MW2,    // 522~1620KHz, 9KHz order
        AKC6955_BAND_MW3,    // 520~1710KHz, 10KHz order

        AKC6955_BAND_SW1,    // 4700~10000KHz, 5KHz order
        AKC6955_BAND_SW2,    // 3200~4100KHz, 5KHz order
        AKC6955_BAND_SW3,    // 4700~5600KHz, 5KHz order
        AKC6955_BAND_SW4,    // 5700~6400KHz, 5KHz order

        AKC6955_BAND_SW5,    // 6800~7600KHz, 5KHz order
        AKC6955_BAND_SW6,    // 9200~10000KHz, 5KHz order
        AKC6955_BAND_SW7,    // 11400~12200KHz, 5KHz order
        AKC6955_BAND_SW8,    // 13500~14300KHz, 5KHz order

        AKC6955_BAND_SW9,    // 15000~15900KHz, 5KHz order
        AKC6955_BAND_SW10,   // 17400~17900KHz, 5KHz order
        AKC6955_BAND_SW11,   // 18900~19700KHz, 5KHz order
        AKC6955_BAND_SW12,   // 21400~21900KHz, 5KHz order

        AKC6955_BAND_SW13,   // 11400~17900KHz, 5KHz order
        AKC6955_BAND_AMUSER, // User Setting
        AKC6955_BAND_MW4,    // 520~1730KHz, 5KHz order
    };


    enum {
        AKC6955_BAND_FM1 = 0, // 87.0~108.0MHz
        AKC6955_BAND_FM2,     // 76.0~108.0MHz
        AKC6955_BAND_FM3,     // 70.0~93.0MHz
        AKC6955_BAND_FM4,     // 76.0~90.0MHz
        AKC6955_BAND_FM5,     // 64.0~88.0MHz
        AKC6955_BAND_TV1,     // 56.25~91.75MHz
        AKC6955_BAND_TV2,     // 174.75~222.25MHz
        AKC6955_BAND_FMUSER,  // User Setting
    };
    
/*
 * Resister definitions
 */
    typedef union{
        unsigned char byte;
        struct {
            unsigned power_on :1;
            unsigned fm_en :1;
            unsigned tune :1;
            unsigned seek :1;
            unsigned seekdir :1;
            unsigned mute :1;
            unsigned reserve :2;
        };
     } AKC6955_Reg0;


extern void akc6955_writecmd(unsigned char reg, unsigned char data);
extern unsigned char akc6955_readcmd(unsigned char reg);
extern void akc6955_chg_fm(unsigned char fm);
     
extern void akc6955_set_amband(unsigned char band);
extern void akc6955_set_fmband(unsigned char band);

     
extern unsigned char akc6955_get_amband(void);
extern unsigned char akc6955_get_fmband(void);
extern void akc6955_set_power(unsigned char on);
extern void akc6955_do_tune(void);
extern unsigned char akc6955_tune(void);

extern unsigned int akc6955_mode3k(unsigned char flag);
extern void akc6955_set_tune(unsigned char mode_3k, unsigned int ch);
extern void akc6955_do_scan(unsigned char up);

extern unsigned char akc6955_chk_donescan(void);
extern unsigned int akc6955_get_freq(void);
extern void akc6955_set_freq(unsigned int freq);
extern unsigned char akc6955_get_cnr(void);

extern int akc6955_read_level(void);
extern unsigned int akc6955_up_freq(unsigned int step);
extern unsigned int akc6955_down_freq(unsigned int step);

     

#ifdef	__cplusplus
}
#endif

#endif	/* AKC6955_H */

