/****************************************************
作成日：2013/12/04
SWTのテストを行う
SWTはOSのAPIを直接呼び出すため、C++に迫る速度を出している
「Write Once，Run Anywhere」（一度書けばどこでも動く）は崩れる
電卓
カラーテーマ 「Color theme for prevention of asthenopia」
http://eclipsecolorthemes.org/?view=theme&id=22219
 ****************************************************/
package swtDentaku;

import org.eclipse.wb.swt.SWTResourceManager;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionAdapter;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.Calendar;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import org.eclipse.swt.widgets.Listener;

/**
 * @author ame
 *
 */
public class SwtDentaku implements Constants{

    private Shell shell;
    Shell subShell;
    private String efield = "";
    private String history = "";
    private Label exprsLabel;
    private Label resultLabel;
    private Display display;
    private Listener listener;
    private Composite composite_2;
    private MenuItem menuItem;

    /**
     * Launch the application.
     * @param args
     */
    public static void main(String[] args) {
        try {
            SwtDentaku window = new SwtDentaku();
            window.open();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Open the window.
     */
    private void open() {
        display = Display.getDefault();
        createContents();
        shell.open();
        shell.layout();
        while (!shell.isDisposed()) {
            if (!display.readAndDispatch()) {
                display.sleep();
            }
        }
    }

    /**
     * Create contents of the main window.
     */
    private void createContents() {
        shell = new Shell(SWT.MIN);
        shell.setMinimumSize(new Point(132, 132));
        shell.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_BACKGROUND_GRADIENT));
        shell.setImage(SWTResourceManager.getImage(SwtDentaku.class, "/swtDentaku/resources/icon.gif"));
        shell.setSize(198, 315);
        shell.setText("電卓");
        GridLayout gl_shell = new GridLayout(1, false);
        shell.setLayout(gl_shell);

        // リスナーを定義する
        // 定義：キーボードのイベントに対して、＝、BS、Clearの入力があれば実行し、数字、演算子の入力があれば式に代入する
        listener = new Listener(){
            public void handleEvent(Event e){
                if(e.character == SWT.CR){
                    run();
                }else if(e.character == SWT.BS){
                    bs();
                }else if(e.character == SWT.DEL){
                    clear();
                }else if((""+e.character).matches("[0-9\\.\\+\\-\\*\\/\\(\\)\\^eE]")){
                    set(""+e.character);
                }
            }
        };

        /* 計算結果表示エリア */
        Composite composite_1 = new Composite(shell, SWT.BORDER);
        composite_1.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
        composite_1.setLayout(null);
        GridData gd_composite_1 = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
        gd_composite_1.heightHint = 50;
        gd_composite_1.widthHint = 176;
        composite_1.setLayoutData(gd_composite_1);
            exprsLabel = new Label(composite_1, SWT.SHADOW_NONE);
            exprsLabel.setBounds(0, 0, 176, 23);
            exprsLabel.setFont(new Font(display, "メイリオ",11,  SWT.NORMAL));
            exprsLabel.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
            exprsLabel.setAlignment(SWT.RIGHT);
            resultLabel = new Label(composite_1, SWT.SHADOW_NONE);
            resultLabel.setFont(SWTResourceManager.getFont("メイリオ", 16, SWT.NORMAL));
            resultLabel.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
            resultLabel.setAlignment(SWT.RIGHT);
            resultLabel.setBounds(0, 22, 176, 30);
        composite_2 = new Composite(shell, SWT.NONE);
        composite_2.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_BACKGROUND_GRADIENT));
        GridData gd_composite_2 = new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1);
        gd_composite_2.widthHint = 181;
        composite_2.setLayoutData(gd_composite_2);
        GridLayout gl_composite_2 = new GridLayout(4, true);
        gl_composite_2.marginHeight = 0;
        gl_composite_2.marginWidth = 0;
        composite_2.setLayout(gl_composite_2);

            // (
            Button rightParenthesis = new Button(composite_2, SWT.NONE);
            rightParenthesis.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                        set("(");
                }
            });
            GridData gd_button = new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1);
            gd_button.widthHint = 41;//ボタンの大きさをここで設定している
            rightParenthesis.setLayoutData(gd_button);
            rightParenthesis.setText("(");


            // )
            Button leftParenthesis = new Button(composite_2, SWT.NONE);
            leftParenthesis.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                        set(")");
                }
            });
            leftParenthesis.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
            leftParenthesis.setText(")");

            // BS
            Button backspace = new Button(composite_2, SWT.NONE);
            backspace.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
            backspace.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    bs();
                }
            });
            backspace.setText("BS");

            // C
            Button clear = new Button(composite_2, SWT.NONE);
            clear.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
            clear.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    clear();
                }
            });
            clear.setText("C");

            // ±
            Button nagate = new Button(composite_2, SWT.NONE);
            nagate.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    nagate();
                }
            });
            nagate.setLayoutData(new GridData(SWT.FILL, SWT.BOTTOM, false, false, 1, 1));
            nagate.setText("±");

            // /
            Button division = new Button(composite_2, SWT.NONE);
            division.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
            division.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    set("/");
                }
            });
            division.setText("/");

            // *
            Button multiplication = new Button(composite_2, SWT.NONE);
            multiplication.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
            multiplication.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    set("*");
                }
            });
            multiplication.setText("*");

            // -
            Button subtraction = new Button(composite_2, SWT.NONE);
            subtraction.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
            subtraction.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    set("-");
                }
            });
            subtraction.setText("-");

            // 7
            Button button7 = new Button(composite_2, SWT.NONE);
            button7.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
            button7.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    set("7");
                }
            });
            button7.setText("7");

            // 8
            Button button8 = new Button(composite_2, SWT.NONE);
            button8.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
            button8.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    set("8");
                }
            });
            button8.setText("8");

            // 9
            Button button9 = new Button(composite_2, SWT.NONE);
            button9.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
            button9.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    set("9");
                }
            });
            button9.setText("9");

            Button button = new Button(composite_2, SWT.NONE);
            button.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    set("^");
                }
            });
            button.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
            button.setText("^");

            // 4
            Button button4 = new Button(composite_2, SWT.NONE);
            button4.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
            button4.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    set("4");
                }
            });
            button4.setText("4");

            // 5
            Button button5 = new Button(composite_2, SWT.NONE);
            button5.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
            button5.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    set("5");
                }
            });
            button5.setText("5");

            // 6
            Button button6 = new Button(composite_2, SWT.NONE);
            button6.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
            button6.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    set("6");
                }
            });
            button6.setText("6");

                        // +
                        Button addition = new Button(composite_2, SWT.NONE);
                        addition.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
                        addition.addSelectionListener(new SelectionAdapter() {
                            @Override
                            public void widgetSelected(SelectionEvent arg0) {
                                set("+");
                            }
                        });
                        addition.setText("+");

            // 1
            Button button1 = new Button(composite_2, SWT.NONE);
            button1.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
            button1.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    set("1");
                }
            });
            button1.setText("1");

            // 2
            Button button2 = new Button(composite_2, SWT.NONE);
            button2.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
            button2.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    set("2");
                }
            });
            button2.setText("2");

            // 3
            Button button3 = new Button(composite_2, SWT.NONE);
            button3.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
            button3.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    set("3");
                }
            });
            button3.setText("3");

            // =
            // 等号は1557年にウェールズの数学者ロバート・レコードによって発明された
            // 彼は『知恵の砥石』という代数学の著書の中で「＝」を用いた
            // 「＝」を用いた理由は、「2本の平行線ほど、等しい物は世の中にはない」とのこと
            // 当時使用されていた等号としては「=」はメジャーではなく、「∥」や「ae」、「?」が使用されていた
            Button equalSign = new Button(composite_2, SWT.NONE);
            equalSign.setFont(SWTResourceManager.getFont("メイリオ", 11, SWT.NORMAL));
            equalSign.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 2));
            equalSign.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    run();
               }
            });
            equalSign.setText("＝");
            equalSign.addListener(SWT.KeyDown, listener);
            equalSign.forceFocus();//起動時=にフォーカス

            // 0
            Button button0 = new Button(composite_2, SWT.NONE);
            button0.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 2, 1));
            button0.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    set("0");
                }
            });
            button0.setText("0");

            // .
            Button arithmeticPoint = new Button(composite_2, SWT.NONE);
            arithmeticPoint.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    set(".");
                }
            });
            arithmeticPoint.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
            arithmeticPoint.setText(".");

    /* ******************************
                         メニューバー
     ********************************/
    Menu menu = new Menu(shell, SWT.BAR);
    shell.setMenuBar(menu);

        /* 表示 */
        MenuItem mntmv = new MenuItem(menu, SWT.CASCADE);
        mntmv.setText("表示(&V)");
        Menu menu_1 = new Menu(mntmv);
        mntmv.setMenu(menu_1);

            // 普通
            MenuItem menuItem_4 = new MenuItem(menu_1, SWT.NONE);
            menuItem_4.setText("普通(&N)\tAlt+1");
            menuItem_4.setAccelerator(SWT.ALT | '1');

            // 関数
            MenuItem menuItem_3 = new MenuItem(menu_1, SWT.NONE);
            menuItem_3.setText("関数(&F)\tAlt+2");
            menuItem_3.setAccelerator(SWT.ALT | '2');
            menuItem_3.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent e){
                    createContentsf();
                    subShell.open();
                    subShell.layout();
                    while (!subShell.isDisposed()) {
                        if (!display.readAndDispatch()) {
                            display.sleep();
                        }
                    }
                }
            });

            // プログラマ
            MenuItem mntmNewItem5 = new MenuItem(menu_1, SWT.NONE);
            mntmNewItem5.setText("プログラマ(&P)\tAlt+3");
            mntmNewItem5.setAccelerator(SWT.ALT | '3');

            // 統計
            MenuItem mntmNewItem = new MenuItem(menu_1, SWT.NONE);
            mntmNewItem.setText("統計(&S)\tAlt+4");
            mntmNewItem.setAccelerator(SWT.ALT | '4');

        /* 編集 */
        MenuItem menuItem_1 = new MenuItem(menu, SWT.CASCADE);
        menuItem_1.setText("編集(&E)");
        Menu menu_2 = new Menu(menuItem_1);
        menuItem_1.setMenu(menu_2);

            // コピー
            /* ニーモニック        Altキーとの組み合わせでメニュー項目を選択する組み合わせ
                アクセラレータ     Ctrlキーとの組み合わせでメニュー項目を直接選択するショートカット
                ニーモニックとアクセラレータの作成は以下のサイトを参照
                http://www.acroquest.co.jp/webworkshop/JavaTroubleshooting/trouble016Phenomenon.html   */
            MenuItem menuItem_5 = new MenuItem(menu_2, SWT.NONE);
            menuItem_5.setText("コピー(&C)\tCtrl+C");
            menuItem_5.setAccelerator(SWT.CTRL | 'C');
            menuItem_5.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent e){
                    copy();
                }
            });

            // 貼り付け
            MenuItem menuItem_6 = new MenuItem(menu_2, SWT.NONE);
            menuItem_6.setText("貼り付け(&V)\tCtrl+V");
            menuItem_6.setAccelerator(SWT.CTRL | 'V');
            menuItem_6.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent e){
                     paste();
                }
            });

            // セパレーター
            new MenuItem(menu_2, SWT.SEPARATOR);

            // 履歴
            MenuItem menuItem_9 = new MenuItem(menu_2, SWT.CASCADE);
            menuItem_9.setText("履歴(&H)");
            Menu menu_4 = new Menu(menuItem_9);
            menuItem_9.setMenu(menu_4);

                // 履歴のコピー
                MenuItem mntmNewItem_1 = new MenuItem(menu_4, SWT.NONE);
                mntmNewItem_1.setText("履歴のコピー");
                mntmNewItem_1.addSelectionListener(new SelectionAdapter() {
                    @Override
                    public void widgetSelected(SelectionEvent e){
                        setClipboardString(history);
                    }
                });

                // 履歴の編集
                MenuItem menuItem_8 = new MenuItem(menu_4, SWT.NONE);
                menuItem_8.setText("編集");

                // 履歴の編集の取り消し
                MenuItem menuItem_11 = new MenuItem(menu_4, SWT.NONE);
                menuItem_11.setText("編集の取り消し");

                // クリア
                MenuItem menuItem_10 = new MenuItem(menu_4, SWT.NONE);
                menuItem_10.setText("クリア");
                menuItem_10.addSelectionListener(new SelectionAdapter() {
                    @Override
                    public void widgetSelected(SelectionEvent e){
                        history = "";
                    }
                });

        /* ヘルプ */
        MenuItem mntmh = new MenuItem(menu, SWT.CASCADE);
        mntmh.setText("ヘルプ(&H)");
        Menu menu_3 = new Menu(mntmh);
        mntmh.setMenu(menu_3);

             // ヘルプ
            MenuItem menuItem_12 = new MenuItem(menu_3, SWT.NONE);
            menuItem_12.setText("ヘルプ(&V)\tF1");
            menuItem_12.setAccelerator(SWT.F1);

            // バージョン情報
            menuItem = new MenuItem(menu_3, SWT.NONE);
            menuItem.setText("バージョン情報(&A)");
            menuItem.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent e){
                    MessageBox mBox = new MessageBox(shell);
                    String MESSAGE = "電卓" + "\n\n" +
                                                "バージョン： " + date() + '\n' +
                                                "作成者：       ame";
                    mBox.setText("バージョン情報");
                    mBox.setMessage(MESSAGE);
                    mBox.open();
                }
            });
    }

    /**
     * Create contents of the Function window.
     */
    private void createContentsf(){
        subShell = new Shell(shell);
        subShell.setText("関数電卓");
        subShell.setSize(198,315);
        subShell.open();
    }

    /**
     * =キー
     */
    private void run(){
        try{
            if(efield == "") return;//式が空なら0を出さないようにする
            history += efield + "\t=";//記録を残す
            exprsLabel.setText(shortening2(efield));//式の表示

            long start = System.currentTimeMillis();
            resultLabel.setText(shortening(shortening2(rmvPoint(efield = calc(paren(addZero(efield)))))));//計算結果の表示
            long stop = System.currentTimeMillis();
            System.out.println(stop-start);//計算時間(debug)

            history += efield + '\n';//記録を残す
        } catch (ArithmeticException e) {
            resultLabel.setText("NaN or Infinity");
            history += "NaN or Infinity\n";//記録を残す
        } catch (NumberFormatException e) {
            resultLabel.setText("NaN or Infinity");
            history += "NaN or Infinity\n";//記録を残す
        } catch (Exception e) {
            e.printStackTrace();
            resultLabel.setText("errorEqual");
            history += "errorEqual\n";//記録を残す
        }
    }

    private void nagate(){
        try {
            if(efield == "") return; // 式が空の場合は、何もしない
            history += "negate("+addZero(efield)+')' + "\t=";//記録を残す
            exprsLabel.setText("negate("+addZero(efield)+')');  // 式の表示
            resultLabel.setText(shortening(rmvPoint(efield = calc("-1*(" + paren(addZero(efield)) + ')'))));//計算結果の表示
            history += efield + '\n';//記録を残す
        } catch (Exception e) {
            exprsLabel.setText("errorNagate");
            history += "errorNagate\n";
        }
    }

    /**
     * BSキー
     */
    private void bs(){
        if(efield == "") return;
        exprsLabel.setText(efield = efield.substring(0, efield.length()-1));
    }

    /**
     * Clearキー
     */
    private void clear(){
        exprsLabel.setText(efield = "");
        resultLabel.setText("");
    }

    /**
     * 計算する
     * return Double.toString(ExpRuleFactory.getDefaultRule().parse(arg).evalDouble());
     */
    private String calc(String arg){
        Node node = new Node(arg);
        node.parse();
        return node.calculate().toPlainString();
    }

    /**
     * 整数の場合は、.0を取り除く
     */
    private String rmvPoint(String arg){
        Matcher matcher = Pattern.compile("(.+)\\.0$").matcher(arg);
        if(matcher.find()){
            return matcher.group(1);
        }
        return arg;
    }

    /**
     * 1未満の小数入力時に0が省略されている場合は、0を加える
     * (ex. .3+.5の場合は、0.3+0.5にする)
     */
    private String addZero(String arg){
        return arg.replaceAll("((?<=.*\\D)|^)(?=\\.)", "0");
    }

    /**
     * 暗示的な括弧の掛け算の場合、明示的なそれに修正する
     */
    private String paren(String arg){
        return arg.replaceAll("(?:(?<=\\d)(?=\\())|(?:(?<=\\))(?=\\())|(?:(?<=\\))(?=\\d))", "*");
    }

    /**
     *	結果が長すぎる場合は、短く丸めて整形する
     */
    public static String shortening(String arg){
        if(arg.length()>DIGIT_NUMBER){
            Matcher matcher = Pattern.compile("(.+)(E\\d+)").matcher(arg);
            if(matcher.find()){
                arg = matcher.group(1).substring(0, DIGIT_NUMBER - matcher.group(2).length())+matcher.group(2);
            }
            else{
                arg = arg.substring(0, DIGIT_NUMBER);
            }
        }
        return arg;
    }

    /**
     * 式の表示部分が長すぎる場合は、短く丸めて整形する
     */
    public static String shortening2(String arg){
        String regex = "^([1-9][1-9]{0,5})0{1,}";
        Matcher matcher = Pattern.compile(regex).matcher(arg.substring(1));
        if(arg.length()>DIGIT_NUMBER && arg.matches("^(\\d)+$")){//桁数が表示可能桁数を超えている かつ 数字のみで構成されている
            if(arg.substring(1,DIGIT_NUMBER).matches("^0{11,}"))//2桁目以降に0が11個以上続いている
                return arg.substring(0,1) + '.' + '0' + 'E' + (arg.length()-1);//(1000000000000333 → 1.0E15)
            else
            	if(matcher.find())//2桁目以降に1から9までの数が0個から6個まできて、その後0が1個以上続いている
                return arg.substring(0,1) + '.' + matcher.group(1) +  'E' + (arg.length()-1);
            else
                return arg.substring(0,1) + '.' + arg.substring(1,DIGIT_NUMBER) + 'E'+ (arg.length()-1);
        }
        return arg;
    }

    /**
     *  フィールドに書き込みラベルを表示
     *  その際、桁数が多すぎる場合は入力を無視する
     */
    private void set(String arg){
        if(efield.length() <= DIGIT_NUMBER+5+1000){//桁あふれ防止
            exprsLabel.setText(efield += arg);
        }
    }

    /**
     * (仮)
     * @return
     */
    private String date(){
       try {
        Calendar cal1 = Calendar.getInstance();  //(1)オブジェクトの生成
        int year = cal1.get(Calendar.YEAR);        //(2)現在の年を取得
        int month = cal1.get(Calendar.MONTH) + 1;  //(3)現在の月を取得
        int day = cal1.get(Calendar.DATE);         //(4)現在の日を取得
        int hour = cal1.get(Calendar.HOUR_OF_DAY); //(5)現在の時を取得
        int minute = cal1.get(Calendar.MINUTE);    //(6)現在の分を取得
        int second = cal1.get(Calendar.SECOND);    //(7)現在の秒を取得

        StringBuffer dow = new StringBuffer();
        switch (cal1.get(Calendar.DAY_OF_WEEK)) {  //(8)現在の曜日を取得	          case Calendar.SUNDAY: dow.append("日曜日"); break;
            case Calendar.MONDAY: dow.append("月曜日"); break;
            case Calendar.TUESDAY: dow.append("火曜日"); break;
            case Calendar.WEDNESDAY: dow.append("水曜日"); break;
            case Calendar.THURSDAY: dow.append("木曜日"); break;
            case Calendar.FRIDAY: dow.append("金曜日"); break;
            case Calendar.SATURDAY: dow.append("土曜日"); break;
        }

        //(9)現在の年、月、日、曜日、時、分、秒
        return year + "/" + month + "/" + day + " " + dow + " " + hour + ":" + minute + ":" + second;
       } catch (Exception e) {
           return "";
       }
    }

    /**
     * クリップボードへ文字列を渡す
     */
    private static void setClipboardString(String str) {
        java.awt.datatransfer.Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(str);
        clipboard.setContents(stringSelection, stringSelection);
    }

    private void paste(){
        Clipboard clipboard = new Clipboard(display);
        exprsLabel.setText(efield = clipboard.getContents(TextTransfer.getInstance()).toString());
    }

    private void copy(){
        Clipboard clipboard = new Clipboard(display);
        clipboard.setContents(new Object[]{efield},new Transfer[]{TextTransfer.getInstance()});
    }
}
