/******************************************
作成日：2013/12/09

 ******************************************/
package swtDentaku;

import static org.junit.Assert.*;

import java.math.BigDecimal;

import org.junit.Test;

/**
 * @author ame
 *
 */
public class NodeTest {

    @Test
    public void test() {
        try {
            String expression = "-1*5*(3+4)";
            Node node = new Node(expression);
            node.parse();
            System.out.println(node.calculate());
            assertEquals(-35, node.calculate().doubleValue(),0.5);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void test1() {
        try {
            String expression = "-1*5*(3+4)-.00000000000054654";
            Node node = new Node(expression);
            node.parse();
            System.out.println(node.calculate());
            assertEquals(-35, node.calculate().doubleValue(),0.00000000001);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @Test
    public void test2() {
        try {
            String expression = "-.00000000000054654";
            System.out.println(new BigDecimal(expression));
            System.out.println(new BigDecimal(expression).toPlainString());
            System.out.println(new BigDecimal(expression).hashCode());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void test3() {
        try {
            System.out.println(1^0);
            System.out.println(1^2);
            System.out.println(1^10);
            System.out.println(Math.pow(1, 0));
            System.out.println(Math.pow(1, 2));
            System.out.println(Math.pow(2, 3.1));
            System.out.println(Math.pow(2, -1));
            System.out.println(Math.pow(2, 3.1));
            System.out.println(Integer.MAX_VALUE);
            System.out.println(Double.MIN_VALUE);
            System.out.println(Double.MAX_VALUE);
            System.out.println("45.56".matches("[^.]*"));
            System.out.println("4556".matches("[^.]*"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @Test
    public void test4() {
        try {
            String expression = "10^1000000000";
            Node node = new Node(expression);
            node.parse();
            System.out.println(node.calculate());
            assertEquals(-35, node.calculate().doubleValue(),0.00000000001);
        } catch (Exception e) {
            System.out.println("Infinite or NaN"+e.getMessage());
        }
    }
    
    @Test
    public void test5() {
        try {
            String expression = "10^1000000000";
            Node node = new Node(expression);
            node.parse();
            System.out.println(node.calculate());
            assertEquals(-35, node.calculate().doubleValue(),0.00000000001);
        } catch (Exception e) {
            System.out.println("Infinite or NaN"+e.getMessage());
        }
    }
}
