package swtDentaku;

import java.math.BigDecimal;

class Node {
    public String expression;
    public Node left = null;
    public Node right = null;

    public Node(String expression) {
        this.expression = expression;
    }

    /******************
                  解析
     ******************/
    public void parse() {
        int posOperator = getOperatorPos(expression);// 演算子の位置

        // 演算子の位置が0より小さければ、子ノードをNULLにして戻る
        if (posOperator < 0) {
            left = null;
            right = null;
        }

        // 演算子の位置が0なら、
        if (posOperator == 0) {

            // 単項演算子の右側の文字列を新規左子ノードに入力
            left = new Node(removeBracket(this.expression.substring(1)));
            left.parse();

            // 右子ノードをNULLにする
            right = null;

            // 単項演算子を節点として自分自身に入力
            this.expression = this.expression.substring(0,1);
        }

        // 演算子の位置が0より大きければ、
        if(posOperator >0) {

            // 左辺に演算子の左側の文字列を新規左子ノードに入力
            left = new Node(removeBracket(this.expression.substring(0, posOperator)));
            left.parse();

            // 右辺に演算子の右側の文字列を新規右子ノードに入力
            right = new Node(removeBracket(this.expression.substring(posOperator + 1)));
            right.parse();

            // 演算子を節点として自分自身に入力
            this.expression = this.expression.substring(posOperator, posOperator + 1);
        }
    }

    /*************************************
                            ()を取り除く
                        対応チェックもあり
     *************************************/
    private static String removeBracket(String str) {

        // 1. もし、()で囲まれていなければ、文字列をそのまま帰す
        if (!(str.startsWith("(") && str.endsWith(")")))
            return str;

        // 2. もし、()で囲まれていれば、括弧の対応を確認するために、以下の処理を行う
        else{

            // 2.1. nestを1にする
            int nest = 1;

            // 2.2. 文字列の2個めから最後から1つ前の文字までに以下の処理を行う
            for (int i = 1; i < str.length() - 1; i++) {

                // 2.2.1. もし文字が(なら、nestをインクリメントする
                if (str.charAt(i) == '(')
                    nest++;

                // 2.2.2. もし文字が)なら、nestをデクリメントする
                else if (str.charAt(i) == ')')
                    nest--;

                // 2.2.3. もしnestが0なら、文字列を返す（もうカッコはない）
                if (nest == 0)
                    return str;
            }

            // 2.3. もしnestが1でなければ、ランタイムエラーを生成する
            if (nest != 1)
                throw new RuntimeException("unbalanced bracket: " + str);

            // 2.4. もしnestが1なら、以下の処理を行う
            else {

                // 2.4.1. 文字列を2つめの文字から最後から1つ前の文字までで上書きする
                str = str.substring(1, str.length() - 1);

                // 2.4.2. もしも、(で始まっていれば、再帰的にこのメソッドを呼び出す
                if (str.startsWith("("))
                    return removeBracket(str);

                // 2.4.3. そうでなければ、2.4で加工した文字列を返す
                else
                    return str;
            }
        }
    }

    /****************************************
                 最も低い優先順位の演算子を選び出す
     ****************************************/
    private static int getOperatorPos(String expression) {
        if (expression == null || expression.length() == 0)
            return -1;

        int pos = -1;
        int nest = 0;
        int priority = 0;// 単項演算子を最大にする
        int lowestPriority = 6;//優先度を最大で初期化する

        for (int i = 0; i < expression.length(); i++) {
            switch (expression.charAt(i)) {
            case '=':
                priority = 1;
                break;
            case '+':
                if(i==0){
                    priority = 4;//(単項演算子)
                    break;
                }
                priority = 2;
                break;
            case '-':
                if(i==0){
                    priority = 4;//(単項演算子)
                    break;
                }
                priority = 2;
                break;
            case '*':
                priority = 3;
                break;
            case '/':
                priority = 3;
                break;
            case '^':
                priority = 5;
                break;
            case '(':
                nest++;
                continue;
            case ')':
                nest--;
                continue;
            default:
                continue;
            }

            // nestが0かつ優先度が最も低い優先度以下ならば、最も低い優先度を更新し
            // 演算子の位置を変更する
            if (nest == 0 && priority <= lowestPriority) {
                lowestPriority = priority;
                pos = i;
            }
        }

        return pos;
    }

    /*************************
             ポストオーダーで探査
     *************************/
    public void traversePostorder() {
        if (left != null)
            left.traversePostorder();
        if (right != null)
            right.traversePostorder();

        System.out.print(expression);
    }


    /*************************
            インオーダーで探査
     *************************/
    public void traverseInorder() {
        if (left != null && right != null)
            System.out.print("(");

        if (left != null)
            left.traverseInorder();

        System.out.print(expression);

        if (right != null)
            right.traverseInorder();

        if (left != null && right != null)
            System.out.print(")");
    }

    /*************************
            プリオーダーで探査
     *************************/
    public void traversePreorder() {
        System.out.print(expression);

        if (left != null)
            left.traversePreorder();
        if (right != null)
            right.traversePreorder();
    }

    /*************************
                      計算
     *************************/
    public BigDecimal calculate() {

        if(left != null && right == null){
            if(expression.equals("+"))
                return left.calculate().plus();
            if(expression.equals("-"))
                return left.calculate().negate();
        }

        if (left != null && right != null) {
            if (expression.equals("+"))
                return left.calculate().add(right.calculate());
            else if (expression.equals("-"))
                return left.calculate().subtract(right.calculate());
            else if (expression.equals("*"))
                return left.calculate().multiply(right.calculate());
            else if (expression.equals("/"))
                return new BigDecimal(left.calculate().doubleValue() / right.calculate().doubleValue());
            else if (expression.equals("^"))//(課題：BigDecimalのpowは0と正の整数しか扱えない。どう精度を稼ぐ？)
                if(left.calculate().doubleValue()>Double.MAX_VALUE && 0 <= right.calculate().intValue() && right.calculate().intValue()<=999999999 &&
                        right.calculate().toPlainString().matches("[^.]*"))//累乗根がDoubleの最大値より大きい かつ 冪指数が正の整数かつ999999999より小さい
                    return left.calculate().pow(right.calculate().intValue());//ときに限り、BigDecimalのpowを使用
                else if(right.calculate().doubleValue()>=-Double.MAX_VALUE && right.calculate().doubleValue()<=Double.MAX_VALUE)//通常は冪指数として負や小数をとれるMath.powを使う （ただし、精度がDoubleまで落ちる）
                    return new BigDecimal(Math.pow(left.calculate().doubleValue(),right.calculate().doubleValue()));
                else
                    return new BigDecimal("NaN");
            else{
                throw new RuntimeException("計算段階に未定義の演算子または節点が存在している");
            }
        }

        if(left == null && right != null){
            throw new RuntimeException("存在しないよう設計された右子ノードを持っている");
        }

        return new BigDecimal(expression);
    }
}
