/******************************************
作成日：2013/12/04

 ******************************************/
package swtDentaku;

import static org.junit.Assert.*;
import org.junit.Test;
/**
 * @author ame
 *
 */
public class ExpressionTest implements Constants{



    /**
     * {@link swtDentaku.Expression#TreeNode(java.lang.String, swtDentaku.Expression, swtDentaku.Expression)} のためのテスト・メソッド。
     */
    @Test
    public void testTreeNode() {
        String DUMMY = "";
        Expression expression = new Expression(BINARY_OPERATOR,DUMMY, null, null);
        expression.right=new Expression(CONSTANT,"1", null, null);
        expression.right.left=new Expression(CONSTANT,"2", null, null);
        expression.right.right=new Expression(UNARY_OPERATOR,"3", null, null);
        assertEquals("2", expression.right.left.node);
        assertEquals(CONSTANT, expression.right.left.type);
    }

    // 二項演算子テスト
    @Test
    public void TestS(){
        assertEquals(true, new String("5+3").matches("[0-9](\\+|\\-|\\*|\\/)[0-9]"));
    }

    // 単項演算子テスト
    @Test
    public void TestA(){
        assertEquals(true, new String("+3").matches("(\\+|\\-)[0-9]"));
    }

    // 単項演算子テスト２
    @Test
    public void TestA2(){
        assertEquals(true, new String("+(55)").matches("(\\+|\\-)\\(?[0-9]+\\)?"));
    }

    // 単項演算子テスト3
    @Test
    public void TestA3(){
        assertEquals(true, new String("+(55+32+(88*54))").matches("(\\+|\\-)\\(*\\d+((\\+|\\-|\\*|\\/)\\(*[0-9]+\\)*)*"));
        assertEquals(true, new String("-(55+32+(88*54))").matches("(\\+|\\-)\\(*\\d+((\\+|\\-|\\*|\\/)\\(*[0-9]+\\)*)*"));
        assertEquals(true, new String("+5").matches("(\\+|\\-)\\(*\\d+((\\+|\\-|\\*|\\/)\\(*[0-9]+\\)*)*"));
        assertEquals(true, new String("+(55+32+(88*54(3)))").matches("(\\+|\\-)\\(*\\d+(((\\+|\\-|\\*|\\/)|\\()\\(*[0-9]+\\)*)*"));
        assertEquals(true, new String("+(55+32+(88*54))").matches("(\\+|\\-)\\(*\\d+((\\+|\\-|\\*|\\/)\\(*[0-9]+\\)*)*"));
    }

    // 単項演算子テスト位置
    @Test
    public void TestB1(){
        assertEquals(0,Expression.getOperatorPos("-3"));
        assertEquals(0,Expression.getOperatorPos("-3(3*3)"));
    }

    // 単項演算子テストnode
    @Test
    public void TestB2(){
        Expression expression = new Expression(UNKNOWN, "-5", null, null);
        expression.parse();
        assertEquals(expression.type, UNARY_OPERATOR);
        assertEquals('-',expression.node.charAt(0));
        System.out.println(expression.calcValue());
    }

    // 単項演算子テストnode
    @Test
    public void TestB3(){
        Expression expression2 = new Expression(UNKNOWN, "+5*(3+4)", null, null);
        expression2.parse();
        assertEquals(expression2.type, UNARY_OPERATOR);
        assertEquals('+',expression2.node.charAt(0));
        System.out.println(expression2.node+expression2.type);
        System.out.println(expression2.left.node+expression2.left.type);
        System.out.println(expression2.left.left.node+expression2.left.left.type);
        System.out.println(expression2.left.right.node+expression2.left.right.type);
        System.out.println(expression2.left.right.left.node+expression2.left.right.left.type);
        System.out.println(expression2.left.right.right.node+expression2.left.right.right.type);
        System.out.println(expression2.calcValue());

    }

    // 単項演算子テストnode
    @Test
    public void TestB4(){
    }

    // 単項演算子テストnode
    @Test
    public void TestB5(){
    }



}
