/******************************************
作成日：2013/12/04

 ******************************************/
package swtDentaku;

public class Expression implements Constants {
    char type;
    String node;
    Expression left;
    Expression right;

    /******************************************
     * コンストラクタ
     ******************************************/
    Expression(char type, String expression, Expression left, Expression right) {

        // データを保存する
        this.type = type;
        this.node = expression;
        this.left = left;
        this.right = right;
    }

    /******************************************
     * 式の文字列を取り出す
     ******************************************/
    public String getExpression() {
        return node;
    }

    /********************************
     * 解析
     ********************************/
    public void parse() {
        int posOperator = getOperatorPos(node); // 演算子の位置

        // 演算子の位置が-1以下の場合は、定数値か変数のため子ノードをNULLにして戻る
        if (posOperator < 0) {
            if (this.node.matches("\\d+"))
                this.type = CONSTANT;
            else
                this.type = VARIABLE;
            left = null;
            right = null;
            return;
        }

        // 単項演算子の場合は、タイプを単項演算子にし、式を左の子として生成する
        if (node.matches("(\\+|\\-)\\(*\\d+(((\\+|\\-|\\*|\\/)|\\()\\(*[0-9]+\\)*)*")) {
            type = UNARY_OPERATOR;
            left = new Expression(UNKNOWN,
                    node.substring(1, this.node.length()), null, null);
            left.parse();

            // 演算子を接点として自分自身に入力
            this.node = this.node.substring(0, 1);

            // 二項演算子の場合は、以下の処理を行う
        } else {

            // タイプを二項演算子に設定する
            type = BINARY_OPERATOR;

            // 左辺に演算子の左側の文字列を新規左子ノードに入力
            left = new Expression(UNKNOWN, removeBracket(this.node.substring(0,
                    posOperator)), null, null);
            left.parse();

            // 右辺に演算子の左側の文字列を新規右子ノードに入力
            right = new Expression(UNKNOWN,
                    removeBracket(this.node.substring(posOperator + 1)), null,
                    null);
            right.parse();

            // 演算子を接点として自分自身に入力
            this.node = this.node.substring(posOperator, posOperator + 1);
        }
    }

    /*************************************
     * ()を取り除く 対応チェックもあり
     *************************************/
    private static String removeBracket(String str) {

        // 1. もし、()で囲まれていなければ、文字列をそのまま帰す
        if (!(str.startsWith("(") && str.endsWith(")")))
            return str;

        // 2. もし、()で囲まれていれば、括弧の対応を確認するために、以下の処理を行う
        else {

            // 2.1. nestを1にする
            int nest = 1;

            // 2.2. 文字列の2個めから最後から1つ前の文字までに以下の処理を行う
            for (int i = 1; i < str.length() - 1; i++) {

                // 2.2.1. もし文字が(なら、nestをインクリメントする
                if (str.charAt(i) == '(')
                    nest++;

                // 2.2.2. もし文字が)なら、nestをデクリメントする
                else if (str.charAt(i) == ')')
                    nest--;

                // 2.2.3. もしnestが0なら、文字列を返す（なんで？）
                if (nest == 0)
                    return str;
            }

            // 2.3. もしnestが1でなければ、ランタイムエラーを生成する
            if (nest != 1)
                throw new RuntimeException("unbalanced bracket: " + str);

            // 2.4. もしnestが1なら、以下の処理を行う
            else {

                // 2.4.1. 文字列を2つめの文字から最後から1つ前の文字までで上書きする
                str = str.substring(1, str.length() - 1);

                // 2.4.2. もしも、(で始まっていれば、再帰的にこのメソッドを呼び出す
                if (str.startsWith("("))
                    return removeBracket(str);

                // 2.4.3. そうでなければ、2.4で加工した文字列を返す
                else
                    return str;
            }
        }
    }

    /****************************************
     * 最も低い優先順位の演算子を選び出す
     ****************************************/
    public static int getOperatorPos(String expression) {
        if (expression == null || expression.length() == 0)
            return -1;

        int pos = -1;
        int nest = 0;
        int priority = 0;
        int lowestPriority = 5;

        for (int i = 0; i < expression.length(); i++) {
            switch (expression.charAt(i)) {
            case '=':
                priority = 1;
                break;
            case '+':
                priority = 2;
                break;
            case '-':
                priority = 2;
                break;
            case '*':
                priority = 3;
                break;
            case '/':
                priority = 3;
                break;
            case '(':
                nest++;
                continue;
            case ')':
                nest--;
                continue;
            default:
                continue;
            }

            // nestが0かつ優先度が最も低い優先度以下ならば、最も低い優先度を更新し
            // 演算子の位置を変更する
            if (nest == 0 && priority <= lowestPriority) {
                lowestPriority = priority;
                pos = i;
            }
        }
        return pos;
    }

    /**************************************
     * 計算
     **************************************/
    public double calcValue() {

        // 来たところがnullでなければいろいろ返す
        if (this != null) {

            // 単項演算値を返す
            if (this.type == UNARY_OPERATOR) {
                if (this.node == "+") {
                    return left.calcValue();
                }
                if (this.node == "-") {
                    return (-1) * left.calcValue();
                }
            }

            // 二項演算値を返す
            if (this.type == BINARY_OPERATOR) {
                double leftOperand = left.calcValue();
                double rightOperand = right.calcValue();
                switch (this.node) {
                case "+":
                    return leftOperand + rightOperand;
                case "-":
                    return leftOperand - rightOperand;
                case "*":
                    return leftOperand * rightOperand;
                case "/":
                    return leftOperand / rightOperand;
                default:
                    return 0.0;
                }
            }
        }

        // 定数値を返す
        return Double.parseDouble(this.node);
    }
}
