/******************************************
作成日：2013/12/04

 ******************************************/
package swtDentaku;
import swtDentaku.Constants;

public class CalculationValue implements Constants {
    public double calcValue(Expression expression) {

        // 来たところがnullでなければいろいろ返す
        if(expression != null){

            // 左へたどる
            calcValue(expression.left);

            // 定数値を返す
            if(expression.type == CONSTANT){
                return Double.parseDouble(expression.node);
            }

            // 変数値を返す
            if(expression.type == VARIABLE){
                return DUMMY;
            }

            // 単項演算値を返す
            if(expression.type == UNARY_OPERATOR){
                if(expression.node == "+"){
                    return calcValue(expression.left);
                }
                if(expression.node == "-"){
                    return (-1) * calcValue(expression.left);
                }
            }

            // 二項演算値を返す
            if(expression.type == BINARY_OPERATOR){
                switch (expression.node) {
                case "+":
                    return calcValue(expression.left)+calcValue(expression.right);
                case "-":
                    return calcValue(expression.left)-calcValue(expression.right);
                case "*":
                    return calcValue(expression.left)*calcValue(expression.right);
                case "/":
                    return calcValue(expression.left)/calcValue(expression.right);
                }

                // 右へたどる
                calcValue(expression.right);
            }
        }
        return DUMMY;
    }


}
