package jp.hishidama.util;

public class CharUtil {

	/**
	 * GXP[v.
	 * <p>
	 * GXP[vu\v߂ԂB
	 * </p>
	 * 
	 * @param str
	 *            
	 * @return GXP[vߌ㕶
	 */
	public static String escapeString(String str) {
		return escapeString(str, 0, str.length());
	}

	/**
	 * GXP[v.
	 * <p>
	 * GXP[vu\v߂ԂB
	 * </p>
	 * 
	 * @param str
	 *            
	 * @param pos
	 *            Jnʒu
	 * @param len
	 *            钷
	 * @return GXP[vߌ㕶
	 */
	public static String escapeString(String str, int pos, int len) {
		StringBuilder sb = new StringBuilder(len);
		int end_pos = pos + len;
		int[] ret = new int[1];
		while (pos < end_pos) {
			char c = escapeChar(str, pos, end_pos, ret);
			if (ret[0] <= 0) {
				break;
			}
			sb.append(c);
			pos += ret[0];
		}
		return sb.toString();
	}

	/**
	 * GXP[vߌ㕶擾.
	 * <p>
	 * 񒆂̕ԂBu\v΁AGXP[v߂ԂB
	 * </p>
	 * 
	 * @param str
	 *            
	 * @param pos
	 *            ߈ʒu
	 * @param end_pos
	 *            ߏIʒuïʒuɂ镶͉ߑΏۊOj
	 * @param ret
	 *            ret[0]:gp
	 * @return ߂
	 */
	public static char escapeChar(String str, int pos, int end_pos, int[] ret) {
		if (pos >= end_pos) {
			ret[0] = 0;
			return '\0';
		}
		char c = str.charAt(pos);
		if (c != '\\') {
			ret[0] = 1;
			return c;
		}

		if (++pos >= end_pos) {
			ret[0] = 1;
			return c; // 㑱ꍇ'\'̂̂ԂƂɂ
		}

		ret[0] = 2;
		c = str.charAt(pos);
		switch (c) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7': {
			long code = c - '0';
			for (int i = 1; i < 3 && ++pos < end_pos; i++) {
				c = str.charAt(pos);
				if (c < '0' || c > '7') {
					break;
				}
				ret[0]++;
				code *= 8;
				code += c - '0';
			}
			return (char) code;
		}
		case 'b':
			return '\b';
		case 'f':
			return '\f';
		case 'n':
			return '\n';
		case 'r':
			return '\r';
		case 't':
			return '\t';
		case 'u': {
			long code = 0;
			for (int i = 0; i < 4 && ++pos < end_pos; i++) {
				c = str.charAt(pos);
				if ('0' <= c && c <= '9') {
					ret[0]++;
					code *= 16;
					code += c - '0';
				} else if ('a' <= c && c <= 'f') {
					ret[0]++;
					code *= 16;
					code += c - 'a' + 10;
				} else if ('A' <= c && c <= 'F') {
					ret[0]++;
					code *= 16;
					code += c - 'A' + 10;
				} else {
					break;
				}
			}
			return (char) code;
		}
		default:
			// ̑́̕Â̂ԂƂɂ
			return c;
		}

	}
}
