package jp.hishidama.lang.reflect.conv;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

/**
 * ^ϊIuWFNgǗNX.
 *
 * @author <a target="hishidama"
 *         href="http://www.ne.jp/asahi/hishidama/home/tech/soft/java/eval16.html"
 *         >Ђ</a>
 * @since 2010.02.16
 */
public class TypeConverterManager {

	/**
	 * ^ϊIuWFNg擾.
	 *
	 * @param clazz
	 *            ϊ̌^
	 * @return ^ϊIuWFNg
	 */
	public TypeConverter getConverter(Class<?> clazz) {
		if (clazz.isArray()) {
			return new ArrayConverter(clazz, this);
		}

		TypeConverter conv = findConverter(clazz);
		if (conv == null) {
			conv = getDefaultConverter(clazz);
		}
		return conv;
	}

	/**
	 * o^Ă^ϊIuWFNgԂB
	 *
	 * @param clazz
	 *            ϊ̌^
	 * @return ^ϊIuWFNgiȂꍇnullj
	 */
	protected TypeConverter findConverter(Class<?> clazz) {
		Map<Class<?>, TypeConverter> map = getConverterMap();

		if (map.containsKey(clazz)) {
			return map.get(clazz);
		}
		if (clazz == Object.class) {
			return ObjectConverter.INSTANCE;
		}

		// eNXT
		for (Entry<Class<?>, TypeConverter> entry : map.entrySet()) {
			Class<?> c = entry.getKey();
			if (c.isAssignableFrom(clazz)) {
				TypeConverter conv = entry.getValue();
				map.put(clazz, conv);
				return conv;
			}
		}

		map.put(clazz, null);
		return null;
	}

	/**
	 * o^ĂȂNX̏ꍇ̏sB
	 *
	 * @param clazz
	 *            ϊ̌^
	 * @return ^ϊIuWFNg
	 */
	protected TypeConverter getDefaultConverter(Class<?> clazz) {
		return new TypeCheckConverter(clazz);
	}

	protected Map<Class<?>, TypeConverter> MAP = null;

	/**
	 * ^ϊIuWFNg}bv擾.
	 * <p>
	 * CX^XB̃}bvԂB
	 * </p>
	 *
	 * @return }bv
	 */
	public Map<Class<?>, TypeConverter> getConverterMap() {
		if (MAP == null) {
			Map<Class<?>, TypeConverter> map = new HashMap<Class<?>, TypeConverter>(
					32);
			initConverterMap(map);
			MAP = map;
		}
		return MAP;
	}

	/**
	 * ׂ̈ɈxĂ΂B
	 *
	 * @param map
	 *            Ώ
	 */
	protected void initConverterMap(Map<Class<?>, TypeConverter> map) {
		map.put(boolean.class, BooleanConverter.INSTANCE);
		map.put(Boolean.class, BooleanConverter.INSTANCE);

		map.put(byte.class, ByteConverter.INSTANCE);
		map.put(Byte.class, ByteConverter.INSTANCE);

		map.put(char.class, CharacterConverter.INSTANCE);
		map.put(Character.class, CharacterConverter.INSTANCE);

		map.put(double.class, DoubleConverter.INSTANCE);
		map.put(Double.class, DoubleConverter.INSTANCE);

		map.put(File.class, FileConverter.INSTANCE);

		map.put(float.class, FloatConverter.INSTANCE);
		map.put(Float.class, FloatConverter.INSTANCE);

		map.put(int.class, IntegerConverter.INSTANCE);
		map.put(Integer.class, IntegerConverter.INSTANCE);

		map.put(long.class, LongConverter.INSTANCE);
		map.put(Long.class, LongConverter.INSTANCE);

		map.put(Map.class, MapConverter.INSTANCE);
		// map.put(Object.class, ObjectConverter.INSTANCE);

		map.put(short.class, ShortConverter.INSTANCE);
		map.put(Short.class, ShortConverter.INSTANCE);

		map.put(String.class, StringConverter.INSTANCE);
		map.put(URI.class, URIConverter.INSTANCE);
	}
}
