package jp.hishidama.lang.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import jp.hishidama.lang.IllegalArgumentLengthException;
import jp.hishidama.lang.reflect.conv.TypeConverter;
import jp.hishidama.lang.reflect.conv.TypeConverterManager;

/**
 * \bhĂяoNX.
 * <p>
 * ̌^𓖊Y\bhpɕϊă\bhĂяoB
 * </p>
 *
 * @author <a target="hishidama"
 *         href="http://www.ne.jp/asahi/hishidama/home/tech/soft/java/eval16.html"
 *         >Ђ</a>
 * @since 2010.02.16
 */
public class Invoker {

	protected String name;

	protected Method method;

	protected TypeConverter objConv;

	protected TypeConverter[] convs;

	/**
	 * RXgN^[.
	 *
	 * @param name
	 *            O
	 * @param clazz
	 *            ĂяoΏۃNX
	 * @param method
	 *            ĂяoΏۃ\bh
	 * @param manager
	 *            ^ϊǗNX
	 */
	public Invoker(String name, Class<?> clazz, Method method,
			TypeConverterManager manager) {
		this.name = name;
		this.method = method;

		initObjectConverter(clazz, manager);
		initArgsConverter(manager);
	}

	protected void initObjectConverter(Class<?> clazz,
			TypeConverterManager manager) {
		objConv = manager.getConverter(clazz);
	}

	protected void initArgsConverter(TypeConverterManager manager) {
		Class<?>[] types = method.getParameterTypes();
		convs = getArgsConverter(types, manager);
	}

	protected TypeConverter[] getArgsConverter(Class<?>[] types,
			TypeConverterManager manager) {
		TypeConverter[] convs = new TypeConverter[types.length];
		for (int i = 0; i < convs.length; i++) {
			TypeConverter conv = manager.getConverter(types[i]);
			if (conv == null) {
				StringBuilder sb = new StringBuilder(64);
				sb.append(name);
				sb.append(" class=");
				sb.append(types[i]);
				throw new UnsupportedOperationException(sb.toString());
			}
			convs[i] = conv;
		}
		return convs;
	}

	/**
	 * O擾.
	 *
	 * @return O
	 */
	public String getName() {
		return name;
	}

	/**
	 * ̌^ϊIuWFNg擾.
	 *
	 * @return ^ϊIuWFNg
	 */
	public TypeConverter[] getTypeConverter() {
		return convs;
	}

	/**
	 * \bhĂяo.
	 * <p>
	 * YIuWFNgŊǗĂ郁\bhĂяoB<br>
	 * ΏۃIuWFNǵAYIuWFNg̃NXɕϊB<br>
	 * eAY\bḧ̌^ɕϊB
	 * </p>
	 *
	 * @param obj
	 *            ΏۃIuWFNg
	 * @param args
	 *            \bḧ
	 * @return Ăяol
	 * @throws IllegalArgumentLengthException
	 *             ̌Y\bȟƈvȂꍇ
	 * @throws Exception
	 *             \bhĂяo̗O
	 */
	public Object invoke(Object obj, Object... args) throws Exception {
		checkArgs(args);
		obj = objectConvert(obj);

		Object[] cargs = new Object[convs.length];
		for (int i = 0; i < convs.length; i++) {
			TypeConverter conv = convs[i];
			cargs[i] = conv.convert(args[i]);
		}

		return method.invoke(obj, cargs);
	}

	protected void checkArgs(Object... args) {
		if (args.length != convs.length) {
			throw new IllegalArgumentLengthException(name, args.length,
					convs.length, convs.length);
		}
	}

	@SuppressWarnings("unchecked")
	protected <T> T objectConvert(Object obj) {
		if (isStatic()) {
			return null;
		}
		if (objConv != null) {
			obj = objConv.convert(obj);
		}
		return (T) obj;
	}

	protected boolean isStatic() {
		if (method == null) {
			return false;
		}
		return Modifier.isStatic(method.getModifiers());
	}
}