package jp.hishidama.lang.reflect;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.hishidama.lang.IllegalArgumentLengthException;
import jp.hishidama.lang.reflect.conv.TypeConverter;
import jp.hishidama.lang.reflect.conv.TypeConverterManager;

/**
 * \bhĂяo[eBeB[.
 * <p>
 * w肳ꂽÕ\bhĂяo[eBeB[B
 * </p>
 * <p>
 * ܂AĂяoNX̃\bhǗp̖Otēo^B<br>
 * āÅǗp̖OŃ\bhĂяoB<br>
 * ̂ƂAIuWFNǧ^͌Ăяo\bhɍv^ɕϊB
 * </p>
 * <p>
 * I[o[[hĂ郁\bh̏ꍇǍvĂ郁\bh1΁AĂяoB<br>
 * ꍇAȂׂ^vĂ郁\bhĂяoiȂKɃ}b`Ă̂ŁAȂɌł͂ȂcjB
 * </p>
 *
 * @author <a target="hishidama"
 *         href="http://www.ne.jp/asahi/hishidama/home/tech/soft/java/eval16.html"
 *         >Ђ</a>
 * @since 2010.02.16
 */
public class InvokeUtil {

	protected TypeConverterManager manager;

	protected Map<String, Methods> MAP = new HashMap<String, Methods>();

	/**
	 * RXgN^[.
	 */
	public InvokeUtil() {
		this(new TypeConverterManager());
	}

	/**
	 * RXgN^[.
	 *
	 * @param manager
	 *            ^ϊIuWFNgǗNX
	 */
	public InvokeUtil(TypeConverterManager manager) {
		this.manager = manager;
	}

	/**
	 * ^ϊIuWFNgǗNX擾.
	 *
	 * @return ^ϊIuWFNgǗNX
	 */
	public TypeConverterManager getConverterManager() {
		return manager;
	}

	/**
	 * \bho^.
	 * <p>
	 * w肳ꂽNX̑S\bhǗΏۂɒǉB<br>
	 * Ǘp̖Oɂ́A\bh̑OɎw肳ꂽړtB
	 * </p>
	 *
	 * @param clazz
	 *            NX
	 * @param prefix
	 *            O̐ړ
	 * @see #addMethod(Class, String, Method)
	 */
	public void addMethods(Class<?> clazz, String prefix) {
		for (Method m : clazz.getMethods()) {
			addMethod(clazz, prefix + m.getName(), m);
		}
	}

	/**
	 * \bho^.
	 *
	 * @param clazz
	 *            ΏۃNX
	 * @param name
	 *            Ǘp̖O
	 * @param method
	 *            \bh
	 * @see #addInvoker(String, Invoker)
	 */
	public void addMethod(Class<?> clazz, String name, Method method) {
		addInvoker(name, new Invoker(name, clazz, method, manager));
	}

	/**
	 * \bhĂяoNXo^.
	 *
	 * @param name
	 *            Ǘp̖O
	 * @param invoker
	 *            \bhĂяoNX
	 */
	public void addInvoker(String name, Invoker invoker) {
		Methods mm = MAP.get(name);
		if (mm == null) {
			mm = createMethods(name);
			MAP.put(name, mm);
		}
		mm.add(invoker);
	}

	protected Methods createMethods(String name) {
		return new Methods();
	}

	/**
	 * \bhĂяo.
	 *
	 * @param name
	 *            Ǘp̖O
	 * @param obj
	 *            ΏۃIuWFNg
	 * @param args
	 *            
	 * @return \bh̖߂l
	 * @throws UnsupportedOperationException
	 *             ǗΏۊO̖Ȍꍇ
	 * @throws RuntimeException
	 *             \bhĂяoɔO
	 */
	public Object invoke(String name, Object obj, Object... args) {
		Methods mm = MAP.get(name);
		if (mm == null) {
			throw new UnsupportedOperationException("name=" + name);
		}
		try {
			Invoker v = mm.getInvoker(args, BOTH, false);
			return v.invoke(obj, args);
		} catch (RuntimeException e) {
			throw e;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * CX^X\bhĂяoNX擾.
	 *
	 * @param name
	 *            Ǘp̖O
	 * @param args
	 *            
	 * @return \bhĂяoNXiȂꍇAnullj
	 * @throws UnsupportedOperationException
	 *             ǗΏۊO̖Ȍꍇ
	 */
	public Invoker getInstanceInvoker(String name, Object... args) {
		Methods mm = MAP.get(name);
		if (mm == null) {
			throw new UnsupportedOperationException("name=" + name);
		}
		return mm.getInvoker(args, DYNAMIC, true);
	}

	/**
	 * NX\bhĂяoNX擾.
	 *
	 * @param name
	 *            Ǘp̖O
	 * @param args
	 *            
	 * @return \bhĂяoNXiȂꍇAnullj
	 * @throws UnsupportedOperationException
	 *             ǗΏۊO̖Ȍꍇ
	 */
	public Invoker getStaticInvoker(String name, Object... args) {
		Methods mm = MAP.get(name);
		if (mm == null) {
			throw new UnsupportedOperationException("name=" + name);
		}
		return mm.getInvoker(args, STATIC, true);
	}

	protected static final int BOTH = 0;
	protected static final int DYNAMIC = 1;
	protected static final int STATIC = 2;

	/**
	 * \bhǗNXB<br>
	 * ̖Õ\bhAȂ킿I[o[[hꂽ\bhǗB
	 */
	protected static class Methods {

		protected List<Invoker> list = new ArrayList<Invoker>(4);

		public void add(Invoker invoker) {
			list.add(invoker);
			Collections.sort(list, COMP);
		}

		protected static final Comparator<Invoker> COMP = new Comparator<Invoker>() {
			@Override
			public int compare(Invoker o1, Invoker o2) {
				// ̌ȂD
				return o1.getTypeConverter().length
						- o2.getTypeConverter().length;
			}
		};

		public Invoker getInvoker(Object[] args, int ds, boolean search) {
			Invoker v = resolve(args, ds, search);
			return v;
		}

		protected static class Index {
			public int min, max;

			public Index(int min, int max) {
				this.min = min;
				this.max = max;
			}
		}

		protected Invoker resolve(Object[] args, int ds, boolean search) {
			// ̌vĂ̂T
			Index index = getInvokerEqualsLength(args, ds);
			if (index.min == index.max) {
				// 1
				return list.get(index.min);
			}
			if (index.min < index.max) {
				// ₠
				Invoker r = getInvokerMatchType(index, args, ds);
				if (r == null) {
					r = list.get(index.min); // Ȃ擪̂̂gp
				}
				return r;
			}

			// TODO+++args.length傫ƂFϒƂ

			if (search) {
				return null;
			}

			int min = list.get(0).getTypeConverter().length;
			int max = list.get(list.size() - 1).getTypeConverter().length;
			throw new IllegalArgumentLengthException(args.length, min, max);
		}

		protected Index getInvokerEqualsLength(Object[] args, int ds) {
			int min = Integer.MAX_VALUE;
			int max = Integer.MIN_VALUE;
			for (int i = 0; i < list.size(); i++) {
				Invoker v = list.get(i);
				switch (ds) {
				case DYNAMIC:
					if (v.isStatic()) {
						continue;
					}
					break;
				case STATIC:
					if (!v.isStatic()) {
						continue;
					}
					break;
				}
				if (v.getTypeConverter().length == args.length) {
					min = Math.min(min, i);
					max = Math.max(max, i);
				}
			}
			return new Index(min, max);
		}

		protected Invoker getInvokerMatchType(Index index, Object[] args, int ds) {
			int max = Integer.MIN_VALUE;
			Invoker ret = null;
			for (int i = index.min; i <= index.max; i++) {
				Invoker v = list.get(i);
				switch (ds) {
				case DYNAMIC:
					if (v.isStatic()) {
						continue;
					}
					break;
				case STATIC:
					if (!v.isStatic()) {
						continue;
					}
					break;
				}
				TypeConverter[] convs = v.getTypeConverter();
				int cc = 0;
				for (int j = 0; j < args.length; j++) {
					int c = convs[j].match(args[j]);
					if (c < 0) {
						cc = -1;
						break;
					}
					cc += c;
				}
				if (cc >= 0) {
					if (max < cc) {
						max = cc;
						ret = v;
					}
				}
			}
			return ret;
		}
	}
}
