package jp.hishidama.eval.var;

import jp.hishidama.eval.exp.AbstractExpression;

/**
 * ϐC^[tF[X.
 * <p>
 * ϐƕϐlǗC^[tF[XB
 * </p>
 *
 * @author <a target="hishidama"
 *         href="http://www.ne.jp/asahi/hishidama/home/tech/soft/java/eval16.html"
 *         >Ђ</a>
 * @since 2007.02.15
 * @version eval16
 */
public interface Variable {

	/**
	 * ϐl擾.
	 * <p>
	 * ϐ\IuWFNgԂBiPȂϐzzj
	 * </p>
	 *
	 * @param name
	 *            ϐ
	 * @return ϐIuWFNg
	 */
	public Object getValue(Object name);

	/**
	 * ϐݒ.
	 * <p>
	 * ϐɒlZbgB
	 * </p>
	 *
	 * @param name
	 *            ϐ
	 * @param value
	 *            l
	 */
	public void setValue(Object name, Object value);

	/**
	 * ϐl擾.
	 * <p>
	 * z̗vfԂB
	 * </p>
	 *
	 * @param array
	 *            zIuWFNg
	 * @param arrayName
	 *            z
	 * @param index
	 *            Y
	 * @param exp
	 *            \bhĂяoNX
	 * @return vfIuWFNg
	 */
	public Object getArrayValue(Object array, String arrayName, Object index,
			AbstractExpression exp);

	/**
	 * zlݒ.
	 * <p>
	 * zɒlZbgB
	 * </p>
	 *
	 * @param array
	 *            zIuWFNg
	 * @param arrayName
	 *            z
	 * @param index
	 *            Y
	 * @param value
	 *            l
	 * @param exp
	 *            \bhĂяoNX
	 */
	public void setArrayValue(Object array, String arrayName, Object index,
			Object value, AbstractExpression exp);

	/**
	 * tB[hl擾.
	 * <p>
	 * IuWFNg̃tB[h̒lԂB
	 * </p>
	 *
	 * @param obj
	 *            IuWFNg
	 * @param objName
	 *            IuWFNg
	 * @param field
	 *            tB[h
	 * @param exp
	 *            \bhĂяoNX
	 * @return vfIuWFNg
	 */
	public Object getFieldValue(Object obj, String objName, String field,
			AbstractExpression exp);

	/**
	 * tB[hlݒ.
	 * <p>
	 * IuWFNg̃tB[hɒlZbgB
	 * </p>
	 *
	 * @param obj
	 *            IuWFNg
	 * @param objName
	 *            IuWFNg
	 * @param field
	 *            tB[h
	 * @param value
	 *            l
	 * @param exp
	 *            \bhĂяoNX
	 */
	public void setFieldValue(Object obj, String objName, String field,
			Object value, AbstractExpression exp);
}
