package jp.hishidama.eval.srch;

import jp.hishidama.eval.exp.*;

/**
 * TC^[tF[X.
 * <p>
 * S͖؍\TƂɌĂ΂C^[tF[XB
 * </p>
 * 
 * @see jp.hishidama.eval.Expression#search(Search)
 * @author <a target="hishidama"
 *         href="http://www.ne.jp/asahi/hishidama/home/tech/soft/java/eval16.html">Ђ</a>
 * @since 2007.02.17
 * @version 2007.02.20
 */
public interface Search {

	/**
	 * @return TŜIƂAtrue
	 * @since 2007.02.20
	 */
	public boolean end();

	/**
	 * Ts
	 * <p>
	 * TsɁAꂼ̖؍\ňxĂ΂B
	 * </p>
	 * 
	 * @param exp
	 *            TΏExpression
	 */
	public void search(AbstractExpression exp);

	/**
	 * TsiPj
	 * <p>
	 * TɁAl܂͕ϐłΌĂ΂B
	 * </p>
	 * 
	 * @param exp
	 *            TΏExpression
	 * @since 2007.02.20
	 */
	public void search0(WordExpression exp);

	/**
	 * TsiPZqj
	 * <p>
	 * TɁAPZqłΌĂ΂Bi̒TOj
	 * </p>
	 * 
	 * @param exp
	 *            TΏExpression
	 * @return Zq̒TIƂAtrue
	 * @since 2007.02.20
	 */
	public boolean search1_begin(Col1Expression exp);

	/**
	 * TsiPZqj
	 * <p>
	 * TɁAPZqłΌĂ΂Bi̒Tj
	 * </p>
	 * 
	 * @param exp
	 *            TΏExpression
	 * @since 2007.02.20
	 */
	public void search1_end(Col1Expression exp);

	/**
	 * Tsi񍀉Zqj
	 * <p>
	 * TɁA񍀉ZqłΌĂ΂Biŏj
	 * </p>
	 * 
	 * @param exp
	 *            TΏExpression
	 * @return Zq̒TIƂAtrue
	 * @since 2007.02.20
	 */
	public boolean search2_begin(Col2Expression exp);

	/**
	 * Tsi񍀉Zqj
	 * <p>
	 * TɁA񍀉ZqłΌĂ΂Bi1̒Tj
	 * </p>
	 * 
	 * @param exp
	 *            TΏExpression
	 * @return Zq̒TIƂAtrue
	 * @since 2007.02.20
	 */
	public boolean search2_2(Col2Expression exp);

	/**
	 * Tsi񍀉Zqj
	 * <p>
	 * TɁA񍀉ZqłΌĂ΂BiŌi2̒Tjj
	 * </p>
	 * 
	 * @param exp
	 *            TΏExpression
	 * @since 2007.02.20
	 */
	public void search2_end(Col2Expression exp);

	/**
	 * TsiOZqj
	 * <p>
	 * TɁAOZqłΌĂ΂Biŏj
	 * </p>
	 * 
	 * @param exp
	 *            TΏExpression
	 * @return Zq̒TIƂAtrue
	 * @since 2007.02.20
	 */
	public boolean search3_begin(Col3Expression exp);

	/**
	 * TsiOZqj
	 * <p>
	 * TɁAOZqłΌĂ΂BiZq̒Tj
	 * </p>
	 * 
	 * @param exp
	 *            TΏExpression
	 * @return Zq̒TIƂAtrue
	 * @since 2007.02.20
	 */
	public boolean search3_2(Col3Expression exp);

	/**
	 * TsiOZqj
	 * <p>
	 * TɁAOZqłΌĂ΂Bi2̒Tj
	 * </p>
	 * 
	 * @param exp
	 *            TΏExpression
	 * @return Zq̒TIƂAtrue
	 * @since 2007.02.20
	 */
	public boolean search3_3(Col3Expression exp);

	/**
	 * TsiOZqj
	 * <p>
	 * TɁAOZqłΌĂ΂BiŌi3̒Tjj
	 * </p>
	 * 
	 * @param exp
	 *            TΏExpression
	 * @since 2007.02.20
	 */
	public void search3_end(Col3Expression exp);

	/**
	 * Tsi֐j
	 * <p>
	 * TɁA֐łΌĂ΂Biŏj
	 * </p>
	 * 
	 * @param exp
	 *            TΏExpression
	 * @return Zq̒TIƂAtrue
	 * @since 2007.02.20
	 */
	public boolean searchFunc_begin(FunctionExpression exp);

	/**
	 * Tsi֐j
	 * <p>
	 * TɁA֐łΌĂ΂BiIuWFNg̒Tj
	 * </p>
	 * 
	 * @param exp
	 *            TΏExpression
	 * @return Zq̒TIƂAtrue
	 * @since 2007.02.20
	 */
	public boolean searchFunc_2(FunctionExpression exp);

	/**
	 * Tsi֐j
	 * <p>
	 * TɁA֐łΌĂ΂BiŌi̒Tjj
	 * </p>
	 * 
	 * @param exp
	 *            TΏExpression
	 * @since 2007.02.20
	 */
	public void searchFunc_end(FunctionExpression exp);
}
