package jp.hishidama.eval.rule;

import java.util.*;

import jp.hishidama.eval.exp.*;
import jp.hishidama.eval.lex.*;

/**
 * [ۃNX.
 * <p>
 * Zq̎ޖ̗D揇ʂ\A\͂ۂɍsNXB
 * </p>
 *
 * @author <a target="hishidama"
 *         href="http://www.ne.jp/asahi/hishidama/home/tech/soft/java/eval16.html"
 *         >Ђ</a>
 * @version 2007.02.16
 */
public abstract class AbstractRule {

	/** ̗D揇ʂ̃[. */
	public AbstractRule nextRule;

	protected ShareRuleValue share;

	public AbstractRule(ShareRuleValue share) {
		this.share = share;
	}

	/**
	 * Zqo^.
	 * <p>
	 * ̃[ɑ鉉ZqǉBpB<br>
	 * āẢZq̎NX̏sB
	 * </p>
	 *
	 * @param exp
	 *            CX^XiZqێpj
	 */
	public final void addExpression(AbstractExpression exp) {
		if (exp == null) {
			return;
		}
		String ope = exp.getOperator();
		addOperator(ope, exp);
		addLexOperator(exp.getEndOperator());

		if (exp instanceof ParenExpression) {
			share.paren = exp;
		}
	}

	/**
	 * ZqQ.
	 * <p>
	 * D揇ʂɑ鉉ZqB<br>
	 * Map&lt;Zq, ZqCX^X&gt;
	 * </p>
	 * 
	 * @version 2007.02.16
	 */
	private final Map<String, AbstractExpression> opes = new HashMap<String, AbstractExpression>();

	/**
	 * Zqǉ.
	 * <p>
	 * ̃[ɑ鉉ZqǉBpB
	 * </p>
	 *
	 * @param ope
	 *            Zq
	 * @param exp
	 *            _~[ZqCX^X
	 */
	public final void addOperator(String ope, AbstractExpression exp) {
		opes.put(ope, exp);

		addLexOperator(ope);
	}

	/**
	 * Zqꗗ擾.
	 *
	 * @return SZq
	 * @since 2007.02.16
	 */
	public final String[] getOperators() {
		List<String> list = new ArrayList<String>();
		for (String s : opes.keySet()) {
			list.add(s);
		}
		return list.toArray(new String[list.size()]);
	}

	/**
	 * ߑΏۉZqǉ.
	 * <p>
	 * ZqƉ߂镶ǉBł̂ݎgpB<br>
	 * ō쐬opeListLexŎgpB
	 * </p>
	 *
	 * @param ope
	 *            Zq
	 * @see Lex#isOperator(int)
	 * @since 2007.02.16
	 */
	public final void addLexOperator(String ope) {
		if (ope == null) {
			return;
		}
		int n = ope.length() - 1;
		if (share.opeList[n] == null) {
			share.opeList[n] = new ArrayList<String>();
		}
		share.opeList[n].add(ope);
	}

	/**
	 * Zqf.
	 * <p>
	 * ̉ZqÃ[ɑ邩ǂ`FbNB
	 * </p>
	 *
	 * @param ope
	 *            Zq
	 * @return ɑꍇAtrue
	 * @version 2006.11.07
	 */
	protected final boolean isMyOperator(String ope) {
		return opes.containsKey(ope);
	}

	/**
	 * ZqCX^X.
	 *
	 * @param ope
	 *            Zq
	 * @param share
	 *            ʏ
	 * @return ZqCX^X
	 * @since 2006.11.07
	 * @version 2007.02.09
	 */
	protected final AbstractExpression newExpression(String ope,
			ShareExpValue share) {
		try {
			AbstractExpression org = opes.get(ope);
			AbstractExpression n = org.dup(share);
			n.setPriority(prio);
			n.share = share;
			return n;
		} catch (RuntimeException e) {
			throw e;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	/** D揇. */
	public int prio;

	/**
	 * D揇ʏ.
	 *
	 * @param prio
	 *            D揇
	 * @since 2006.10.27
	 */
	public final void initPriority(int prio) {
		this.prio = prio;

		if (nextRule != null) {
			nextRule.initPriority(prio + 1);
		}
	}

	/**
	 * \.
	 *
	 * @param lex
	 *            ̓CX^X
	 * @return \͖؃CX^X
	 */
	protected abstract AbstractExpression parse(Lex lex);

}
