package jp.hishidama.eval.oper;

import jp.hishidama.eval.EvalException;
import jp.hishidama.eval.exp.AbstractExpression;
import jp.hishidama.eval.exp.CharExpression;
import jp.hishidama.eval.exp.NumberExpression;
import jp.hishidama.eval.exp.StringExpression;

/**
 * ZsC^[tF[X.
 * <p>
 * eval()ɂāAۂ̉ZsNẌׂ̃C^[tF[XB
 * </p>
 *
 * @see jp.hishidama.eval.Expression#setOperator(Operator)
 * @see jp.hishidama.eval.Expression#eval()
 * @author <a target="hishidama"
 *         href="http://www.ne.jp/asahi/hishidama/home/tech/soft/java/eval16.html"
 *         >Ђ</a>
 * @since 2007.02.15
 * @version eval16
 */
public interface Operator {
	/**
	 * ݏ扉Z.
	 *
	 * @param x
	 * @param y
	 * @return l
	 * @since 2007.02.16
	 */
	public Object power(Object x, Object y);

	/**
	 * Z.
	 *
	 * @param x
	 * @return l
	 */
	public Object signPlus(Object x);

	/**
	 * Z.
	 *
	 * @param x
	 * @return l
	 */
	public Object signMinus(Object x);

	/**
	 * Z.
	 *
	 * @param x
	 * @param y
	 * @return l
	 */
	public Object plus(Object x, Object y);

	/**
	 * Z.
	 *
	 * @param x
	 * @param y
	 * @return l
	 */
	public Object minus(Object x, Object y);

	/**
	 * Z.
	 *
	 * @param x
	 * @param y
	 * @return l
	 */
	public Object mult(Object x, Object y);

	/**
	 * Z.
	 *
	 * @param x
	 * @param y
	 * @return l
	 */
	public Object div(Object x, Object y);

	/**
	 * ]Z.
	 *
	 * @param x
	 * @param y
	 * @return l
	 */
	public Object mod(Object x, Object y);

	/**
	 * rbgے.
	 *
	 * @param x
	 * @return l
	 */
	public Object bitNot(Object x);

	/**
	 * Vtg.
	 *
	 * @param x
	 * @param y
	 * @return l
	 */
	public Object shiftLeft(Object x, Object y);

	/**
	 * EVtg.
	 *
	 * @param x
	 * @param y
	 * @return l
	 */
	public Object shiftRight(Object x, Object y);

	/**
	 * _EVtg.
	 *
	 * @param x
	 * @param y
	 * @return l
	 */
	public Object shiftRightLogical(Object x, Object y);

	/**
	 * rbg_.
	 *
	 * @param x
	 * @param y
	 * @return l
	 */
	public Object bitAnd(Object x, Object y);

	/**
	 * rbg_a.
	 *
	 * @param x
	 * @param y
	 * @return l
	 */
	public Object bitOr(Object x, Object y);

	/**
	 * rbgrI_a.
	 *
	 * @param x
	 * @param y
	 * @return l
	 */
	public Object bitXor(Object x, Object y);

	/**
	 * ے.
	 *
	 * @param x
	 * @return l
	 */
	public Object not(Object x);

	/**
	 * .
	 *
	 * @param x
	 * @param y
	 * @return l
	 */
	public Object equal(Object x, Object y);

	/**
	 * s.
	 *
	 * @param x
	 * @param y
	 * @return l
	 */
	public Object notEqual(Object x, Object y);

	/**
	 * 菬.
	 *
	 * @param x
	 * @param y
	 * @return l
	 */
	public Object lessThan(Object x, Object y);

	/**
	 * ȉ.
	 *
	 * @param x
	 * @param y
	 * @return l
	 */
	public Object lessEqual(Object x, Object y);

	/**
	 * .
	 *
	 * @param x
	 * @param y
	 * @return l
	 */
	public Object greaterThan(Object x, Object y);

	/**
	 * ȏ.
	 *
	 * @param x
	 * @param y
	 * @return l
	 */
	public Object greaterEqual(Object x, Object y);

	/**
	 * ^Ul.
	 * <p>
	 * IuWFNg^UlɕϊB
	 * </p>
	 *
	 * @param x
	 * @return ^Ul
	 */
	public boolean bool(Object x);

	/**
	 * CNgEfNg
	 *
	 * @param x
	 * @param inc
	 *            CNĝƂ+1AfNĝƂ-1
	 * @return l
	 */
	public Object inc(Object x, int inc);

	/**
	 * ֕ϊ.
	 * <p>
	 * VONH[e[Vň͂܂ꂽlɕϊB<br>
	 * GXP[v߂ꍇ͓\bhŕϊB
	 * </p>
	 *
	 * @param word
	 *            l
	 * @param exp
	 *            Expression
	 * @return l
	 * @see CharExpression
	 * @since eval16
	 */
	public Object character(String word, AbstractExpression exp)
			throws EvalException;

	/**
	 * ֕ϊ.
	 * <p>
	 * _uNH[e[Vň͂܂ꂽlɕϊB<br>
	 * {Iɂ́Aword̂܂ܕԂƂɂȂ邾낤B<br>
	 * GXP[v߂ꍇ͓\bhŕϊB
	 * </p>
	 *
	 * @param word
	 *            l
	 * @param exp
	 *            Expression
	 * @return l
	 * @see StringExpression
	 * @since eval16
	 */
	public Object string(String word, AbstractExpression exp)
			throws EvalException;

	/**
	 * l֕ϊ.
	 * <p>
	 * ݂̂ō\ꂽlɕϊB<br>
	 * Ⴆ΁u123vƂInteger^123ɕϊĕԂB
	 * </p>
	 *
	 * @param word
	 *            l
	 * @param exp
	 *            Expression
	 * @return l
	 * @see NumberExpression
	 * @since eval16
	 */
	public Object number(String word, AbstractExpression exp)
			throws EvalException;

	/**
	 * ϐ擾lϊ.
	 * <p>
	 * ϐ擾lɑ΂āA^ɉēƎ̕ϊsꍇɓ\bhŕϊB
	 * </p>
	 *
	 * @param value
	 *            l
	 * @param exp
	 *            Expression
	 * @return l
	 * @since eval16
	 */
	public Object variable(Object value, AbstractExpression exp)
			throws EvalException;
}
