package jp.hishidama.eval.lex;

import java.util.*;

import jp.hishidama.eval.exp.AbstractExpression;
import jp.hishidama.eval.exp.ShareExpValue;
import jp.hishidama.eval.lex.comment.CommentLex;
import jp.hishidama.util.CharUtil;

/**
 * ̓NX.
 * <p>
 * ̉͒̈ʒuێB
 * </p>
 *
 * @author <a target="hishidama"
 *         href="http://www.ne.jp/asahi/hishidama/home/tech/soft/java/eval16.html"
 *         >Ђ</a>
 * @version eval16
 */
public class Lex {

	/**
	 * ZqQ.
	 * <p>
	 * ͂ŉZqƔF镶B Zq̕ɂĔz𕪂ĂB iZqɃ}b`ׁj
	 * </p>
	 */
	protected List<String>[] opeList;

	/** ͑Ώە. */
	protected String string;

	/** ݈͒̌ʒu. */
	protected int pos = 0;

	/** ݂̉ߌʂ̒̕. */
	protected int len = 0;

	/** ݂̉ߌʂ\^Cv. */
	protected int type = TYPE_ERR;

	/** ߃^CvFʎq. */
	public static final int TYPE_WORD = 0x7ffffff0;

	/**
	 * ߃^CvFʎq(l).
	 *
	 * @since 2007.02.15
	 */
	public static final int TYPE_NUM = 0x7ffffff1;

	/** ߃^CvFZq. */
	public static final int TYPE_OPE = 0x7ffffff2;

	/**
	 * ߃^CvFʎq().
	 *
	 * @since 2007.02.21
	 */
	public static final int TYPE_STRING = 0x7ffffff3;

	/**
	 * ߃^CvFʎq().
	 *
	 * @since 2007.02.21
	 */
	public static final int TYPE_CHAR = 0x7ffffff4;

	/** ߃^CvFߏI. */
	public static final int TYPE_EOF = 0x7fffffff;

	/** ߃^CvFG[. */
	public static final int TYPE_ERR = -1;

	/**
	 * Zq̕.
	 * <p>
	 * ^CvZq̂Ƃ̂ݗLB
	 * </p>
	 */
	protected String ope;

	/**
	 * Expression̋L.
	 *
	 * @since 2007.02.09
	 */
	protected ShareExpValue expShare;

	/**
	 * RXgN^[.
	 *
	 * @param str
	 *            Ώە
	 * @param exp
	 */
	protected Lex(String str, List<String>[] lists, AbstractExpression paren,
			ShareExpValue exp) {
		this.string = str;
		this.opeList = lists;
		expShare = exp;
		if (expShare.paren == null) {
			expShare.paren = paren;
		}
	}

	/**
	 * 󔒕Q.
	 * <p>
	 * 󔒂Ɖ߂ăXLbv镶B
	 * </p>
	 */
	protected String SPC_CHAR = " \t\r\n";

	/**
	 * 󔒔f.
	 * <p>
	 * w肳ꂽʒu̕󔒂ǂ`FbNB<br>
	 * ̒𒴂Ăꍇ󔒂ƂB
	 * </p>
	 *
	 * @param pos
	 *            ʒu
	 * @return 󔒂̂ƂAtrue
	 * @see #SPC_CHAR
	 */
	protected boolean isSpace(int pos) {
		if (pos >= string.length()) {
			return true;
		}
		char c = string.charAt(pos);
		return SPC_CHAR.indexOf(c) >= 0;
	}

	/**
	 * Rgꗗ.
	 */
	protected List<CommentLex> commentList = null;

	/**
	 * Rgꗗݒ.
	 *
	 * @param list
	 *            Rgꗗ
	 * @since eval16
	 */
	public void setCommentLexList(List<CommentLex> list) {
		commentList = list;
	}

	/**
	 * Rgꗗ擾.
	 *
	 * @return Rgꗗ
	 * @since eval16
	 */
	public List<CommentLex> getCommentLexList() {
		return commentList;
	}

	/**
	 * Rgf.
	 *
	 * @param pos
	 *            ʒu
	 * @return RĝƂÃRg߂IuWFNg
	 * @since 2010.02.11
	 */
	protected CommentLex isCommentTop(int pos) {
		if (commentList != null) {
			for (CommentLex c : commentList) {
				if (c.isTop(string, pos) >= 0) {
					return c;
				}
			}
		}
		return null;
	}

	/**
	 * l擪f.
	 * <p>
	 * ̐擪łΐlƔf̂ŁA̐擪`FbNB
	 * </p>
	 *
	 * @param pos
	 *            ʒu
	 * @return ̂ƂAtrue
	 * @since 2007.02.15
	 */
	protected boolean isNumberTop(int pos) {
		if (pos >= string.length()) {
			return false;
		}
		char c = string.charAt(pos);
		return ('0' <= c && c <= '9');
	}

	/**
	 * .
	 * <p>
	 * ZqƂĎgꂻȋLAƂĈB_ȂǁB
	 * </p>
	 *
	 * @since 2007.02.15
	 */
	protected String NUMBER_CHAR = "._";

	/**
	 * ꐔf.
	 * <p>
	 * ZqƂĎgꂻȋLAƂĈȕǂ`FbNB<br>
	 * Ⴆ΃sIhu.v̓IuWFNgƃo[̋؂ɎgAl̒ŎgꂽƂ͏_ƂėDIɈKvB
	 * </p>
	 *
	 * @param pos
	 *            ʒu
	 * @return ̂ƂAtrue
	 * @see #NUMBER_CHAR
	 * @since 2007.02.15
	 */
	protected boolean isSpecialNumber(int pos) {
		if (pos >= string.length()) {
			return false;
		}
		char c = string.charAt(pos);
		return NUMBER_CHAR.indexOf(c) >= 0;
	}

	/**
	 * Zqf.
	 * <p>
	 * w肳ꂽʒu̕Zqǂ`FbNB
	 * </p>
	 *
	 * @param pos
	 *            ʒu
	 * @return Zq̏ꍇAZq̕<br>
	 *         ȊȌꍇAnull
	 */
	protected String isOperator(int pos) {
		// Zq̑̕`FbN
		for (int i = opeList.length - 1; i >= 0; i--) {
			if (pos + i >= string.length()) {
				continue;
			}
			List<String> list = opeList[i];
			if (list != null) {
				ope: for (int j = 0; j < list.size(); j++) {
					String ope = list.get(j);
					for (int k = 0; k <= i; k++) {
						char c = string.charAt(pos + k);
						char o = ope.charAt(k);
						if (c != o) {
							continue ope;
						}
					}
					return ope;
				}
			}
		}
		return null;
	}

	/**
	 * 擪f.
	 *
	 * @param pos
	 *            ʒu
	 * @return 񂩂ǂ
	 * @since 2007.02.21
	 */
	protected boolean isStringTop(int pos) {
		if (pos >= string.length()) {
			return false;
		}
		char c = string.charAt(pos);
		return c == '\"';
	}

	/**
	 * If.
	 *
	 * @param pos
	 *            ʒu
	 * @return 񂩂ǂ
	 * @since 2007.02.21
	 */
	protected boolean isStringEnd(int pos) {
		return isStringTop(pos);
	}

	/**
	 * 擪f.
	 *
	 * @param pos
	 *            ʒu
	 * @return ǂ
	 * @since 2007.02.21
	 */
	protected boolean isCharTop(int pos) {
		if (pos >= string.length()) {
			return false;
		}
		char c = string.charAt(pos);
		return c == '\'';
	}

	/**
	 * If.
	 *
	 * @param pos
	 *            ʒu
	 * @return ǂ
	 * @since 2007.02.21
	 */
	protected boolean isCharEnd(int pos) {
		return isCharTop(pos);
	}

	/**
	 * ݈ʒu.
	 * <p>
	 * ݂̈ʒu߂AԂZbgB
	 * </p>
	 */
	public void check() {
		// 󔒔f
		for (;;) {
			if (isSpace(pos)) {
				if (pos >= string.length()) {
					// 𒴂I
					type = TYPE_EOF;
					len = 0;
					return;
				}
				pos++;
				continue;
			}
			CommentLex comment = isCommentTop(pos);
			if (comment != null) {
				pos += comment.topLength();
				int end = comment.skip(string, pos);
				if (end < 0) {
					type = TYPE_EOF;
					return;
				}
				pos = end;
				continue;
			}
			break;
		}

		// 񔻒f
		if (isStringTop(pos)) {
			processString();
			return;
		}
		// f
		if (isCharTop(pos)) {
			processChar();
			return;
		}

		// Zqf
		String ope = isOperator(pos);
		if (ope != null) {
			this.type = TYPE_OPE;
			this.ope = ope;
			this.len = ope.length();
			return;
		}

		// LȊO͎ʎq
		boolean number = isNumberTop(pos);
		type = number ? TYPE_NUM : TYPE_WORD;
		for (len = 1;; len++) {
			if (isSpace(pos + len) || isCommentTop(pos + len) != null) {
				break;
			}
			if (number && isSpecialNumber(pos + len)) {
				continue;
			}
			if (isOperator(pos + len) != null) {
				break;
			}
		}
	}

	protected void processString() {
		int[] ret = new int[1];
		type = TYPE_STRING;
		for (len = 1;;) {
			if (isStringEnd(pos + len)) {
				len++;
				return;
			}
			len += getCharLen(pos + len, ret);
			if (pos + len >= string.length()) {
				type = TYPE_EOF;
				break;
			}
		}
	}

	protected void processChar() {
		int[] ret = new int[1];
		type = TYPE_CHAR;
		for (len = 1;;) {
			if (isCharEnd(pos + len)) {
				len++;
				return;
			}
			len += getCharLen(pos + len, ret);
			if (pos + len >= string.length()) {
				type = TYPE_EOF;
				break;
			}
		}
	}

	protected int getCharLen(int pos, int[] ret) {
		CharUtil.escapeChar(string, pos, string.length(), ret);
		return ret[0];
	}

	/**
	 * ʒu.
	 * <p>
	 * ̈ʒuֈړA߂ēԂZbgB
	 * </p>
	 *
	 * @return g
	 */
	public Lex next() {
		pos += len;
		check();
		return this;
	}

	/**
	 * ^Cv擾.
	 *
	 * @return ^Cv
	 */
	public int getType() {
		return type;
	}

	/**
	 * Zq擾.
	 * <p>
	 * ^CvZq̂ƂLB
	 * </p>
	 *
	 * @return Zq
	 */
	public String getOperator() {
		return ope;
	}

	/**
	 * Zqr.
	 *
	 * @param ope
	 *            Zq
	 * @return ݈ʒuƓZq̂ƂAtrue
	 */
	public boolean isOperator(String ope) {
		if (type == TYPE_OPE) {
			return this.ope.equals(ope);
		}
		return false;
	}

	/**
	 * ʎq擾.
	 *
	 * @return ʎq
	 */
	public String getWord() {
		return string.substring(pos, pos + len);
	}

	/**
	 * 擾.
	 * <p>
	 * ߒ̕ŜԂB
	 * </p>
	 *
	 * @return 
	 */
	public String getString() {
		return string;
	}

	/**
	 * ʒu擾.
	 *
	 * @return ߒ̈ʒu
	 */
	public int getPos() {
		return pos;
	}

	/**
	 * ExpressionL擾.
	 *
	 * @return L
	 * @since 2007.02.09
	 */
	public ShareExpValue getShare() {
		return expShare;
	}
}
