package jp.hishidama.eval.exp;

import java.util.*;

import jp.hishidama.eval.EvalException;

/**
 * ̒ۃNX.
 * <p>
 * \͖؂\AZ̕]{B
 * </p>
 *
 * @author <a target="hishidama"
 *         href="http://www.ne.jp/asahi/hishidama/home/tech/soft/java/eval16.html"
 *         >Ђ</a>
 * @version eval16
 */
public abstract class AbstractExpression {

	/**
	 * S̕.
	 * <p>
	 * ߑΏۑŜ̕B
	 * </p>
	 */
	protected String string = null;

	/**
	 * ʒu.
	 * <p>
	 * S̈̕ʒuB
	 * </p>
	 */
	protected int pos = -1;

	private String ope1;

	private String ope2;

	public ShareExpValue share;

	protected AbstractExpression() {
	}

	protected AbstractExpression(AbstractExpression from, ShareExpValue s) {
		string = from.string;
		pos = from.pos;
		prio = from.prio;
		if (s != null) {
			share = s;
		} else {
			share = from.share;
		}
		ope1 = from.ope1;
		ope2 = from.ope2;
	}

	/**
	 * .
	 * <p>
	 * CX^X̕쐬B
	 * </p>
	 *
	 * @param s
	 *            Vʏ
	 * @return VCX^X
	 * @since 2007.02.17
	 */
	public abstract AbstractExpression dup(ShareExpValue s);

	/**
	 * Zq擾.
	 * <p>
	 * NXɌŗL̉ZqԂB
	 * </p>
	 *
	 * @return Zq
	 */
	public final String getOperator() {
		return ope1;
	}

	/**
	 * IZq擾.
	 * <p>
	 * ")""]"ȂǁB
	 * </p>
	 *
	 * @return Zqi݂Ȃꍇnullj
	 * @since 2007.02.16
	 */
	public final String getEndOperator() {
		return ope2;
	}

	/**
	 * ZqZbg.
	 *
	 * @param ope
	 *            Zq
	 * @since 2007.02.17
	 */
	public final void setOperator(String ope) {
		ope1 = ope;
	}

	/**
	 * IZqZbg.
	 *
	 * @param ope
	 *            Zq
	 * @since 2007.02.17
	 */
	public final void setEndOperator(String ope) {
		ope2 = ope;
	}

	/**
	 * ʎq擾.
	 *
	 * @return ʎq
	 */
	public String getWord() {
		return getOperator();
	}

	protected void setWord(String word) {
		throw new EvalException(EvalException.EXP_FORBIDDEN_CALL, this, null);
	}

	/**
	 * 擾.
	 * <p>
	 * Z̍̐ԂB<br>
	 * iF񍀉Zq̏ꍇA2Ԃj
	 * </p>
	 *
	 * @return 
	 */
	protected abstract int getCols();

	/**
	 * ʒuݒ.
	 *
	 * @param string
	 *            
	 * @param pos
	 *            ʒu
	 */
	protected final void setPos(String string, int pos) {
		this.string = string;
		this.pos = pos;
	}

	/**
	 * ͖擾.
	 *
	 * @return ͖
	 */
	public abstract String getExpressionName();

	/**
	 * ͑Ώە擾.
	 *
	 * @return 
	 */
	public final String getString() {
		return string;
	}

	/**
	 * ʒu擾.
	 *
	 * @return ʒu
	 */
	public final int getPos() {
		return pos;
	}

	/**
	 * 擪ʒu擾.
	 * <p>
	 * ̉Zɑԍ̈ʒuԂB
	 * </p>
	 *
	 * @return ʒu
	 */
	protected abstract int getFirstPos();

	/** D揇. */
	protected int prio;

	/**
	 * D揇ʐݒ.
	 *
	 * @param prio
	 *            D揇
	 * @since 2006.10.27
	 */
	public final void setPriority(int prio) {
		this.prio = prio;
	}

	/**
	 * D揇ʎ擾.
	 *
	 * @return D揇
	 * @since 2006.10.27
	 */
	protected final int getPriority() {
		return prio;
	}

	/**
	 * s.
	 * <p>
	 * ϐiExpressionjɒlB
	 * </p>
	 *
	 * @param val
	 *            l
	 * @param pos
	 *            Zq̈ʒuiG[Ɏgpj
	 * @throws EvalException
	 *             ӒlϐłȂƂ
	 * @since 2007.2.13
	 */
	protected void let(Object val, int pos) {
		// ϐƂĈNX́A\bhI[o[ChĒlB
		throw new EvalException(EvalException.EXP_NOT_LET, toString(), this,
				null);
	}

	/**
	 * ϐ擾.
	 * <p>
	 * ϐl擾i]jpB
	 * </p>
	 *
	 * @return ϐ\IuWFNg
	 * @throws EvalException
	 *             ϐł͂ȂƂ
	 * @since 2006.10.27
	 * @version 2007.02.13
	 */
	protected Object getVariable() {
		// ϐƂĈNX́A\bhI[o[ChĕϐIuWFNgԂB
		// int first = getFirstPos();
		// String word = string.substring(first, pos);
		String word = this.toString();
		throw new EvalException(EvalException.EXP_NOT_VARIABLE, word, this,
				null);
	}

	/**
	 * ̒lݒ.
	 * <p>
	 * ]săXgɃZbgB
	 * </p>
	 *
	 * @param args
	 *            lݒ肷郊Xg
	 * @since 2005.02.15
	 */
	protected void evalArgs(List<Object> args) {
		args.add(eval());
	}

	/**
	 * ]s.
	 * <p>
	 * Object^ŉZ{ČʂԂB<br>
	 * ZsNXo^KvB
	 * </p>
	 *
	 * @return Z
	 * @throws EvalException
	 *             ZɃG[Ƃ
	 * @since 2007.02.15
	 */
	public abstract Object eval();

	/**
	 * Ts([D).
	 *
	 * @since 2007.02.17
	 */
	protected abstract void search();

	/**
	 * ϊs
	 *
	 * @return Expression
	 * @since 2007.02.20
	 */
	protected abstract AbstractExpression replace();

	/**
	 * ӒlƂĕϊs
	 *
	 * @return Expression
	 * @since 2007.02.20
	 */
	protected abstract AbstractExpression replaceVar();

	/**
	 * IuWFNgr.
	 * <p>
	 * ؍\ǂ`FbNB<br>
	 * Zq̕\̈Ⴂ͈ӎȂB
	 * </p>
	 *
	 * @param obj
	 *            IuWFNg
	 * @return ƂAtrue
	 * @see #same(AbstractExpression)
	 * @since 2007.02.27
	 */
	@Override
	public abstract boolean equals(Object obj);

	/**
	 * nbVR[hl擾.
	 *
	 * @return nbVR[hl
	 * @since 2007.02.27
	 */
	@Override
	public abstract int hashCode();

	/**
	 * IuWFNgr.
	 * <p>
	 * Zq̕\܂Ŋ܂߂ăIuWFNgǂ`FbNB
	 * </p>
	 *
	 * @param exp
	 *            rΏ
	 * @return ƂAtrue
	 * @see #equals(Object)
	 * @since 2007.02.27
	 */
	public boolean same(AbstractExpression exp) {
		return same(getOperator(), exp.getOperator())
				&& same(getEndOperator(), exp.getEndOperator())
				&& this.equals(exp);
	}

	private static boolean same(String str1, String str2) {
		if (str1 == null) {
			return str2 == null;
		}
		return str1.equals(str2);
	}

	/**
	 * fobOp_v.
	 *
	 * @param n
	 *            ^up̌
	 */
	public abstract void dump(int n);

	/**
	 * \ϊ.
	 * <p>
	 * ̕\ԂB
	 * </p>
	 *
	 * @return \
	 * @since 2006.10.27
	 */
	@Override
	public abstract String toString();
}
