package jp.hishidama.eval;

import jp.hishidama.eval.func.Function;
import jp.hishidama.eval.log.EvalLog;
import jp.hishidama.eval.oper.Operator;
import jp.hishidama.eval.var.Variable;

/**
 * [NX.
 * <p>
 * \̓[֘Ã[U[B
 * </p>
 *
 * @see jp.hishidama.eval.ExpRuleFactory#getRule()
 * @author <a target="hishidama"
 *         href="http://www.ne.jp/asahi/hishidama/home/tech/soft/java/eval16.html"
 *         >Ђ</a>
 * @version eval16
 */
public abstract class Rule implements Cloneable {

	protected Variable defaultVar = null;

	protected Function defaultFunc = null;

	protected Operator defaultOper = null;

	protected EvalLog defaultLog = null;

	/**
	 * ftHgϐQ擾.
	 *
	 * @return ftHg̕ϐQ
	 * @since eval16
	 */
	public Variable getDefaultVariable() {
		return defaultVar;
	}

	/**
	 * ftHgϐQݒ肵[ԂB
	 *
	 * @param var
	 *            ϐQ
	 * @return ftHglݒ肳ꂽ[
	 * @since eval16
	 */
	public Rule defaultVariable(Variable var) {
		Rule rule = this.clone();
		rule.defaultVar = var;
		return rule;
	}

	/**
	 * ftHg֐Q擾.
	 *
	 * @return ftHg̊֐Q
	 * @since eval16
	 */
	public Function getDefaultFunction() {
		return defaultFunc;
	}

	/**
	 * ftHg֐Qݒ肵[ԂB
	 *
	 * @param func
	 *            ֐Q
	 * @return ftHglݒ肳ꂽ[
	 */
	public Rule defaultFunction(Function func) {
		Rule rule = this.clone();
		rule.defaultFunc = func;
		return rule;
	}

	/**
	 * ftHgZQ擾.
	 *
	 * @return ftHg̉Z
	 * @since eval16
	 */
	public Operator getDefaultOperator() {
		return defaultOper;
	}

	/**
	 * ftHgZQݒ肵[ԂB
	 *
	 * @param oper
	 *            Z
	 * @return ftHglݒ肳ꂽ[
	 * @since eval16
	 */
	public Rule defaultOperator(Operator oper) {
		Rule rule = this.clone();
		rule.defaultOper = oper;
		return rule;
	}

	/**
	 * ftHgOo͎擾.
	 *
	 * @return ftHg̃Oo̓IuWFNg
	 * @since eval16
	 */
	public EvalLog getDefaultEvalLog() {
		return defaultLog;
	}

	/**
	 * ftHgOo͂ݒ肵[ԂB
	 *
	 * @param log
	 *            Oo̓IuWFNg
	 * @return ftHglݒ肳ꂽ[
	 * @since eval16
	 */
	public Rule defaultEvalLog(EvalLog log) {
		Rule rule = this.clone();
		rule.defaultLog = log;
		return rule;
	}

	/**
	 * \
	 *
	 * @param str
	 *            ͑Ώە
	 * @return \͌
	 */
	public abstract Expression parse(String str);

	@Override
	protected Rule clone() {
		try {
			return (Rule) super.clone();
		} catch (CloneNotSupportedException e) {
			throw new InternalError(e.toString());
		}
	}
}
