package jp.hishidama.eval;

import jp.hishidama.eval.exp.AbstractExpression;
import jp.hishidama.eval.func.Function;
import jp.hishidama.eval.log.EvalLog;
import jp.hishidama.eval.oper.DoubleOperator;
import jp.hishidama.eval.oper.IntOperator;
import jp.hishidama.eval.oper.LongOperator;
import jp.hishidama.eval.oper.Operator;
import jp.hishidama.eval.ref.Refactor;
import jp.hishidama.eval.repl.Replace;
import jp.hishidama.eval.srch.Search;
import jp.hishidama.eval.var.Variable;

/**
 * NX.
 * <p>
 * \͖؂ێAZ̕]{B
 * </p>
 *
 * @see Rule#parse(String)
 * @author <a target="hishidama"
 *         href="http://www.ne.jp/asahi/hishidama/home/tech/soft/java/eval16.html"
 *         >Ђ</a>
 * @version eval16
 */
public abstract class Expression {

	public Variable var;

	public Function func;

	public Operator oper;

	public EvalLog log;

	public Search srch;

	public Replace repl;

	protected AbstractExpression ae;

	/**
	 * \͎s.
	 * <p>
	 * ftHg[ō\͂sB
	 * </p>
	 *
	 * @param str
	 *            ͑Ώە
	 * @return \͌
	 * @throws EvalException
	 *             \Ƃ
	 * @see ExpRuleFactory#getDefaultRule()
	 * @see Rule#parse(String)
	 */
	public static Expression parse(String str) {
		return ExpRuleFactory.getDefaultRule().parse(str);
	}

	/**
	 * ϐQݒ.
	 * <p>
	 * ]s̍ۂ ̒ɕϐ΁A\bhŎw肵ϐIuWFNg̃\bhĂ΂B
	 * </p>
	 *
	 * @param var
	 *            ϐIuWFNg
	 * @see #evalInt()
	 * @see #evalLong()
	 * @see #evalDouble()
	 * @see #eval()
	 * @since 2007.02.09
	 */
	public void setVariable(Variable var) {
		this.var = var;
	}

	/**
	 * ֐Qݒ.
	 * <p>
	 * ]s̍ۂ ̒Ɋ֐΁A\bhŎw肵֐IuWFNg̃\bhĂ΂B
	 * </p>
	 *
	 * @param func
	 *            ֐IuWFNg
	 * @see #evalInt()
	 * @see #evalLong()
	 * @see #evalDouble()
	 * @see #eval()
	 */
	public void setFunction(Function func) {
		this.func = func;
	}

	/**
	 * Zݒ.
	 * <p>
	 * ]s̍ۂ ̒ɉZi+-j΁Aw肵ZIuWFNg̃\bhĂ΂B
	 * </p>
	 *
	 * @param oper
	 *            ZIuWFNg
	 * @see #eval()
	 * @since 2007.02.15
	 */
	public void setOperator(Operator oper) {
		this.oper = oper;
	}

	/**
	 * Oo͐ݒ.
	 * <p>
	 * ]s̍ۂɎw肵Oo̓IuWFNg̃\bhĂ΂B
	 * </p>
	 *
	 * @param log
	 *            Oo̓IuWFNg
	 * @see #eval()
	 * @since eval16
	 */
	public void setEvalLog(EvalLog log) {
		this.log = log;
	}

	/**
	 * ]s(int).
	 *<p>
	 * \bhł́A{@link IntOperator}gpĉZB
	 * </p>
	 *
	 * @return Z
	 * @throws EvalException
	 *             ZɃG[Ƃ
	 * @see #setOperator(Operator)
	 * @see IntOperator
	 * @since eval16
	 */
	public int evalInt() {
		Operator bak = oper;
		try {
			if (!(oper instanceof IntOperator)) {
				setOperator(new IntOperator());
			}
			Number n = (Number) eval();
			if (n != null) {
				return n.intValue();
			} else {
				return 0;
			}
		} finally {
			oper = bak;
		}
	}

	/**
	 * ]s(long).
	 *<p>
	 * \bhł́A{@link LongOperator}gpĉZB
	 * </p>
	 *
	 * @return Z
	 * @throws EvalException
	 *             ZɃG[Ƃ
	 * @see #setOperator(Operator)
	 * @see LongOperator
	 */
	public long evalLong() {
		Operator bak = oper;
		try {
			if (!(oper instanceof LongOperator)) {
				setOperator(new LongOperator());
			}
			Number n = (Number) eval();
			if (n != null) {
				return n.longValue();
			} else {
				return 0;
			}
		} finally {
			oper = bak;
		}
	}

	/**
	 * ]s(double).
	 *<p>
	 * \bhł́A{@link DoubleOperator}gpĉZB
	 * </p>
	 *
	 * @return Z
	 * @throws EvalException
	 *             ZɃG[Ƃ
	 * @see #setOperator(Operator)
	 * @see DoubleOperator
	 */
	public double evalDouble() {
		Operator bak = oper;
		try {
			if (!(oper instanceof DoubleOperator)) {
				setOperator(new DoubleOperator());
			}
			Number n = (Number) eval();
			if (n != null) {
				return n.doubleValue();
			} else {
				return 0;
			}
		} finally {
			oper = bak;
		}
	}

	/**
	 * ]s(Object).
	 * <p>
	 * Object^ŉZ{ČʂԂB<br>
	 * ZsNXo^KvB
	 * </p>
	 *
	 * @see #setOperator(Operator)
	 * @return Z
	 * @throws EvalException
	 *             ZɃG[Ƃ
	 * @since 2007.02.15
	 */
	public abstract Object eval();

	/**
	 * œKs(Object).
	 * <p>
	 * ȈՍœKsBZ͎w肳ꂽopergčsB<br>
	 * ϐɒlĂꍇA萔ƌȂAlɒuB
	 * </p>
	 *
	 * @param var
	 *            萔ƂĈϐQinullj
	 * @param oper
	 *            ZsNX
	 * @throws EvalException
	 *             œKɃG[Ƃ
	 * @since 2007.02.21
	 */
	public abstract void optimize(Variable var, Operator oper);

	/**
	 * Ts.
	 * <p>
	 * \͖؂̒TsB<br>
	 * S\͖؂ɂāA1TC^[tF[X̃\bhĂяoB
	 * </p>
	 *
	 * @param srch
	 *            TC^[tF[X
	 * @see Search#search(AbstractExpression)
	 * @since 2007.02.17
	 */
	public abstract void search(Search srch);

	/**
	 * t@N^OiʎqύXj.
	 * <p>
	 * ϐ/֐邢̓IuWFNg̃tB[h/\bhϊB
	 * </p>
	 * <p>
	 * ̒ɃIuWFNg̃o[݂ꍇ́AIuWFNg擾ĕύXΏۂ̃IuWFNgǂ肷B<br>
	 * āAIuWFNg݂ꍇsetVariable()ŃIuWFNg̕ϐԂ悤ɂĂKvB
	 * </p>
	 *
	 * @param ref
	 *            t@N^OC^[tF[X
	 * @since 2007.02.19
	 */
	public abstract void refactorName(Refactor ref);

	/**
	 * t@N^Oi֐ւ̕ύXj.
	 * <p>
	 * ϐ邢̓IuWFNg̃tB[h֐i邢̓\bhjɕϊB
	 * </p>
	 * <p>
	 * ̒ɃIuWFNg̃o[݂ꍇ́AIuWFNg擾ĕύXΏۂ̃IuWFNgǂ肷B<br>
	 * āAIuWFNg݂ꍇsetVariable()ŃIuWFNg̕ϐԂ悤ɂĂKvB
	 * </p>
	 *
	 * @param ref
	 *            t@N^OC^[tF[X
	 * @param rule
	 *            ϊɎgp郋[
	 * @since 2007.02.20
	 */
	public abstract void refactorFunc(Refactor ref, Rule rule);

	/**
	 * 쐬.
	 * <p>
	 * CX^X̕쐬B
	 * </p>
	 *
	 * @return 
	 * @since 2007.02.17
	 */
	public abstract Expression dup();

	/**
	 * IuWFNgr.
	 * <p>
	 * Z͌ʂǂ`FbNB<br>
	 * Zq̕\̈Ⴂ͈ӎȂB
	 * </p>
	 *
	 * @param obj
	 *            IuWFNg
	 * @return ƂAtrue
	 * @see #same(Expression)
	 * @since 2007.02.27
	 */
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof Expression) {
			AbstractExpression e = ((Expression) obj).ae;
			if (ae == null && e == null) {
				return true;
			}
			if (ae == null || e == null) {
				return false;
			}
			return ae.equals(e);
		}
		return super.equals(obj);
	}

	/**
	 * nbVR[hl擾.
	 *
	 * @return nbVR[hl
	 * @since 2007.02.27
	 */
	@Override
	public int hashCode() {
		if (ae == null) {
			return 0;
		}
		return ae.hashCode();
	}

	/**
	 * IuWFNgr.
	 * <p>
	 * Zq̕\܂Ŋ܂߂ăIuWFNgǂ`FbNB
	 * </p>
	 *
	 * @param obj
	 *            rΏ
	 * @return ƂAtrue
	 * @see #equals(Object)
	 * @since 2007.02.27
	 */
	public boolean same(Expression obj) {
		AbstractExpression e = obj.ae;
		if (ae == null) {
			return e == null;
		}
		return ae.same(e);
	}

	/**
	 * `FbN.
	 * <p>
	 * ͌ʂ󂩂ǂ`FbNB
	 * </p>
	 *
	 * @return ̂ƂAtrue
	 * @since 2007.03.01
	 */
	public boolean isEmpty() {
		return ae == null;
	}

	@Override
	public String toString() {
		if (ae == null) {
			return "";
		}
		return ae.toString();
	}
}
