package jp.hishidama.eval;

import jp.hishidama.eval.exp.AbstractExpression;
import jp.hishidama.eval.lex.Lex;

/**
 * ZG[NX.
 * <p>
 * \͂Ɏsꍇ]̎sɎsꍇɃX[B
 * </p>
 *
 * @author <a target="hishidama"
 *         href="http://www.ne.jp/asahi/hishidama/home/tech/soft/java/eval16.html"
 *         >Ђ</a>
 * @version 2007.03.02
 */
@SuppressWarnings("serial")
public class EvalException extends RuntimeException {

	/**
	 * ʂ݂Ȃ.
	 * <p>
	 * %0F
	 * </p>
	 */
	public static final int PARSE_NOT_FOUND_END_OP = 1001;

	/** `̉Zq */
	public static final int PARSE_INVALID_OP = 1002;

	/** `̕ */
	public static final int PARSE_INVALID_CHAR = 1003;

	/** ߂̓rŕ񂪏I */
	public static final int PARSE_END_OF_STR = 1004;

	/** ߂Îɕ񂪎cĂ */
	public static final int PARSE_STILL_EXIST = 1005;

	/** ֐ƂĈȂ */
	public static final int PARSE_NOT_FUNC = 1101;

	/**
	 * ֎~ꂽ\bhĂяo.
	 * <p>
	 * l錴F
	 * <ul>
	 * <li>Kvȃ\bhI[o[ChĂȂ</li>
	 * <li>̃NXł́Adlセ̃\bhĂł͂Ȃ</li>
	 * </p>
	 */
	public static final int EXP_FORBIDDEN_CALL = 2001;

	/** ϐƂĈȂ */
	public static final int EXP_NOT_VARIABLE = 2002;

	/** lƂĈȂ */
	public static final int EXP_NOT_NUMBER = 2003;

	/** łȂ */
	public static final int EXP_NOT_LET = 2004;

	/**
	 * ƂĈȂ
	 */
	public static final int EXP_NOT_CHAR = 2005;

	/**
	 * ƂĈȂ
	 */
	public static final int EXP_NOT_STRING = 2006;

	/** ϐl擾łȂ */
	public static final int EXP_NOT_VAR_VALUE = 2101;

	/** ϐɑłȂ */
	public static final int EXP_NOT_LET_VAR = 2102;

	/** ϐ` */
	public static final int EXP_NOT_DEF_VAR = 2103;

	/** IuWFNg` */
	public static final int EXP_NOT_DEF_OBJ = 2104;

	/** zl擾łȂ */
	public static final int EXP_NOT_ARR_VALUE = 2201;

	/** zɑłȂ */
	public static final int EXP_NOT_LET_ARR = 2202;

	/** tB[hl擾łȂ */
	public static final int EXP_NOT_FLD_VALUE = 2301;

	/** tB[hɑłȂ */
	public static final int EXP_NOT_LET_FIELD = 2302;

	/** ֐Ăяo̎s */
	public static final int EXP_FUNC_CALL_ERROR = 2401;

	/**
	 * G[bZ[WR[h.
	 *
	 * @since 2007.03.02
	 */
	protected int msgCode;

	/**
	 * G[bZ[W̃IvV.
	 *
	 * @since 2007.03.02
	 */
	protected String[] msgOpt;

	/** G[̋N. */
	protected String string;

	/** 񒆂̃G[̋Nʒu. */
	protected int pos = -1;

	/** ͂Ă. */
	protected String ename = "word";

	/** ߒ̕. */
	protected String word;

	protected EvalException(RuntimeException e) {
		super(e);
	}

	/**
	 * RXgN^[
	 *
	 * @param msg
	 *            G[bZ[WR[h
	 * @param lex
	 *            ͈ʒu
	 * @since 2007.03.02
	 */
	public EvalException(int msg, Lex lex) {
		this(msg, null, lex);
	}

	/**
	 * RXgN^[
	 *
	 * @param msg
	 *            G[bZ[WR[h
	 * @param opt
	 *            G[bZ[WIvV
	 * @param lex
	 *            ͈ʒu
	 * @since 2007.03.02
	 */
	public EvalException(int msg, String[] opt, Lex lex) {
		this.msgCode = msg;
		this.msgOpt = opt;
		if (lex != null) {
			this.string = lex.getString();
			this.pos = lex.getPos();
			this.ename = "word";
			this.word = lex.getWord();
		}
	}

	/**
	 * RXgN^[
	 *
	 * @param msg
	 *            G[bZ[WR[h
	 * @param exp
	 *            Expression
	 * @param e
	 *            ƂȂO
	 */
	public EvalException(int msg, AbstractExpression exp, Throwable e) {
		this(msg, exp.getExpressionName(), exp.getWord(), exp.getString(), exp
				.getPos(), e);
	}

	/**
	 * RXgN^[
	 *
	 * @param msg
	 *            G[bZ[WR[h
	 * @param word
	 *            Ώە
	 * @param exp
	 *            Expression
	 * @param e
	 *            ƂȂO
	 */
	public EvalException(int msg, String word, AbstractExpression exp,
			Throwable e) {
		this(msg, exp.getExpressionName(), word, exp.getString(), exp.getPos(),
				e);
	}

	/**
	 * RXgN^[
	 *
	 * @param msg
	 *            G[bZ[WR[h
	 * @param expName
	 *            ͖
	 * @param word
	 *            Ώە
	 * @param string
	 *            S
	 * @param pos
	 *            ʒu
	 * @param e
	 *            ƂȂO
	 * @since 2007.03.02
	 */
	public EvalException(int msg, String expName, String word, String string,
			int pos, Throwable e) {
		initException(e);
		this.msgCode = msg;
		this.string = string;
		this.pos = pos;
		this.ename = expName;
		this.word = word;
	}

	protected void initException(Throwable e) {
		while (e != null) {
			if (e.getClass() == RuntimeException.class && e.getCause() != null) {
				e = e.getCause();
			} else {
				break;
			}
		}
		if (e != null) {
			super.initCause(e);
		}
	}

	/**
	 * G[R[h擾
	 *
	 * @return G[R[h
	 * @since 2007.03.02
	 */
	public int getErrorCode() {
		return msgCode;
	}

	/**
	 * bZ[Wt擾
	 *
	 * @return t
	 * @since 2007.03.02
	 */
	public String[] getOption() {
		return msgOpt;
	}

	/**
	 * ͖̎擾.
	 *
	 * @return ͖
	 */
	public String getExpressionName() {
		return ename;
	}

	/**
	 * Ώێʎq擾
	 *
	 * @return 
	 * @since 2007.03.02
	 */
	public String getWord() {
		return word;
	}

	/**
	 * ͑O擾
	 *
	 * @return 
	 * @since 2007.03.02
	 */
	public String getString() {
		return string;
	}

	/**
	 * G[ʒu擾
	 *
	 * @return ʒu
	 * @since 2007.03.02
	 */
	public int getPos() {
		return pos;
	}

	/**
	 * @see EvalExceptionFormatter#toString(EvalException)
	 */
	@Override
	public String toString() {
		return EvalExceptionFormatter.getDefault().toString(this);
	}
}
