/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIInputStream;
import org.eclipse.swt.internal.mozilla.nsISupports;

class InputStream {
    XPCOMObject inputStream;
    int refCount = 0;
    byte[] buffer;
    int index = 0;

    InputStream(byte[] byArray) {
        this.buffer = byArray;
        this.index = 0;
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.inputStream = new XPCOMObject(new int[]{2, 0, 0, 0, 1, 3, 4, 1}){

            public long method0(long[] lArray) {
                return InputStream.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return InputStream.this.AddRef();
            }

            public long method2(long[] lArray) {
                return InputStream.this.Release();
            }

            public long method3(long[] lArray) {
                return InputStream.this.Close();
            }

            public long method4(long[] lArray) {
                return InputStream.this.Available(lArray[0]);
            }

            public long method5(long[] lArray) {
                return InputStream.this.Read(lArray[0], (int)lArray[1], lArray[2]);
            }

            public long method6(long[] lArray) {
                return InputStream.this.ReadSegments(lArray[0], lArray[1], (int)lArray[2], lArray[3]);
            }

            public long method7(long[] lArray) {
                return InputStream.this.IsNonBlocking(lArray[0]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.inputStream != null) {
            this.inputStream.dispose();
            this.inputStream = null;
        }
    }

    long getAddress() {
        return this.inputStream.getAddress();
    }

    int QueryInterface(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return -2147467262;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, l, 16);
        if (nsID2.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(l2, new long[]{this.inputStream.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(nsIInputStream.NS_IINPUTSTREAM_IID) || nsID2.Equals(nsIInputStream.NS_IINPUTSTREAM_17_IID)) {
            XPCOM.memmove(l2, new long[]{this.inputStream.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(l2, new long[]{0L}, (long)C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int Close() {
        this.buffer = null;
        this.index = 0;
        return 0;
    }

    int Available(long l) {
        int n = this.buffer == null ? 0 : this.buffer.length - this.index;
        XPCOM.memmove(l, new int[]{n}, 4L);
        return 0;
    }

    int Read(long l, int n, long l2) {
        int n2 = Math.min(n, this.buffer == null ? 0 : this.buffer.length - this.index);
        if (n2 > 0) {
            byte[] byArray = new byte[n2];
            System.arraycopy(this.buffer, this.index, byArray, 0, n2);
            XPCOM.memmove(l, byArray, (long)n2);
            this.index += n2;
        }
        XPCOM.memmove(l2, new int[]{n2}, 4L);
        return 0;
    }

    int ReadSegments(long l, long l2, int n, long l3) {
        int n2;
        int[] nArray;
        int n3;
        int n4 = n3 = this.buffer == null ? 0 : this.buffer.length - this.index;
        if (n != -1) {
            n3 = Math.min(n3, n);
        }
        for (n2 = n3; n2 > 0; n2 -= nArray[0]) {
            nArray = new int[1];
            long l4 = XPCOM.Call(l, this.getAddress(), l2, this.buffer, this.index, n2, nArray);
            if (l4 != 0L) break;
            this.index += nArray[0];
        }
        XPCOM.memmove(l3, new int[]{n3 - n2}, 4L);
        return 0;
    }

    int IsNonBlocking(long l) {
        XPCOM.memmove(l, new boolean[]{false});
        return 0;
    }
}

