// test_lviconvwrapper.c - 
// 
// build : gcc test_lviconvwrapper.c liblviconvwrapper.so -o test_lviconvwrapper

#include <stdio.h>
#include <string.h>

#include "lviconvwrapper.h"

#define BUFF_SIZE 1024

// sjis の"あいうえおかきくけこさしすせそたちつてと"
const unsigned char sjis[] = {
	0x82,0xA0,0x82,0xA2,0x82,0xA4,0x82,0xA6,0x82,0xA8,
	0x82,0xA9,0x82,0xAB,0x82,0xAD,0x82,0xAF,0x82,0xB1,
	0x82,0xB3,0x82,0xB5,0x82,0xB7,0x82,0xB9,0x82,0xBB,
	0x82,0xBD,0x82,0xBF,0x82,0xC2,0x82,0xC4,0x82,0xC6,
	0x00 };

// utf8 の"あいうえおかきくけこさしすせそたちつてと"
const unsigned char utf8[] = {
	0xE3,0x81,0x82,0xE3,0x81,0x84,0xE3,0x81,0x86,0xE3,
	0x81,0x88,0xE3,0x81,0x8A,0xE3,0x81,0x8B,0xE3,0x81,
	0x8D,0xE3,0x81,0x8F,0xE3,0x81,0x91,0xE3,0x81,0x93,
	0xE3,0x81,0x95,0xE3,0x81,0x97,0xE3,0x81,0x99,0xE3,
	0x81,0x9B,0xE3,0x81,0x9D,0xE3,0x81,0x9F,0xE3,0x81,
	0xA1,0xE3,0x81,0xA4,0xE3,0x81,0xA6,0xE3,0x81,0xA8,
	0x00 };

int main(int argc, char *argv[])
{
	unsigned char src_text[BUFF_SIZE];
	unsigned char dst_text[BUFF_SIZE];
	int srclen, dstlen;

	int ret = 0;

	strcpy((char*)src_text, (char*)sjis);
	srclen = strlen((char*)src_text);
	dstlen = BUFF_SIZE - 1;
	ret = SJIStoUTF8(src_text, srclen, dst_text, dstlen);
	if (ret == 0) {
		printf("dst_text = %s\n", dst_text);
	}

	return 0;
}
