#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QLabel>
#include <QDateTime>

#include "daqthread.h"

#include "ImageView.h"
#include "ImageCapture.h"

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
    
public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

signals:
    void LogStart(QString logfolderpath);
    void LogStop();

private slots:
    void slotGetData(QDateTime, double, double);
    void slotChangeLogFilename(QString);
    void slotSaveCurrentImage(QString imgfilepath, QString overlay_text);
    void slotLogStarted();
    void slotLogEnded(int status);

    void on_actionExit_triggered();

    void on_pushButton_LogStart_clicked();

    void on_actionAbout_triggered();

    void on_actionAboutQt_triggered();

private:
    Ui::MainWindow *ui;

    QLabel *label_statusbar;
    QString IniFilepath;
    void LoadSaveSetting(QString inifilepath, bool store);

    bool logging; // Log Status, true is logging
    DAQThread *daqTh;

    QString logpath; // Log Save Folder Path

    QDateTime logstart_time; // for lapsed time

    ImageCapture*	imageCapture;
};

#endif // MAINWINDOW_H
