#include <QDebug>

#include "daqthread.h"
#include "usbrh.h"

DAQThread::DAQThread(QObject *parent) :
    QThread(parent)
{
    stopped = false;

    logging = false;

    // Init & Start Log Thread
    logTh = new LogThread(this);
    // connect signals
    connect(this, SIGNAL(LogStart(QString)),
            logTh, SLOT(slotLogStart(QString)));
    connect(this, SIGNAL(LogStop()),
            logTh, SLOT(slotLogStop()));
    connect(logTh, SIGNAL(LogStarted()),
            this, SLOT(slotLogStarted()));
    connect(logTh, SIGNAL(LogEnded(int)),
            this, SLOT(slotLogEnded(int)));
    connect(logTh, SIGNAL(ChangeLogFilename(QString)),
            this, SIGNAL(ChangeLogFilename(QString)));
    connect(logTh, SIGNAL(SaveCurrentImage(QString, QString)),
            this,  SIGNAL(SaveCurrentImage(QString, QString)));

    // logTh start
    logTh->start();
}

DAQThread::~DAQThread()
{
    logTh->stop();
    logTh->wait();
    delete logTh;

}

void DAQThread::stop()
{
    stopped = true;
}

void DAQThread::slotLogStarted() {
    logging = true;
    emit LogStarted(); // logTh -> DaqTh(this) -> MainWindow
}

void DAQThread::slotLogEnded(int status) {

    logging = false;
    emit LogEnded(status); // logTh -> DaqTh(this) -> MainWindow
}

void DAQThread::run()
{
    int index = 0;
    BSTR deviceStr = FindUSB( &index );
    if (deviceStr) {
        // ui->detectSensor->setText( "Selected" );
        qDebug() << "Success, Found USBRH";
    } else {
        // ui->detectSensor->setText( "No Sensor" );
        qDebug() << "Fail, not Find USBRH";
    }

    QDateTime timestamp;
    double tmpr, humid;
    while(!stopped) {
        if (1) {
            timestamp = QDateTime::currentDateTime();

            GetTempHumidTrue(deviceStr, &tmpr, &humid); // Get Data from USBRH

            //qDebug() << "NowTime=" << timestamp << ", Tempr=" << tmpr << ", humid=" << humid;
            emit GetData(timestamp, tmpr, humid); // Send Data to MainWindow

            if (logging) {
                // Send Data to LogTh; // toMSecsSinceEpoch() is UTC ms uint64
                logTh->LogData(timestamp.toMSecsSinceEpoch(), tmpr, humid); // Queue is id(int32), dmy(int32), timstamp_ms, tmpr, humid
            }
        }
        sleep(1);
    }
    qDebug() << "daqTh is stopped.";

}
