#include "ImageView.h"
// ------------------------------------------------------------------------------------------------

ImageView::ImageView( QWidget *parent ) : QGraphicsView( parent )
{
	setScene( &scene );			// QGraphicsView にscene をセット
	imageCapture	= NULL;
	pixmapItem		= NULL;
    captureInterval = 0.1; // 0.1 is 100ms
	scaleValue		= 1.0;

    float hscale      = 0.5f;
    float vscale      = 0.5f;
    float italicscale = 0.0f;
    int  thickness    = 1;
    cvInitFont (&dfont, CV_FONT_HERSHEY_SIMPLEX , hscale, vscale, italicscale, thickness);
}
// ------------------------------------------------------------------------------------------------

ImageView::~ImageView()
{

}
// ------------------------------------------------------------------------------------------------
void ImageView::setCapture( ImageCapture* _capture )
{
	imageCapture = _capture;
}
// ------------------------------------------------------------------------------------------------
#if 0
// ツールバーの設定
OtToolBar* ImageView::getToolBar( QWidget* parent )
{
	OtToolBar* toolBar = new OtToolBar(parent);
	toolBar->add( this,	SLOT(load()),		"load image",	":Resources/icons/folder_image.png"	);
	toolBar->add( this,	SLOT(save()),		"save image",	":Resources/icons/disk.png" );
	toolBar->addSeparator();
	toolBar->add( this,	SLOT(zoomIn()),		"zoom in",		":Resources/icons/zoom_in.png" );
	toolBar->add( this,	SLOT(zoomOut()),	"zoom out",		":Resources/icons/zoom_out.png" );
	toolBar->addSeparator();
	toolBar->add( this,	SLOT(grab()),		"grab",			":Resources/icons/camera.png" );
	toolBar->add( this,	SLOT(startTimer()),	"grabbing",		":Resources/icons/camera_go.png",    "0" );
	toolBar->add( this,	SLOT(stopTimer()),	"stop grabbing",":Resources/icons/camera_delete.png","0" );
	toolBar->setIconSize( QSize( 16, 16 ) );
	toolBar->select( "0", "stop grabbing" );
	return toolBar;
}
#endif
// ------------------------------------------------------------------------------------------------
// 画像撮り込み
void ImageView::grab()
{
	if ( imageCapture==NULL )	return;
	QImage* qimage = imageCapture->grab();
	showQImage( qimage );
    delete qimage;
}
// ------------------------------------------------------------------------------------------------
// QImage 画像の表示
void  ImageView::showQImage( QImage* qimage )
{
	if ( qimage==NULL )		return;
	image = *qimage;
	QPixmap pixmap = QPixmap::fromImage( image );
	if ( pixmapItem==NULL )		pixmapItem = scene.addPixmap( pixmap );
	else						pixmapItem->setPixmap( pixmap );
	return;
}
// ------------------------------------------------------------------------------------------------
// 画像撮り込みタイマースタート
void ImageView::startTimer()
{
	timer.start( (int)(captureInterval*1000) );
	connect( &timer, SIGNAL(timeout()) , this, SLOT(grab()) );
}
// ------------------------------------------------------------------------------------------------
// 画像撮り込みタイマーストップ
void ImageView::stopTimer()
{
	timer.stop();
	disconnect( this, SLOT(grab()) );
}
// ------------------------------------------------------------------------------------------------
// 画像ファイル読み出し
void ImageView::load()
{
	QString fileName = QFileDialog::getOpenFileName( this, "Open Image", "./", "Image Files (*.jpg *.bmp)" );
    if ( fileName.isEmpty() )	return;
    QByteArray tmp = fileName.toLocal8Bit();
    IplImage* iplImage = cvLoadImage( tmp.constData() );

	showQImage( imageCapture->iplToQ( iplImage ) );
}
// ------------------------------------------------------------------------------------------------
// 画像ファイルへ保存
void ImageView::save()
{
	QString fileName = QFileDialog::getSaveFileName( this, "Save Image", "./", "Image Files (*.jpg *.bmp)" );
    if ( fileName.isEmpty()) return;
	image.save( fileName );
}
// ------------------------------------------------------------------------------------------------
// ズームイン
void  ImageView::zoomIn()
{	
	double d = 2.0;
	if ( scaleValue<1.0 )	d = 1.25;
	scaleXY( d );	
}
// ------------------------------------------------------------------------------------------------
// ズームアウト
void  ImageView::zoomOut()
{	
	double d = 0.5;
	if ( scaleValue<=1.0 )	d = 0.75;
	scaleXY( d );	
}
// ------------------------------------------------------------------------------------------------
// スケーリング、センター合わせ
void ImageView::scaleXY( double d )
{
	scale( d, d );
	scaleValue *= d;
	QPoint pt = geometry().center();
	centerOn( mapToScene( pt ) );
}
// ------------------------------------------------------------------------------------------------
// 最新画像をファイルへ保存
void ImageView::saveCurrentImage(QString filepath, QString overlay_text)
{
    if (imageCapture==NULL ) return;
    if (filepath.isEmpty()) return;

    if (overlay_text.isEmpty()) {
        ;
    } else {
        QByteArray msg = overlay_text.toLocal8Bit();
        // Overley text
        cvPutText(imageCapture->GetCurrentIplImage(), msg.constData(), cvPoint(20, 20), &dfont, CV_RGB(0, 255, 0));
    }

    QByteArray tmppath = filepath.toLocal8Bit();
    cvSaveImage(tmppath.constData(), imageCapture->GetCurrentIplImage());
}
