#ifndef IMAGECAPTURE_H
#define IMAGECAPTURE_H
// ------------------------------------------------------------------------------------------------

#include <QtGui/QMainWindow>
#include <opencv/cv.h>
#include <opencv/cvaux.h>
#include <opencv/cxcore.h>
#include <opencv/highgui.h>
//#include <opencv/cxtypes.h>

// ------------------------------------------------------------------------------------------------
class ImageCapture 
{
public:
	ImageCapture( int camNo, int width, int height );
	~ImageCapture();

	CvCapture*  capture;

	QImage* grab();

	QImage* iplToQ( IplImage* image );	// IplImage* -> QImage* への変換を行う。

    IplImage* GetCurrentIplImage();

private:
    IplImage* currentIplImage; // 最新のカメラ画像保存領域へのポインタ

    int wait_count;
};

// ------------------------------------------------------------------------------------------------
#endif // IMAGECAPTURE_H
