#include "ImageCapture.h"

// ------------------------------------------------------------------------------------------------
ImageCapture::ImageCapture( int cameraNo, int width, int height )
{
	capture = cvCreateCameraCapture( cameraNo );
//	cvSetCaptureProperty( capture, CV_CAP_PROP_FPS,1 );
	cvSetCaptureProperty( capture, CV_CAP_PROP_FRAME_WIDTH,  width );
	cvSetCaptureProperty( capture, CV_CAP_PROP_FRAME_HEIGHT, height );
	IplImage* frame = cvQueryFrame( capture );

    CvSize framesize = cvSize(
        (int)cvGetCaptureProperty(capture,CV_CAP_PROP_FRAME_WIDTH ),
        (int)cvGetCaptureProperty(capture,CV_CAP_PROP_FRAME_HEIGHT ));
    currentIplImage = cvCreateImage(framesize, IPL_DEPTH_8U, 3);

    wait_count = 0;
}

// ------------------------------------------------------------------------------------------------
ImageCapture::~ImageCapture()
{
    cvReleaseImage(&currentIplImage);

	cvReleaseCapture( &capture );
}
// ------------------------------------------------------------------------------------------------
QImage* ImageCapture::grab()
{
	IplImage* frame = cvQueryFrame( capture );
    if (10 < wait_count) {
        cvCopy(frame, currentIplImage);
        wait_count = 0;
    } else {
        wait_count++;
    }

	return iplToQ( frame );
}
// ------------------------------------------------------------------------------------------------
QImage* ImageCapture::iplToQ( IplImage* _image )
{
	QImage* qimage = NULL;
	if ( _image->depth!=IPL_DEPTH_8U )	return qimage;
	if ( _image->nChannels!=3 )			return qimage;

	qimage = new QImage( ( unsigned char * )_image->imageData, 
									 _image->width, 
									 _image->height, 
									 QImage::Format_RGB888 );
	*qimage = qimage->rgbSwapped();
	return qimage;
}

// ------------------------------------------------------------------------------------------------
IplImage* ImageCapture::GetCurrentIplImage()
{
    return currentIplImage;
}
