#ifndef LOGTHREAD_H
#define LOGTHREAD_H

#include <QThread>
#include <QQueue>


typedef struct StEventData {
    int id;
    int dmy;
    quint64 timestamp_ms; // toMSecsSinceEpoch
    double tmpr;
    double humid;
} EventData;

class LogThread : public QThread
{
    Q_OBJECT
public:
    explicit LogThread(QObject *parent = 0);
    ~LogThread();
    void stop();

    void LogData(quint64 timestamp, double tmpr, double humid);

signals:
    void LogStarted();
    void LogEnded(int status); // status 0 is success, !0 is Fail
    void ChangeLogFilename(QString filename);

public slots:
    void slotLogStart(QString logfolderpath);
    void slotLogStop();

protected:
    void run();

private:
    volatile bool stopped;

    bool logging; // log status, true is logging

    QString logsavefolderpath; // log save folder
    QString logfilepath; // log file path

    enum { Ev_Nop = 0,
           Ev_Log_Start, // start SaveData to File
           Ev_Log_Stop,  // stop  SaveData to File
           Ev_Log_Data   // Append Data to Streaming
         };

    QQueue<EventData> *EvtQue; // EventQue

};

#endif // LOGTHREAD_H
