#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QMessageBox>
#include <QDebug>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    ui->pushButton_StartStop->setEnabled(false);
    flag_aiexec_status = false;

    // Init & Start DAQ Thread
    DaqTh = new DAQThread(this);
    // connect signals
    connect(DaqTh, SIGNAL(daqmxbase_ready()),
                this, SLOT(daqmxbase_ready()));
    connect(DaqTh, SIGNAL(daqmxbase_final()),
                this, SLOT(daqmxbase_final()));
    connect(DaqTh, SIGNAL(daqmxbase_error(QString)),
                this, SLOT(daqmxbase_error(QString)));
    // DaqTh start
    DaqTh->start();
}

MainWindow::~MainWindow()
{
    // Final DaqTh
    DaqTh->stop();
    DaqTh->wait();
    delete DaqTh;

    delete ui;
}

void MainWindow::daqmxbase_ready()
{
    qDebug() << "DaqmxBase ready.";
    ui->pushButton_StartStop->setEnabled(true);
}

void MainWindow::daqmxbase_final()
{
    qDebug() << "DaqmxBase fine.";
    ui->pushButton_StartStop->setEnabled(false);
}

void MainWindow::daqmxbase_error(QString ErrMsg)
{
    // Dialog
    QMessageBox::critical(this, "DaqmxBase Error", ErrMsg);
}

void MainWindow::on_pushButton_StartStop_clicked()
{
    if (flag_aiexec_status) {
        DaqTh->stopAIAcq();
        ui->pushButton_StartStop->setText("Start");
        flag_aiexec_status = false;
    } else {
        DaqTh->startAIAcq();
        ui->pushButton_StartStop->setText("Stop");
        flag_aiexec_status = true;
    }
}
