#ifndef PLAYSEQUENCETHREAD_H
#define PLAYSEQUENCETHREAD_H

#include <QWidget> // WId
#include <QThread>
#include <QQueue>
#include <QTimer>
#include <QString>

#include "PlayMusicThread.h"

class PlaySequenceThread : public QThread
{
    Q_OBJECT

public:
    PlaySequenceThread(WId winId);
    ~PlaySequenceThread();
    void stop();

    void SetPlayNumList(QList<int> *);
    void SetMusicDir(const QString &dirpath);
    void SetPlaySetting(int Wait1Time_sec, int Wait2Time_sec);
    int GetPlayStatus();
    int GetPlayFudaNum();
    void Start();
    void Abort();
    void Pause();

signals:
    void SequencStartded();
    void Music1Starteded(int fudaNum);
    void Music1Ended();
    void Music2Starteded(int fudaNum);
    void Music2Ended();
    void SequenceEnded(int status); // status 0 is success, !0 is Fail

private slots:
    void PlayStarted(const QString &filename);
    void PlayEnded();
    void TimeoutDone();

protected:
    void run();
    QString GetMusicFilePath(int FudaN, int KamiShimo);
    void AbortProc();

private:
    volatile bool stopped;

    // State Machine, state Id
    enum { IDLE = 0,
           PLAY_1, // 1 Kami no ku yomiage
           WAIT_1, // 2 wait
           PLAY_2, // 3 Simo no ku yomiage
           WAIT_2, // 4 next wait
           PAUSE
         } state, prev_state;
    // State Machine, event Id
    enum { Ev_Nop = 0,
           Ev_Start,
           Ev_PlayEnd,
           Ev_TimeoutDone,
           Ev_Abort,
           Ev_Pause
         };

    QQueue<int> *EvtQue; // EventQue

    QString MusicFileDirPath;
    //    QString fnamefmt = "yamajun_%03d_%1d.ogg";
    QString fnamefmt; // filename format, "yamajun_%03d_%1d.ogg"
    int ListIndex;
    int PlayListCount;
    QList<int> *PlayNumList;

    int Wait1_sec;
    int Wait2_sec;

    PlayMusicThread *playmusicTh; // real play-music(1file) task

};


#endif // PLAYSEQUENCETHREAD_H
