// PlaySequenceThread.cpp -

#include <QCoreApplication> // appDirPath
#include <QDir>             // QDir::separator
#include <QDebug>

#include "PlaySequenceThread.h"

PlaySequenceThread::PlaySequenceThread(WId winId)
{
    // Init my task
    stopped = false;
//    fnamefmt = "inaba_%03d_%1d.ogg";
//    fnamefmt = "yamajun_%03d_%1d.ogg";
    fnamefmt = "yamajun_%03d_%1d.ogg";
    MusicFileDirPath = QCoreApplication::applicationDirPath() + QDir::separator() + tr("Music");
    Wait1_sec = 1;
    Wait2_sec = 3;
    PlayNumList = NULL;
    state = IDLE;
    EvtQue = new QQueue<int>();

    // Init real play-music task
    playmusicTh = new PlayMusicThread(winId);

    connect(playmusicTh, SIGNAL(MusicStarted(QString)),
            this, SLOT(PlayStarted(QString)));
    connect(playmusicTh, SIGNAL(MusicEnded()),
            this, SLOT(PlayEnded()));

    playmusicTh->start();
}

PlaySequenceThread::~PlaySequenceThread()
{
    // finalize real play-music task
    playmusicTh->stop();
    playmusicTh->wait();
    delete playmusicTh;

    // finalize my task
    delete EvtQue;
}

void PlaySequenceThread::stop()
{
    stopped = true;
}


// SLOT
void PlaySequenceThread::PlayStarted(const QString &filename)
{
    // receive PlayStarted -> to MainWindow PlayStarted Signal;
    if (state == PLAY_1) {
        emit Music1Starteded(PlayNumList->at(ListIndex));
    } else if (state == PLAY_2) {
        emit Music2Starteded(PlayNumList->at(ListIndex));
    }
}

// SLOT
void PlaySequenceThread::PlayEnded()
{
    // receive PlayStarted -> to MainWindow PlayEnded Signal;
    if (state == PLAY_1) {
        EvtQue->enqueue(Ev_PlayEnd);
        emit Music1Ended();
    } else if (state == PLAY_2){
        EvtQue->enqueue(Ev_PlayEnd);
        emit Music2Ended();
    }
}
// SLOT
void PlaySequenceThread::TimeoutDone()
{
    if (state == WAIT_1 || state == WAIT_2 ) {
        EvtQue->enqueue(Ev_TimeoutDone);
    }
}

void PlaySequenceThread::SetPlayNumList(QList<int> *NumList)
{
    if (state != IDLE) return;
    if (NumList == NULL || NumList->isEmpty()) return;

    PlayNumList = NumList;
}

void PlaySequenceThread::SetMusicDir(const QString &dirpath)
{
    if (state != IDLE) return;
    if (dirpath.isEmpty()) return;
//    if (dirpath is not exist?) return;
    MusicFileDirPath = dirpath;
}

void PlaySequenceThread::SetPlaySetting(int Wait1Time_sec, int Wait2Time_sec)
{
    if (state != IDLE) return;

    Wait1_sec = Wait1Time_sec;
    Wait2_sec = Wait2Time_sec;
}

int PlaySequenceThread::GetPlayStatus()
{
    return state; // IDLE = 0 / other != 0
}

int PlaySequenceThread::GetPlayFudaNum()
{
    if (state == IDLE || state == PAUSE) return -1;

    return PlayNumList->at(ListIndex); // FudaNum // FudaNum#0 is Makura, 1 is akinota, 100 is momosiki
}

void PlaySequenceThread::Start()
{
    if (state == IDLE || state == PAUSE) {
        EvtQue->enqueue(Ev_Start);
    }
}

void PlaySequenceThread::Abort()
{
    if (state == IDLE) return;
    EvtQue->enqueue(Ev_Abort);
}

void PlaySequenceThread::Pause()
{
    if (state == IDLE || state == PAUSE) return;
    EvtQue->enqueue(Ev_Pause);
}

QString PlaySequenceThread::GetMusicFilePath(int FudaN, int KamiShimo)
{
    QString filepath;
    QString dmy;
    filepath = MusicFileDirPath + QDir::separator() + dmy.sprintf(fnamefmt.toLocal8Bit(), FudaN, KamiShimo);
    return filepath;
}

void PlaySequenceThread::AbortProc()
{
    ListIndex = 0;
    PlayNumList = NULL;
    PlayListCount = 0;
    playmusicTh->StopMusic();

    emit SequenceEnded(0);
}

void PlaySequenceThread::run()
{
    int FudaN = 0;
    int Counter = 0;
    int CountMax = 0;

    ListIndex = 0;
    PlayListCount = 0;
    prev_state = IDLE;

    int event = 0;
    while (!stopped) {
        if (EvtQue->isEmpty()) {
            if (CountMax != 0 && (state == WAIT_1 || state == WAIT_2)) {
                if (Counter < CountMax) {
                    Counter++;
                } else {
                    // Timeup
                    TimeoutDone(); // send event mytask
                    Counter = 0;
                    CountMax = 0;
                }
            }
            msleep(100);
            continue;  // Jump to Next Loop
        }

        event = EvtQue->dequeue();
        switch (state) {
        case IDLE:
            if (event == Ev_Start && PlayNumList != NULL && !(PlayNumList->isEmpty()) ) {
                ListIndex = 0;
                PlayListCount = PlayNumList->count();
                FudaN = PlayNumList->at(ListIndex);
                if (FudaN != 0) { // FudaN == 0 is Special Card (Joka)
                    playmusicTh->PlayMusic(GetMusicFilePath(PlayNumList->at(ListIndex), 1));
                    state = PLAY_1;
                } else {
                    playmusicTh->PlayMusic(GetMusicFilePath(PlayNumList->at(ListIndex), 2));
                    state = PLAY_2;
                }
            }
            break;
        case PLAY_1:
            if (event == Ev_PlayEnd) {
                // Timer->Start()
                Counter = 0;
                CountMax = (Wait1_sec * 10); // this thread 100ms loop, 100ms * 10 = 1sec
                state = WAIT_1;
            } else if (event == Ev_Abort) {
                AbortProc();
                state = IDLE;
            } else if (event == Ev_Pause) {
                playmusicTh->StopMusic();
                state = PAUSE;
                prev_state = PLAY_1;
            }
            break;
        case WAIT_1:
            if (event == Ev_TimeoutDone) {
                playmusicTh->PlayMusic(GetMusicFilePath(PlayNumList->at(ListIndex), 2));
                // Timer->stop();
                state = PLAY_2;
            } else if (event == Ev_Abort) {
                AbortProc();
                state = IDLE;
            } else if (event == Ev_Pause) {
                // Timer->stop();
                state = PAUSE;
                prev_state = WAIT_1;
            }
            break;
        case PLAY_2:
            if (event == Ev_PlayEnd) {
                if ((ListIndex + 1) >= PlayListCount) {
                    // List Final -> SequenceEnd, goto IDLE
                    ListIndex = 0;
                    PlayNumList = NULL;
                    PlayListCount = 0;
                    emit SequenceEnded(0);
                    state = IDLE;
                } else {
                    // Next -> Wait2, after goto Next PLAY_1
                    ListIndex++;
                    // Timer->Start()
                    Counter = 0;
                    CountMax = (Wait2_sec * 10); // this thread 100ms loop, 100ms * 10 = 1sec
                    qDebug() << "WAIT_2 Start";
                    state = WAIT_2;
                }
            } else if (event == Ev_Abort) {
                AbortProc();
                state = IDLE;
            } else if (event == Ev_Pause) {
                playmusicTh->StopMusic();
                state = PAUSE;
                prev_state = PLAY_2;
            }
            break;
        case WAIT_2:
            if (event == Ev_TimeoutDone) {
                playmusicTh->PlayMusic(GetMusicFilePath(PlayNumList->at(ListIndex), 1));
                // WaitTimer->stop();
                state = PLAY_1;
            } else if (event == Ev_Abort) {
                AbortProc();
                state = IDLE;
            } else if (event == Ev_Pause) {
                // WaitTimer->stop();
                state = PAUSE;
                prev_state = WAIT_2;
            }
            break;
        case PAUSE:
            if (event == Ev_Start) {
                FudaN = PlayNumList->at(ListIndex);
                if (prev_state == WAIT_2 && ListIndex > 0) ListIndex--; // prev rewind when WAIT_2
                if (prev_state == PLAY_1 && FudaN != 0) { // FudaN == 0 is Special Card (Joka)
                    playmusicTh->PlayMusic(GetMusicFilePath(PlayNumList->at(ListIndex), 1));
                    state = PLAY_1;
                } else {
                    playmusicTh->PlayMusic(GetMusicFilePath(PlayNumList->at(ListIndex), 2));
                    state = PLAY_2;
                }
                prev_state = IDLE;
            } else if (event == Ev_Abort) {
                AbortProc();
                state = IDLE;
            }
            break;
        default:
            break;
        }
        msleep(100);
    }

    // Thread Finish
    if (state == PLAY_1 || state == PLAY_2) {
        playmusicTh->StopMusic();
        emit SequenceEnded(0);
    } else if (state == WAIT_1 || state == WAIT_2) {
        // WaitTimer->stop();
        emit SequenceEnded(0);
    } else if (state == PAUSE) {
        emit SequenceEnded(0);
    }
}
