
#include <QDebug>

#include <QMessageBox>
#include <QFileDialog>
#include <QDropEvent>
#include <QUrl>

#include <QFile>
#include <QCryptographicHash>

#include "mainwindow.h"
#include "ui_mainwindow.h"

#if 0
QString CalcMD5(QString filepath)
{
    QString ret = "";
    QCryptographicHash hash(QCryptographicHash::Md5);

    QFile in(filepath);

    if (in.open(QIODevice::ReadOnly)) {
        char buf[2048];
        int bytesRead;

        while ((bytesRead = in.read(buf, 2048)) > 0) {
            hash.addData(buf, bytesRead);
        }

        in.close();
        ret = hash.result().toHex();
    } else {
        qDebug() << "Failed to open device!";
    }
    return ret;
}
#endif

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    ui->progressBar->setValue(0);

    firstShow = true;

    setAcceptDrops(true); // available Drop file

    thcalcmd5 = new ThCalcMD5(this);
    connect(thcalcmd5, SIGNAL(notify_calc_end(QString)),
            this, SLOT(slot_calc_end(QString)));
    connect(thcalcmd5, SIGNAL(notify_calc_progress(int)),
            this, SLOT(slot_calc_progress(int)));
    thcalcmd5->start();

}

MainWindow::~MainWindow()
{
    thcalcmd5->stop();
    thcalcmd5->wait();
    delete thcalcmd5;

    delete ui;
}

void MainWindow::on_actionExit_triggered()
{
    close();
}

void MainWindow::showEvent(QShowEvent *event)
{
    if (firstShow) {
        // Command-Line Parameter
        if (1 < args.size()) {
            //QString stmp = args.at(1).toLocal8Bit().constData();
            QString stmp = args.at(1);
            ui->lineEdit_FilePath->clear();
            ui->lineEdit_FilePath->setText(stmp);
        }
        firstShow = false;
    }
    QMainWindow::showEvent(event);
}

void MainWindow::dragEnterEvent(QDragEnterEvent *event)
{
    if (event->mimeData()->hasFormat("text/uri-list"))
        event->acceptProposedAction();
}
void MainWindow::dropEvent(QDropEvent *event)
{
    QString stmp = event->mimeData()->urls().at(0).path();
    QRegExp rx("^/[A-Z]:/"); // isDriveLetter?
    if (0 > rx.indexIn(stmp)) {
        ; // not match
    } else {
        // match, is filepath ("/C:/tmp/")
        stmp = stmp.mid(1); // remove 1st '/' character, from url.path()
    }
    ui->lineEdit_FilePath->clear();
    ui->lineEdit_FilePath->setText(stmp);
    event->acceptProposedAction();
}


void MainWindow::on_actionAbout_triggered()
{
    QMessageBox::about(this, "About", tr("Qt Calc MD5 v0.1"));
}

void MainWindow::on_actionAbout_Qt_triggered()
{
    QApplication::aboutQt();
}

void MainWindow::on_toolButton_Select_clicked()
{
    QString fileName = QFileDialog::getOpenFileName(
                this,
                tr("Select File"), // title
                QDir::homePath(), // CurrentPath
                tr("All Files (*)")); // Filter
    if (!fileName.isEmpty()) {
        ui->lineEdit_FilePath->clear();
        ui->lineEdit_FilePath->setText(fileName);

        ui->progressBar->setValue(0);
        ui->checkBox_result->setText("");
        // Start Calc MD5
        // on_pushButton_Start_clicked();

        if (ui->lineEdit_VerifyMD5->text().isEmpty()) {
            ;
        } else {
            ;
        }
    }
}

void MainWindow::on_lineEdit_FilePath_textChanged(const QString &arg1)
{
    // Start Calc MD5
    on_pushButton_Start_clicked();
}

void MainWindow::on_pushButton_Start_clicked()
{
//    QMessageBox::information(this, tr("information"), tr("StartButton clicked."));
    if (ui->lineEdit_FilePath->text().isEmpty()) return;

    ui->lineEdit_ResultMD5->clear();
    ui->progressBar->setValue(0);
    ui->pushButton_Abort->setEnabled(true);

    thcalcmd5->sendEvent_Start(ui->lineEdit_FilePath->text());

#if 0
    QString result;
    result = CalcMD5(ui->lineEdit_FilePath->text());
    if (result.isEmpty()) {
        ;
    } else {
        ui->lineEdit_ResultMD5->clear();
        ui->lineEdit_ResultMD5->setText(result);
        on_lineEdit_VerifyMD5_textChanged();
    }
#endif
}

void MainWindow::on_pushButton_Abort_clicked()
{
//    QMessageBox::information(this, tr("information"), tr("AbortButton clicked."));
    thcalcmd5->sendEvent_Stop();
}

void MainWindow::on_lineEdit_VerifyMD5_textChanged()
{
    if (ui->lineEdit_VerifyMD5->text().isEmpty()) return ;
    if (ui->lineEdit_FilePath->text().isEmpty()) return;

    if (ui->lineEdit_VerifyMD5->text().compare(ui->lineEdit_ResultMD5->text())) {
        ui->checkBox_result->setChecked(false);
        ui->checkBox_result->setText("Verify NG");
    } else {
        ui->checkBox_result->setChecked(true);
        ui->checkBox_result->setText("Verify OK");
    }

}

void MainWindow::slot_calc_end(QString result)
{
    if (result.isEmpty()) {
        ;
    } else {
        ui->lineEdit_ResultMD5->clear();
        ui->lineEdit_ResultMD5->setText(result);

        on_lineEdit_VerifyMD5_textChanged();
    }
    ui->pushButton_Abort->setEnabled(false);
}

void MainWindow::slot_calc_progress(int progress)
{
    ui->progressBar->setValue(progress);
}

