// GetVIVersion
// mainwindow.cpp -
//
// Time-stamp: "2013/02/13 10:02:04 +0900"

#include <stdio.h> // for GetVersionOfVI() Function

#include <QMessageBox>
#include <QFileDialog>

#include <QDropEvent>
#include <QUrl>

#include "mainwindow.h"
#include "ui_mainwindow.h"

int GetVersionOfVI(const char *filename, char *ver)
{
    FILE *ifp;
    char tmp[16];
    char verbuf1[2]; // Version info 8.0 before (6.0, 6.1, 7.1)
    char verbuf2[2]; // Version info 8.0 later (8.0, 8.2, 8.5, 8.6)

    if (NULL == (ifp = fopen(filename, "rb"))) {
        fputs("cannot open file\n", stderr);
        return -1;
    }

    // compare "RSRC"
    memset(tmp, 0, sizeof(tmp));
    fseek(ifp, 0x0L, SEEK_SET);
    fread(tmp, sizeof(char), 4, ifp);
    if (0 != strcmp(tmp, "RSRC")) {
//        fputs("not VI File\n", stderr);
        fclose(ifp);
        return 1;
    }

    // compare "LVINLBVW"
    memset(tmp, 0, sizeof(tmp));
    fseek(ifp, 0x8L, SEEK_SET);
    fread(tmp, sizeof(char), 8, ifp);
    if (0 != strcmp(tmp, "LVINLBVW")) {
//        fputs("not VI File\n", stderr);
        fclose(ifp);
        return -1;
    }

    // VersionNumber 8.0 later (8.0, 8.20, 8.5 8.6)
    fseek(ifp, 0x24L, SEEK_SET);
    fread(verbuf2, sizeof(char), 2, ifp);

    // VersionNumber 8.0 before (6.0, 6.1, 7.0 7.1)
    fseek(ifp, 0x2CL, SEEK_SET);
    fread(verbuf1, sizeof(char), 2, ifp);

    if (verbuf1[0] > 0x04 && verbuf1[0] < 0x08 ) {
        sprintf(ver, "%02x.%02x", verbuf1[0], verbuf1[1]);
    } else if (verbuf2[0] > 0x04 && verbuf2[0] < 0x30) {
        sprintf(ver, "%02x.%02x", verbuf2[0], verbuf2[1]);
    } else {
        ;
//        fputs("Version unkown.", stderr);
    }

    fclose(ifp);

    return 0;
}

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    firstShow = true; // 1'st Time only Exec flag

    setAcceptDrops(true); // for File Drop
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::showEvent(QShowEvent *event)
{
    if (firstShow) {
        // Command-Line Parameter
        if (1 < args.size()) {
            //QString stmp = args.at(1).toLocal8Bit().constData();
            QString stmp = args.at(1);
            ui->lineEdit_FilePath->clear();
            ui->lineEdit_FilePath->setText(stmp);
        }
        firstShow = false;
    }
    QMainWindow::showEvent(event);
}

void MainWindow::dragEnterEvent(QDragEnterEvent *event)
{
    if (event->mimeData()->hasFormat("text/uri-list"))
         event->acceptProposedAction();
}

void MainWindow::dropEvent(QDropEvent *event)
{
    QString stmp = event->mimeData()->urls().at(0).path();

    QRegExp rx("^/[A-Z]:/"); // isDriveLetter?
    if (0 > rx.indexIn(stmp)) {
        ; // not match
    } else {
        // match, is filepath ("/C:/tmp/")
        stmp = stmp.mid(1); // remove 1st '/' character, from url.path()
    }
    ui->lineEdit_FilePath->clear();
    ui->lineEdit_FilePath->setText(stmp);

    event->acceptProposedAction();
}

void MainWindow::on_lineEdit_FilePath_textChanged(QString s)
{
    const char *Filepath;
    char VerInfo[8] = {0};

    if (ui->lineEdit_FilePath->text().length() > 0) {
        QByteArray stmp = ui->lineEdit_FilePath->text().toLocal8Bit();
        Filepath = stmp.constData();
        if (0 == GetVersionOfVI(Filepath, VerInfo)) {
            ui->lineEdit_Version->setText(VerInfo);
        } else {
            ui->lineEdit_Version->setText(tr("Unknown..."));
        }
    }
}

void MainWindow::on_toolButton_clicked()
{
//    QMessageBox::information(this, tr("information"), tr("toolButton clicked."));
    QString fileName = QFileDialog::getOpenFileName(
                                this,
                                tr("Select LabVIEW VI file"),         // title
                                QDir::homePath(),                     // CurrentPath
                                tr("VI File(*.vi);;All Files (*)"));  // Filter

   if (!fileName.isEmpty()) {
            ui->lineEdit_FilePath->clear();
            ui->lineEdit_FilePath->setText(fileName);
    }
}

void MainWindow::on_actionExit_triggered()
{
    close();
}

void MainWindow::on_actionAbout_triggered()
{
    QMessageBox::about(this, "About", tr("Get VI Version v0.1"));
}

void MainWindow::on_actionAbout_Qt_triggered()
{
    QApplication::aboutQt();
}
