#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QTreeWidgetItem>

#include <QDebug>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

//    treeWidget->setColumnCount(1);
    for (int i = 0; i < 10; i++) {
        addList(ui->treeWidget, QString("hogehoge.%1").arg(i), QString("hogehoge.%1@mail.foo.com").arg(i));
    }
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::addList(QTreeWidget *treew, QString name, QString email)
{
    QTreeWidgetItem *itm = new QTreeWidgetItem(treew);
    itm->setText(0, name);
    itm->setText(1, email);
    treew->addTopLevelItem(itm);
}

void MainWindow::on_treeWidget_doubleClicked(const QModelIndex &index)
{
    qDebug() << "Double Clicked Row Number is " << index.row();
    QTreeWidgetItem *itm = ui->treeWidget->currentItem();
    qDebug() << "Name: " << itm->text(0) << "E-Mail" <<    itm->text(1);
}

void MainWindow::on_treeWidget_clicked(const QModelIndex &index)
{
    qDebug() << "Clicked Row Number is " << index.row();
}

void MainWindow::on_pushButton_clicked()
{
    qDebug() << "Selected Row Number is " << ui->treeWidget->currentIndex().row();
    int index = ui->treeWidget->currentIndex().row();
    if (0 <= index) {
        ui->treeWidget->takeTopLevelItem(index);
        // QTreeWidgetItem *itm = ui->treeWidget->currentItem();
        // delete itm;
        qDebug() << "Count is " << ui->treeWidget->topLevelItemCount();
    }
}

void MainWindow::on_pushButton_2_clicked()
{
    ui->treeWidget->clear();
}
