#!/usr/bin/env python

import sys
import subprocess


version = { }

header = """/* This file is automatically generated by {0}!
 * Do not edit manually, any manual change will be overwritten.
 */
"""

if len(sys.argv)<3:
    print("Usage:")
    print("  {0} <infile> <outfile>".format(sys.argv[0]))
    sys.exit(1)

#Get the build repos information
identify = subprocess.check_output(["hg", "identify", "-nitb"])
identify = identify.split()
version['revision'] = identify[0]
version['local_revision'] = identify[1]
version['branch'] = identify[2]
if len(identify)>3:
  version['tag'] = identify[3]
else:
  version['tag'] = ""

try:
    version['local_revision'].index('+')
    version['modified'] = 'true'
except Exception:
    version['modified'] = 'false'

#Apply information to the file template
infile  = open(sys.argv[1], 'r')
outfile = open(sys.argv[2], 'w')

outfile.write(header.format(sys.argv[0], sys.argv[1]))
outfile.write(infile.read().format(**version))

infile.close()
outfile.close()
