#============================================================================================================
#
#	datt@CǗW[
#
#============================================================================================================
package	ARAGORN;

use strict;
use warnings;

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	W[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	
	my $obj = {
		'LINE'		=> undef,
		'PATH'		=> undef,
		'RES'		=> undef,
		'HANDLE'	=> undef,
		'MAX'		=> undef,
		'STAT'		=> 0,
		'PERM'		=> undef,
		'MODE'		=> undef,
	};
	bless $obj, $class;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	fXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub DESTROY
{
	my $this = shift;
	
	# t@CI[vԂ̏ꍇ̓N[Y
	if ($this->{'STAT'}) {
		my $fh = $this->{'HANDLE'};
		if ($fh) {
			#truncate($fh, tell($fh));
			close($fh);
			chmod $this->{'PERM'}, $this->{'PATH'};
		}
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	ǂݍ
#	-------------------------------------------------------------------------------------
#	@param	$Sys		MELKOR
#	@param	$szPath		ǂݍ݃pX
#	@param	$readOnly	[h
#	@return	ǂݍ񂾃X
#
#------------------------------------------------------------------------------------------------------------
sub Load
{
	my $this = shift;
	my ($Sys, $szPath, $readOnly) = @_;
	
	# ԂԂȂǂݍ݊Jn
	if ($this->{'STAT'} == 0) {
		$this->{'RES'} = 0;
		$this->{'LINE'} = [];
		$this->{'MAX'} = $Sys->Get('RESMAX');
		$this->{'PATH'} = $szPath;
		$this->{'PERM'} = GetPermission($szPath);
		$this->{'MODE'} = $readOnly;
		
		chmod($Sys->Get('PM-DAT'), $szPath);
		if (open(my $fh, ($readOnly ? '<' : '+<'), $szPath)) {
			flock($fh, 2);
			binmode($fh);
			my @lines = <$fh>;
			
			push @{$this->{'LINE'}}, @lines;
			
			# ݃[h̏ꍇ
			seek($fh, 0, 0) if (! $readOnly);
			
			# nhۑԂǂݍݏԂɂ
			$this->{'HANDLE'} = $fh;
			$this->{'STAT'} = 1;
			$this->{'RES'} = scalar(@{$this->{'LINE'}});
		}
		
		return $this->{'RES'};
	}
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	ēǂݍ
#	-------------------------------------------------------------------------------------
#	@param	$Sys		MELKOR
#	@param	$readOnly	[h
#	@return	ǂݍ񂾃X
#
#------------------------------------------------------------------------------------------------------------
sub ReLoad
{
	my $this = shift;
	my ($Sys, $readOnly) = @_;
	
	if ($this->{'STAT'}) {
		$this->Close();
		return $this->Load($Sys, $this->{'PATH'}, $readOnly);
	}
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Save
{
	my $this = shift;
	my ($Sys) = @_;
	
	# t@CI[vԂȂ珑݂s
	my $fh = $this->{'HANDLE'};
	if ($this->{'STAT'} && $fh) {
		if (! $this->{'MODE'}) {
			seek($fh, 0, 0);
			print $fh @{$this->{'LINE'}};
			truncate($fh, tell($fh));
			close($fh);
			
			chmod($this->{'PERM'}, $this->{'PATH'});
			$this->{'STAT'} = 0;
			$this->{'HANDLE'} = undef;
		}
		else {
			$this->Close();
		}
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	N[Y
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Close
{
	my $this = shift;
	
	# t@CI[vԂ̏ꍇ̓N[Y
	if ($this->{'STAT'}) {
		my $fh = $this->{'HANDLE'};
		#truncate($handle, tell($handle));
		close($fh);
		
		chmod($this->{'PERM'}, $this->{'PATH'});
		$this->{'STAT'} = 0;
		$this->{'HANDLE'} = undef;
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	f[^ݒ
#	-------------------------------------------------------------------------------------
#	@param	$line	ݒs
#	@param	$data	ݒf[^
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Set
{
	my $this = shift;
	my ($line, $data) = @_;
	
	$this->{'LINE'}->[$line] = $data;
}

#------------------------------------------------------------------------------------------------------------
#
#	f[^擾
#	-------------------------------------------------------------------------------------
#	@param	$line	擾s
#	@return	sf[^̎Q
#
#------------------------------------------------------------------------------------------------------------
sub Get
{
	my $this = shift;
	my ($line) = @_;
	
	if ($line >= 0 && $line < $this->{'RES'}) {
		return \($this->{'LINE'}->[$line]);
	}
	return undef;
}

#------------------------------------------------------------------------------------------------------------
#
#	f[^ǉ
#	-------------------------------------------------------------------------------------
#	@param	$data	ǉf[^
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Add
{
	my $this = shift;
	my ($data) = @_;
	
	# őf[^Ȃǉ
	if ($this->{'MAX'} > $this->{'RES'}) {
		push @{$this->{'LINE'}}, $data;
		$this->{'RES'}++;
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	f[^폜
#	-------------------------------------------------------------------------------------
#	@param	$num	폜s
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Delete
{
	my $this = shift;
	my ($num) = @_;
	
	splice @{$this->{'LINE'}}, $num, 1;
	$this->{'RES'}--;
}

#------------------------------------------------------------------------------------------------------------
#
#	X擾
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	X
#
#------------------------------------------------------------------------------------------------------------
sub Size
{
	my $this = shift;
	
	return $this->{'RES'};
}

#------------------------------------------------------------------------------------------------------------
#
#	TuWFNg擾
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	TuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub GetSubject
{
	my $this = shift;
	
	my @elem = split(/<>/, $this->{'LINE'}->[0], -1);
	$elem[4] =~ s/[\r\n]+\z//;
	
	return $elem[4];
}

#------------------------------------------------------------------------------------------------------------
#
#	Xbh~ * 0.8.x񐄏
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	:1 s:0
#
#------------------------------------------------------------------------------------------------------------
sub Stop
{
	my $this = shift;
	my ($Sys) = @_;
	
	# XXg
	my $stopData = "~܂BBB<>~<>~<>^EXbhXgbp[BBBiP[Pjد<>~B\n";
	
	# Xő吔Ăꍇ̓XXgs
	if ($this->Size() <= $Sys->Get('RESMAX')) {
		# ~ԂȂꍇ̂ݎs
		if (! $this->IsStopped($Sys)) {
			# ~f[^ǉċIɃZ[u
			$this->Add($stopData);
			$this->Save($Sys);
			
			# p[~bV~pɐݒ肷
			chmod($Sys->Get('PM-STOP'), $this->{'PATH'});
			return 1;
		}
	}
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	XbhJn * 0.8.x񐄏
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	:1 s:0
#
#------------------------------------------------------------------------------------------------------------
sub Start
{
	my $this = shift;
	my ($Sys) = @_;
	
	# ~Ԃ̏ꍇ̂ݎs
	if ($this->IsStopped($Sys)) {
		# ŏIs폜ĕۑ
		my $line = $this->{'RES'} - 1;
		$this->Delete($line);
		$this->Save($Sys);
		
		# p[~bVʏpɐݒ肷
		chmod($Sys->Get('PM-DAT'), $this->{'PATH'});
		return 1;
	}
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	datڒǋL
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@param	$path	ǋLt@CpX
#	@param	$data	ǋLf[^
#	@return	ǋLł0Ԃ
#
#------------------------------------------------------------------------------------------------------------
sub DirectAppend
{
	my ($Sys, $path, $data) = @_;
	
	if (GetPermission($path) != $Sys->Get('PM-STOP')) {
		if (open(my $fh, '>>', $path)) {
			flock($fh, 2);
			binmode($fh);
			print $fh "$data";
			close($fh);
			chmod($Sys->Get('PM-DAT'), $path);
			return 0;
		}
	}
	else {
		return 2;
	}
	
	return 1;
}

#------------------------------------------------------------------------------------------------------------
#
#	t@Cw背X擾
#	-------------------------------------------------------------------------------------
#	@param	$path	wt@CpX
#	@return	X
#
#------------------------------------------------------------------------------------------------------------
sub GetNumFromFile
{
	my ($path) = @_;
	
	my $cnt = 0;
	if (open(my $fh, '<', $path)) {
		flock($fh, 2);
		$cnt++ while (<$fh>);
		close($fh);
	}
	return $cnt;
}

#------------------------------------------------------------------------------------------------------------
#
#	p[~bV擾
#	-------------------------------------------------------------------------------------
#	@param	$path	wt@CpX
#	@return	p[~bV
#
#------------------------------------------------------------------------------------------------------------
sub GetPermission
{
	my ($path) = @_;
	
	return (-e $path ? (stat $path)[2] & 0777 : 0);
}

#------------------------------------------------------------------------------------------------------------
#
#	ړ]
#	-------------------------------------------------------------------------------------
#	@param	$path	wt@CpX
#	@return	p[~bV
#
#------------------------------------------------------------------------------------------------------------
sub IsMoved
{
	my ($path) = @_;
	
	if (open(my $fh, '<', $path)) {
		flock($fh, 2);
		my $line = <$fh>;
		close($fh);
		
		my @elem = split(/<>/, $line, -1);
		if ($elem[2] ne 'ړ]') {
			return 0;
		}
	}
	
	return 1;
}

#------------------------------------------------------------------------------------------------------------
#
#	~ * 0.8.x񐄏
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	boolean
#
#------------------------------------------------------------------------------------------------------------
sub IsStopped
{
	my $this = shift;
	my ($Sys) = @_;
	
	return $this->{'PERM'} == $Sys->Get('PM-STOP');
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
