#============================================================================================================
#
#	o͊ǗW[
#
#============================================================================================================
package	THORIN;

use strict;
use warnings;

use Template;

#------------------------------------------------------------------------------------------------------------
#
#	W[RXgN^ - new
#	-------------------------------------------
#	@FȂ
#	߂lFW[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	
	my $obj = {
		'BUFF'	=> [],
		'TT'	=> undef,
		'TMPL'	=> undef,
		'DATA'	=> undef,
	};
	bless $obj, $class;
	
	return $obj;
}

sub Init
{
	my $this = shift;
	my ($tmpl) = @_;
	
	my $template = Template->new({
		'RELATIVE'		=> 1,
		'INCLUDE_PATH'	=> './template',
		'COMPILE_DIR'	=> './template/compiled',
	});
	
	$this->{'TT'} = $template;
	$this->{'TMPL'} = $tmpl;
	$this->{'DATA'} = {};
}

sub Set
{
	my $this = shift;
	my ($data) = @_;
	
	my $d = $this->{'DATA'};
	$d->{$_} = $data->{$_} foreach (keys %$data);
}

sub Output
{
	my $this = shift;
	my ($ref) = @_;
	
	return if (!defined $this->{'TT'});
	
	$this->{'TT'}->process($this->{'TMPL'}, $this->{'DATA'}, $ref)
											or warn $this->{'TT'}->error;
}

sub OutputContentType
{
	my $this = shift;
	my ($type, $ref) = @_;
	
	if (ref($ref) eq 'SCALAR') {
		$$ref .= "Content-Type: $type\n\n";
	}
	elsif (ref($ref) eq 'GLOB' && ref(*$ref{IO}) eq 'IO::File') {
		print $ref "Content-Type: $type\n\n";
	}
	else {
		print "Content-Type: $type\n\n";
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	obt@o - Print
#	-------------------------------------------
#	@F$line : o̓eLXg
#	߂lFȂ
#
#------------------------------------------------------------------------------------------------------------
sub Print
{
	my $this = shift;
	my ($line) = @_;
	
	push @{$this->{'BUFF'}}, $line;
}

#------------------------------------------------------------------------------------------------------------
#
#	INPUT^Oo - HTMLInput
#	-------------------------------------------
#	@F$kind  : ^Cv
#			$name  : O
#			$value : l
#	߂lFȂ
#
#------------------------------------------------------------------------------------------------------------
sub HTMLInput
{
	my $this = shift;
	my ($kind, $name, $value) = @_;
	
	my $line = "<input type=$kind name=\"$name\" value=\"$value\">\n";
	
	push @{$this->{'BUFF'}}, $line;
}

#------------------------------------------------------------------------------------------------------------
#
#	obt@tbV - Flush
#	-------------------------------------------
#	@F$flag       : o̓tO
#			$perm		: p[~bV
#			$szFilePath : o̓pX
#	߂lFȂ
#
#------------------------------------------------------------------------------------------------------------
sub Flush
{
	my $this = shift;
	my ($flag, $perm, $ref) = @_;
	
	# t@C֏o
	if ($flag) {
		chmod($perm, $ref);
		if (open(my $fh, (-f $ref ? '+<' : '>'), $ref)) {
			flock($fh, 2);
			seek($fh, 0, 0);
			print $fh @{$this->{'BUFF'}};
			truncate($fh, tell($fh));
			close($fh);
		}
		chmod($perm, $ref);
	}
	elsif (ref($ref) eq 'SCALAR') {
		$$ref = join ('', @{$this->{'BUFF'}});
	}
	elsif (ref($ref) eq 'GLOB' && ref(*$ref{IO}) eq 'IO::File') {
		print $ref @{$this->{'BUFF'}};
	}
	# Wo͂ɏo
	else {
		print @{$this->{'BUFF'}};
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	obt@NA - Clear
#	-------------------------------------------
#	@FȂ
#	߂lFȂ
#
#------------------------------------------------------------------------------------------------------------
sub Clear
{
	my $this = shift;
	
	$this->{'BUFF'} = [];
}

#------------------------------------------------------------------------------------------------------------
#
#	}[W - Merge
#	-------------------------------------------
#	@F$thorin : THORINW[
#	߂lFȂ
#
#------------------------------------------------------------------------------------------------------------
sub Merge
{
	my $this = shift;
	my ($thorin) = @_;
	
	push @{$this->{'BUFF'}}, @{$thorin->{'BUFF'}};
}

#============================================================================================================
#	W[I[
#============================================================================================================
1;
