#============================================================================================================
#
#	cookieǗW[(RADAGAST)
#	radagast.pl
#	---------------------------------------------
#	2003.02.07 start
#	2004.03.20 interfaceV
#
#============================================================================================================
package RADAGAST;

use strict;
use warnings;
use Encode;

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	W[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $this = shift;
	my ($obj, %COOKIE);
	
	$obj = {
		'COOKIE'	=> \%COOKIE
	};
	bless $obj, $this;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	cookiel擾
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Init
{
	my $this = shift;
	my (@pairs, $name, $value, $gCode);
	
	undef $this->{'COOKIE'};
	
	if ($ENV{'HTTP_COOKIE'}) {
		@pairs = split(/;/, $ENV{'HTTP_COOKIE'});
		foreach (@pairs) {
			($name, $value) = split(/=/, $_);
			$name =~ s/ //g;
			$value =~ s/^"|"$//g;
			$value =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/pack('H2', $1)/eg;
			Encode::from_to($value, 'utf8', 'sjis');
			$this->{'COOKIE'}->{$name} = $value;
		}
		return 1;
	}
	return 0;
}
#------------------------------------------------------------------------------------------------------------
#
#	cookielݒ
#	-------------------------------------------------------------------------------------
#	@param	$key	L[
#	@param	$value	ݒl
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Set
{
	my $this = shift;
	my ($key, $value) = @_;
	
	$this->{'COOKIE'}->{$key} = $value;
}

#------------------------------------------------------------------------------------------------------------
#
#	cookiel擾
#	-------------------------------------------------------------------------------------
#	@param	$key	L[
#			$default : ftHg
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Get
{
	my $this = shift;
	my ($key, $default) = @_;
	my ($val);
	
	$val = $this->{'COOKIE'}->{$key};
	
	return (defined $val ? $val : (defined $default ? $default : undef));
}

#------------------------------------------------------------------------------------------------------------
#
#	cookiel폜
#	-------------------------------------------------------------------------------------
#	@param	$key	L[
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Delete
{
	my $this = shift;
	my ($key) = @_;
	
	delete $this->{'COOKIE'}->{$key};
}

#------------------------------------------------------------------------------------------------------------
#
#	cookiel݊mF
#	-------------------------------------------------------------------------------------
#	@param	$key	L[
#	@return	L[݂true
#
#------------------------------------------------------------------------------------------------------------
sub IsExist
{
	my $this = shift;
	my ($key) = @_;
	
	return exists($this->{'COOKIE'}->{$key});
}

#------------------------------------------------------------------------------------------------------------
#
#	cookieo
#	-------------------------------------------------------------------------------------
#	@param	$oOut	o̓W[
#	@param	$path	cookiepX
#	@param	$limit	L
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Out
{
	my $this = shift;
	my ($oOut, $path, $limit) = @_;
	my (@gmt, @week, @month, $date, $key, $value);
	
	# t̐ݒ
	@gmt = gmtime(time + $limit * 60);
	@week = ('Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat');
	@month = ('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');
	
	# L񐶐
	$date = sprintf('%s, %02d-%s-%04d %02d:%02d:%02d GMT',
					$week[$gmt[6]], $gmt[3], $month[$gmt[4]], $gmt[5] + 1900,
					$gmt[2], $gmt[1], $gmt[0]);
	
	# ݒ肳ĂcookieSďo͂
	foreach $key (keys %{$this->{'COOKIE'}}) {
		$value = $this->{'COOKIE'}->{$key};
		Encode::from_to($value, 'sjis', 'utf8');
		$value =~ s/([^\w])/'%'.unpack('H2', $1)/eg;
		$oOut->Print("Set-Cookie: $key=\"$value\"; expires=$date; path=$path\n");
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	cookie擾pjavascripto
#	-------------------------------------------------------------------------------------
#	@param	$oOut	o̓W[
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Print
{
	my $this = shift;
	my ($oOut) = @_;
	
	$oOut->Print(<<JavaScript);
<script language="JavaScript" type="text/javascript">
<!--
function l(e) {
	var N = getCookie("NAME"), M = getCookie("MAIL");
	for (var i = 0, j = document.forms ; i < j.length ; i++){
		if (j[i].FROM && j[i].mail) {
			j[i].FROM.value = N;
			j[i].mail.value = M;
		}}
}
window.onload = l;
function getCookie(key) {
	var ptrn = '(?:^|;| )' + key + '="(.*?)"';
	if (document.cookie.match(ptrn))
		return decodeURIComponent(RegExp.\$1);
	return "";
}
//-->
</script>
JavaScript
}

#============================================================================================================
#	W[I[
#============================================================================================================
1;
