#============================================================================================================
#
#	Abvf[gʒm
#	newrelease.pl
#
#	by 낿˂vX
#	http://zerochplus.sourceforge.jp/
#
#	---------------------------------------------------------------------------
#
#	2012.08.09 start
#
#============================================================================================================

package ZP_NEWRELEASE;

use strict;
use warnings;

use Encode;

#------------------------------------------------------------------------------------------------------------
#
#	W[RXgN^ - new
#	-------------------------------------------
#	@FȂ
#	߂lFW[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $this = shift;
	my ( $obj, %NEWRELEASE );
	
	$obj = {
		'NEWRELEASE'	=> \%NEWRELEASE
	};
	
	bless $obj, $this;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	 - Init
#	-------------------------------------------------------------------------------------
#	@F$sys : MELKOR
#	߂lF0
#
#------------------------------------------------------------------------------------------------------------
sub Init
{
	my $this = shift;
	my ( $sys ) = @_;
	undef $this->{'NEWRELEASE'};
	
	$this->{'NEWRELEASE'} = {
		'CheckURL'	=> 'http://zerochplus.sourceforge.jp/Release.txt',
		'Interval'	=> 60 * 60 * 24, # 24
		'RawVer'	=> $sys->Get('VERSION'),
		'CachePATH'	=>  '.' . $sys->Get('INFO') . '/Release.cgi',
		'CachePM'	=> $sys->Get('PM-ADM'),
		'Update'	=> 0,
	};
	
}


#------------------------------------------------------------------------------------------------------------
#
#	XV`FbN - Check
#	-------------------------------------------------------------------------------------
#	@FȂ
#	߂lF0
#
#------------------------------------------------------------------------------------------------------------
sub Check
{
	my $this = shift;
	my $hash = $this->{'NEWRELEASE'};
	my ( $url, $interval, $rawver, @ver, $date, $path );
	
	
	$url = $hash->{'CheckURL'};
	$interval = $hash->{'Interval'};
	
	$rawver = $hash->{'RawVer'};
	# 0ch+ BBS n.m.r YYYYMMDD `ł邱ƂƊ҂Ă
	# ܂ 0ch+ BBS dev-rREV YYYYMMDD
	if ( $rawver =~ /(\d+(?:\.\d+)+)/ ) {
		@ver = split /\./, $1;
	} elsif ( $rawver =~ /dev-r(\d+)/ ) {
		@ver = ( 'dev', $1 );
	} else {
		@ver = ( 'dev', 0 );
	}
	$date = '00000000';
	if ( $rawver =~ /(\d{8})/ ) {
		$date = $1;
	}
	
	$path = $hash->{'CachePATH'};
	
	
	# LbV̗L߂Ăf[^ƂĂ
	if ( !-f $path || ( stat $path )[9] < time - $interval ) {
		# ڑh~݂
		utime ( undef, undef, $path );
		
		require('./module/httpservice.pl');
		
		my $proxy = HTTPSERVICE->new;
		# URLw
		$proxy->setURI($url);
		# UserAgentݒ
		$proxy->setAgent($rawver);
		# ^CAEgݒ
		$proxy->setTimeout(3);
		
		# ƂĂ
		$proxy->request();
		
		# Ƃꂽ
		if ( $proxy->getStatus() eq 200 ) {
			open ( FILE, "+< $path" );
			flock FILE, 2;
			binmode FILE;
			seek FILE, 0, 0;
			print FILE $proxy->getContent();
			truncate FILE, tell FILE;
			close FILE;
			chmod $hash->{'CachePM'}, $path;
		}
	}
	
	
	# r
	my ( @release, $l, @newver, $newdate, $i, $newrelease, $vv, $nv );
	
	open ( FILE, "< $path" );
	flock FILE, 1;
	seek FILE, 0, 0;
	undef @release;
	while ( $l = <FILE> ) {
		# e(BOM)
		if ( $#release eq -1 ) {
			$l =~ s/^\xef\xbb\xbf//;
		}
		
		# $l =~ s/\x0d?\x0a?$//;
		# samwiseƓ̃Tj^CWOs܂
		$l =~ s/[\x0d\x0a\0]//g;
		$l =~ s/"/&quot;/g;
		$l =~ s/</&lt;/g;
		$l =~ s/>/&gt;/g;
		
		Encode::from_to( $l, 'utf8', 'sjis' );
		push @release, $l;
	}
	close FILE;
	
	# n.m.r`ł邱Ƃ҂Ă
	@newver = split /\./, $release[0];
	# YYYY.MM.DD`ł邱Ƃ҂Ă
	$newdate = join '', (split /\./, $release[2], 3);
	
	$i = 0;
	$newrelease = 0;
	# o[Wr
	# Ƃ肠verdevȂ疳(̓tŊmF)
	if ( $ver[0] ne 'dev' ) {
		foreach $nv ( @newver ) {
			$vv = shift @ver;
			if ( $vv < $nv ) {
				$newrelease = 1;
			} elsif ( $vv > $nv ) {
				# ȂCXg[ς݂̕炵
				last;
			}
		}
	}
	# 悭킩Ȃ炠炽߂ētŊmF
	unless ( $newrelease ) {
		if ( $date < $newdate ) {
			$newrelease = 1;
		}
	}
	
	
	$this->{'NEWRELEASE'}->{'Update'}	= $newrelease;
	$this->{'NEWRELEASE'}->{'Ver'}		= shift @release;
	$this->{'NEWRELEASE'}->{'URL'}		= 'http://sourceforge.jp/projects/zerochplus/releases/' . shift @release;
	$this->{'NEWRELEASE'}->{'Date'}		= shift @release;
	
	shift @release; # 4s(s)
	# c̓[Xm[gƂ̂c
	$this->{'NEWRELEASE'}->{'Detail'}	= \@release;
	
	return 0;

}

#------------------------------------------------------------------------------------------------------------
#
#	ݒl擾 - Get
#	-------------------------------------------------------------------------------------
#	MELKORƂƂȂ悤Ȋ
#
#------------------------------------------------------------------------------------------------------------
sub Get
{
	my $this = shift;
	my ($key, $default) = @_;
	my ($val);
	
	$val = $this->{'NEWRELEASE'}->{$key};
	
	return (defined $val ? $val : (defined $default ? $default : undef));
}

#------------------------------------------------------------------------------------------------------------
#
#	ݒlݒ - Set
#	-------------------------------------------------------------------------------------
#	MELKOR(ry
#
#------------------------------------------------------------------------------------------------------------
sub Set
{
	my $this = shift;
	my ($key, $data) = @_;
	
	$this->{'NEWRELEASE'}->{$key} = $data;
}

1;
