#============================================================================================================
#
#	VXeǗ - Lbv W[
#
#============================================================================================================
package	MODULE;

use strict;
use warnings;

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	W[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	
	my $obj = {
		'LOG'	=> [],
	};
	bless $obj, $class;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	\\bh
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@param	$Form	SAMWISE
#	@param	$CGI	ǗVXe
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub DoPrint
{
	my $this = shift;
	my ($Sys, $Form, $CGI) = @_;
	
	# Ǘ}X^IuWFNg̐
	require './mordor/sauron.pl';
	my $Base = SAURON->new;
	$Base->Create($Sys, $Form);
	
	my $subMode = $Form->Get('MODE_SUB');
	
	# j[̐ݒ
	SetMenuList($Base, $CGI);
	
	my $indata = undef;
	
	# Xbhꗗ
	if ($subMode eq 'LIST') {
		$indata = PreparePageCapList($Sys, $Form);
	}
	# Lbv쐬
	elsif ($subMode eq 'CREATE') {
		$indata = PreparePageCapSetting($Sys, $Form, 0);
	}
	# LbvҏW
	elsif ($subMode eq 'EDIT') {
		$indata = PreparePageCapSetting($Sys, $Form, 1);
	}
	# Lbv폜mF
	elsif ($subMode eq 'DELETE') {
		$indata = PreparePageCapDelete($Sys, $Form);
	}
	# Lbvݒ芮
	elsif ($subMode eq 'COMPLETE') {
		$indata = $Base->PreparePageComplete('Lbv', $this->{'LOG'});
	}
	# Lbvݒ莸s
	elsif ($subMode eq 'FALSE') {
		$indata = $Base->PreparePageError($this->{'LOG'});
	}
	
	$Base->Print($Sys->Get('_TITLE'), 1, $indata);
}

#------------------------------------------------------------------------------------------------------------
#
#	@\\bh
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@param	$Form	SAMWISE
#	@param	$CGI	ǗVXe
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub DoFunction
{
	my $this = shift;
	my ($Sys, $Form, $CGI) = @_;
	
	my $subMode = $Form->Get('MODE_SUB');
	my $err = 0;
	
	# Lbv쐬
	if ($subMode eq 'CREATE') {
		$err = FuncCapSetting($Sys, $Form, 0, $this->{'LOG'});
	}
	# LbvҏW
	elsif ($subMode eq 'EDIT') {
		$err = FuncCapSetting($Sys, $Form, 1, $this->{'LOG'});
	}
	# Lbv폜
	elsif ($subMode eq 'DELETE') {
		$err = FuncCapDelete($Sys, $Form, $this->{'LOG'});
	}
	
	# ʕ\
	if ($err) {
		$CGI->{'LOGGER'}->Put($Form->Get('UserName'),"CAP($subMode)", "ERROR:$err");
		push @{$this->{'LOG'}}, $err;
		$Form->Set('MODE_SUB', 'FALSE');
	}
	else {
		$CGI->{'LOGGER'}->Put($Form->Get('UserName'),"CAP($subMode)", 'COMPLETE');
		$Form->Set('MODE_SUB', 'COMPLETE');
	}
	
	$this->DoPrint($Sys, $Form, $CGI);
}

#------------------------------------------------------------------------------------------------------------
#
#	j[Xgݒ
#	-------------------------------------------------------------------------------------
#	@param	$Base	SAURON
#	@param	$CGI	ǗVXe
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub SetMenuList
{
	my ($Base, $CGI) = @_;
	
	# ʕ\j[
	$Base->SetMenu('Lbvꗗ', "'sys.cap','DISP','LIST'");
	
	# VXeǗ̂
	if ($CGI->{'SECINFO'}->IsAuthority($CGI->{'USER'}, $ZP::AUTH_SYSADMIN, '*')) {
		$Base->SetMenu('Lbvo^', "'sys.cap','DISP','CREATE'");
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	Lbvꗗ̕\
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PreparePageCapList
{
	my ($Sys, $Form) = @_;
	
	my $CGI = $Sys->Get('ADMIN');
	my $Sec = $CGI->{'SECINFO'};
	my $cuser = $CGI->{'USER'};
	
	my $issysad = $Sec->IsAuthority($cuser, $ZP::AUTH_SYSADMIN, '*');
	
	# Lbv̓ǂݍ
	require './module/ungoliants.pl';
	my @capSet;
	my $Cap = UNGOLIANT->new;
	$Cap->Load($Sys);
	$Cap->GetKeySet('ALL', '', \@capSet);
	
	my $max = sub { $_[0] > $_[1] ? $_[0] : $_[1] };
	
	# \̐ݒ
	my $listnum = scalar(@capSet);
	my $dispnum = int($Form->Get('DISPNUM', 10) || 10);
	my $dispst = &$max(int($Form->Get('DISPST') || 0), 0);
	my $prevnum = &$max($dispst - $dispnum, 0);
	my $nextnum = $dispst;
	
	# Lbvꗗo
	my $displist = [];
	while ($nextnum < $listnum) {
		my $id = $capSet[$nextnum++];
		
		push @$displist, {
			'id'		=> $id,
			'name'		=> $Cap->Get('NAME', $id),
			'full'		=> $Cap->Get('FULL', $id),
			'expl'		=> $Cap->Get('EXPL', $id),
			'customid'	=> $Cap->Get('CUSTOMID', $id),
		};
		last if (scalar(@$displist) >= $dispnum);
	}
	
	my $indata = {
		'title'		=> 'Caps List',
		'intmpl'	=> 'sys.cap.caplist',
		'dispnum'	=> $dispnum,
		'prevnum'	=> $prevnum,
		'nextnum'	=> $nextnum,
		'caps'		=> $displist,
		'issysad'	=> $issysad,
	};
	
	return $indata;
}

#------------------------------------------------------------------------------------------------------------
#
#	Lbvݒ̕\
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@param	$mode	쐬̏ꍇ:0, ҏW̏ꍇ:1
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PreparePageCapSetting
{
	my ($Sys, $Form, $mode) = @_;
	
	# Lbv̓ǂݍ
	require './module/ungoliants.pl';
	my $Cap = UNGOLIANT->new;
	$Cap->Load($Sys);
	
	my $cap = {
		'name'		=> '',
		'pass'		=> '',
		'expl'		=> '',
		'full'		=> '',
		'sysad'		=> 0,
		'customid'	=> '',
	};
	
	my $selcap = '';
	
	# ҏW[hȂLbv擾
	if ($mode) {
		$selcap = $Form->Get('SELECT_CAP');
		$cap->{'name'} = $Cap->Get('NAME', $selcap);
		$cap->{'pass'} = $Cap->Get('PASS', $selcap);
		$cap->{'expl'} = $Cap->Get('EXPL', $selcap);
		$cap->{'full'} = $Cap->Get('FULL', $selcap);
		$cap->{'sysad'} = $Cap->Get('SYSAD', $selcap);
		$cap->{'customid'} = $Cap->Get('CUSTOMID', $selcap);
	}
	
	my $indata = {
		'title'		=> 'Cap ' . ($mode ? 'Edit' : 'Create'),
		'intmpl'	=> 'sys.cap.capedit',
		'modesub'	=> $Form->Get('MODE_SUB'),
		'selcap'	=> $selcap,
		'cap'		=> $cap,
	};
	
	return $indata;
}

#------------------------------------------------------------------------------------------------------------
#
#	Lbv폜mFʂ̕\
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PreparePageCapDelete
{
	my ($Sys, $Form) = @_;
	
	# Lbv̓ǂݍ
	require './module/ungoliants.pl';
	my $Cap = UNGOLIANT->new;
	$Cap->Load($Sys);
	
	# ʒmꗗo
	my $caps = [];
	my @capSet = $Form->GetAtArray('CAPS');
	foreach my $id (@capSet) {
		next if (!defined $Cap->Get('NAME', $id));
		push @$caps, {
			'id'	=> $id,
			'name'	=> $Cap->Get('NAME', $id),
			'full'	=> $Cap->Get('FULL', $id),
			'expl'	=> $Cap->Get('EXPL', $id),
		};
	}
	
	my $indata = {
		'title'		=> 'Cap Delete Confirm',
		'intmpl'	=> 'sys.cap.capdelete',
		'caps'		=> $caps,
	};
	
	return $indata;
}

#------------------------------------------------------------------------------------------------------------
#
#	Lbv쐬/ҏW
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@param	$mode	ҏW:1, 쐬:0
#	@param	$pLog	Op
#	@return	G[R[h
#
#------------------------------------------------------------------------------------------------------------
sub FuncCapSetting
{
	my ($Sys, $Form, $mode, $pLog) = @_;
	
	# `FbN
	my $Sec = $Sys->Get('ADMIN')->{'SECINFO'};
	my $cuser = $Sys->Get('ADMIN')->{'USER'};
	return 1000 if (!$Sec->IsAuthority($cuser, $ZP::AUTH_SYSADMIN, '*'));
	
	# ̓`FbN
	return 1001 if (!$Form->IsInput([qw(PASS)]));
	return 1002 if (!$Form->IsCapKey([qw(PASS)]));
	
	# Lbv̓ǂݍ
	require './module/ungoliants.pl';
	my $Cap = UNGOLIANT->new;
	$Cap->Load($Sys);
	
	# ݒ͏擾
	my $name = $Form->Get('NAME');
	my $pass = $Form->Get('PASS');
	my $expl = $Form->Get('EXPL');
	my $full = $Form->Get('FULL');
	my $customid = $Form->Get('CUSTOMID');
	my $sysad = $Form->Equal('SYSAD', 'on') ? 1 : 0;
	my $chg	= 0;
	
	# ҏW[h
	if ($mode) {
		my $id = $Form->Get('SELECT_CAP');
		# pX[hύXĂĐݒ肷
		if ($pass ne $Cap->Get('PASS', $id)){
			$Cap->Set($id, 'PASS', $pass);
			$chg = 1;
		}
		$Cap->Set($id, 'NAME', $name);
		$Cap->Set($id, 'EXPL', $expl);
		$Cap->Set($id, 'FULL', $full);
		$Cap->Set($id, 'SYSAD', $sysad);
		$Cap->Set($id, 'CUSTOMID', $customid);
	}
	# o^[h
	else {
		$Cap->Add($name, $pass, $full, $expl, $sysad, $customid);
		$chg = 1;
	}
	
	# ݒۑ
	$Cap->Save($Sys);
	
	# O̐ݒ
	push @$pLog, " Lbv [ $name ] " . ($mode ? 'ݒ' : '쐬');
	push @$pLog, '@@@@pX[hF' . ($chg ? '********' : 'ύXȂ');
	push @$pLog, "@@@@tl[F$full";
	push @$pLog, "@@@@F$expl";
	push @$pLog, "@@@@pIDF$customid";
	push @$pLog, '@@@@VXeǗF' . ($sysad ? 'L' : '');
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	Lbv폜
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@param	$pLog	Op
#	@return	G[R[h
#
#------------------------------------------------------------------------------------------------------------
sub FuncCapDelete
{
	my ($Sys, $Form, $pLog) = @_;
	
	# `FbN
	my $Sec = $Sys->Get('ADMIN')->{'SECINFO'};
	my $cuser = $Sys->Get('ADMIN')->{'USER'};
	return 1000 if (!$Sec->IsAuthority($cuser, $ZP::AUTH_SYSADMIN, '*'));
	
	# Lbv̓ǂݍ
	require './module/ungoliants.pl';
	my $Cap = UNGOLIANT->new;
	$Cap->Load($Sys);
	
	# ILbvS폜
	my @capSet = $Form->GetAtArray('CAPS');
	foreach my $id (@capSet) {
		my $name = $Cap->Get('NAME', $id);
		next if (!defined $name);
		
		my $pass = $Cap->Get('PASS', $id);
		push @$pLog, " Lbv [ $name ] 폜܂B";
		$Cap->Delete($id);
	}
	
	# ݒۑ
	$Cap->Save($Sys);
	
	return 0;
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
