#============================================================================================================
#
#	LbvǗW[
#	-------------------------------------------------------------------------------------
#	̃W[̓LbvǗ܂B
#	ȉ3̃pbP[Wɂč\܂
#
#	UNGOLIANT	: LbvǗ
#	SHELOB		: LbvO[vǗ
#	SECURITY	: ZLeBC^tFCX
#
#============================================================================================================

#============================================================================================================
#
#	LbvǗpbP[W
#
#============================================================================================================
package	UNGOLIANT;

use strict;
use warnings;

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	W[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	
	my $obj = {
		'NAME'		=> undef,
		'PASS'		=> undef,
		'FULL'		=> undef,
		'EXPL'		=> undef,
		'SYSAD'		=> undef,
		'CUSTOMID'	=> undef,
	};
	bless $obj, $class;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	Lbvǂݍ
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Load
{
	my $this = shift;
	my ($Sys) = @_;
	
	# nbV
	$this->{'NAME'} = {};
	$this->{'PASS'} = {};
	$this->{'FULL'} = {};
	$this->{'EXPL'} = {};
	$this->{'SYSAD'} = {};
	$this->{'CUSTOMID'} = {};
	
	my $path = '.' . $Sys->Get('INFO') . '/caps.cgi';
	
	if (open(my $fh, '<', $path)) {
		flock($fh, 2);
		my @lines = <$fh>;
		close($fh);
		map { s/[\r\n]+\z// } @lines;
		
		foreach (@lines) {
			next if ($_ eq '');
			
			my @elem = split(/<>/, $_, -1);
			if (scalar(@elem) < 6) { # 7
				warn "invalid line in $path";
				next;
			}
			push @elem, '';
			
			my $id = $elem[0];
			$this->{'NAME'}->{$id} = $elem[1];
			$this->{'PASS'}->{$id} = $elem[2];
			$this->{'FULL'}->{$id} = $elem[3];
			$this->{'EXPL'}->{$id} = $elem[4];
			$this->{'SYSAD'}->{$id} = $elem[5];
			$this->{'CUSTOMID'}->{$id} = $elem[6];
		}
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	Lbvۑ
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Save
{
	my $this = shift;
	my ($Sys) = @_;
	
	my $path = '.' . $Sys->Get('INFO') . '/caps.cgi';
	
	chmod($Sys->Get('PM-ADM'), $path);
	if (open(my $fh, (-f $path ? '+<' : '>'), $path)) {
		flock($fh, 2);
		seek($fh, 0, 0);
		binmode($fh);
		
		foreach (keys %{$this->{'NAME'}}) {
			my $data = join('<>',
				$_,
				$this->{'NAME'}->{$_},
				$this->{'PASS'}->{$_},
				$this->{'FULL'}->{$_},
				$this->{'EXPL'}->{$_},
				$this->{'SYSAD'}->{$_},
				$this->{'CUSTOMID'}->{$_},
			);
			
			print $fh "$data\n";
		}
		
		truncate($fh, tell($fh));
		close($fh);
	}
	chmod($Sys->Get('PM-ADM'), $path);
}

#------------------------------------------------------------------------------------------------------------
#
#	LbvIDZbg擾
#	-------------------------------------------------------------------------------------
#	@param	$kind	
#	@param	$name	[h
#	@param	$pBuf	IDZbgi[obt@
#	@return	L[Zbg
#
#------------------------------------------------------------------------------------------------------------
sub GetKeySet
{
	my $this = shift;
	my ($kind, $name, $pBuf) = @_;
	
	my $n = 0;
	
	if ($kind eq 'ALL') {
		$n += push @$pBuf, keys %{$this->{'NAME'}};
	}
	else {
		foreach my $key (keys %{$this->{$kind}}) {
			if ($this->{$kind}->{$key} eq $name || $kind eq 'ALL') {
				$n += push @$pBuf, $key;
			}
		}
	}
	
	return $n;
}

#------------------------------------------------------------------------------------------------------------
#
#	Lbv擾
#	-------------------------------------------------------------------------------------
#	@param	$kind		
#	@param	$key		LbvID
#	@param	$default	ftHg
#	@return	Lbv
#
#------------------------------------------------------------------------------------------------------------
sub Get
{
	my $this = shift;
	my ($kind, $key, $default) = @_;
	
	my $val = $this->{$kind}->{$key};
	
	return (defined $val ? $val : (defined $default ? $default : undef));
}

#------------------------------------------------------------------------------------------------------------
#
#	Lbvǉ
#	-------------------------------------------------------------------------------------
#	@param	$name	
#	@param	$pass	LbvID
#	@param	$full	tl[
#	@param	$explan	
#	@param	$sysad	Ǘ҃tO
#	@return	LbvID
#
#------------------------------------------------------------------------------------------------------------
sub Add
{
	my $this = shift;
	my ($name, $pass, $full, $explan, $sysad, $customid) = @_;
	
	my $id = time;
	$this->{'NAME'}->{$id} = $name;
	$this->{'PASS'}->{$id} = $this->GetStrictPass($pass, $id);
	$this->{'EXPL'}->{$id} = $explan;
	$this->{'FULL'}->{$id} = $full;
	$this->{'SYSAD'}->{$id} = $sysad;
	$this->{'CUSTOMID'}->{$id} = $customid;
	
	return $id;
}

#------------------------------------------------------------------------------------------------------------
#
#	Lbvݒ
#	-------------------------------------------------------------------------------------
#	@param	$id		LbvID
#	@param	$kind	
#	@param	$val	ݒl
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Set
{
	my $this = shift;
	my ($id, $kind, $val) = @_;
	
	if (exists $this->{$kind}->{$id}) {
		if ($kind eq 'PASS') {
			$val = $this->GetStrictPass($val, $id);
		}
		$this->{$kind}->{$id} = $val;
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	Lbv폜
#	-------------------------------------------------------------------------------------
#	@param	$id		폜LbvID
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Delete
{
	my $this = shift;
	my ($id) = @_;
	
	delete $this->{'NAME'}->{$id};
	delete $this->{'PASS'}->{$id};
	delete $this->{'FULL'}->{$id};
	delete $this->{'EXPL'}->{$id};
	delete $this->{'SYSAD'}->{$id};
	delete $this->{'CUSTOMID'}->{$id};
}

#------------------------------------------------------------------------------------------------------------
#
#	ÍpX擾
#	-------------------------------------------------------------------------------------
#	@param	$pass	pX[h
#	@param	$key	pX[hϊL[
#	@return	ÍꂽpXR[h
#
#------------------------------------------------------------------------------------------------------------
sub GetStrictPass
{
	my $this = shift;
	my ($pass, $key) = @_;
	
	my $hash;
	if (length($pass) >= 9) {
		require Digest::SHA::PurePerl;
		Digest::SHA::PurePerl->import( qw(sha1_base64) );
		$hash = substr(crypt($key, 'ZC'), -2);
		$hash = substr(sha1_base64("ZeroChPlus_${hash}_$pass"), 0, 10);
	}
	else {
		$hash = substr(crypt($pass, substr(crypt($key, 'ZC'), -2)), -10);
	}
	
	return $hash;
}


#============================================================================================================
#
#	O[vǗpbP[W
#
#============================================================================================================
package	SHELOB;

use strict;
use warnings;

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	W[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	
	my $obj = {
		'NAME'		=> undef,
		'EXPL'		=> undef,
		'COLOR'		=> undef,
		'AUTH'		=> undef,
		'CAPS'		=> undef,
		'ISCOMMON'	=> undef,
	};
	bless $obj, $class;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	O[vǂݍ
#	-------------------------------------------------------------------------------------
#	@param	$Sys		MELKOR
#	@param	$sysgroup	ʃO[vǂ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Load
{
	my $this = shift;
	my ($Sys, $sysgroup) = @_;
	
	# nbV
	$this->{'NAME'} = {};
	$this->{'EXPL'} = {};
	$this->{'COLOR'} = {};
	$this->{'AUTH'} = {};
	$this->{'CAPS'} = {};
	$this->{'ISCOMMON'} = {};
	
	my $path = '.' . $Sys->Get('INFO') . '/capgroups.cgi';
	if (open(my $fh, '<', $path)) {
		flock($fh, 2);
		my @lines = <$fh>;
		close($fh);
		map { s/[\r\n]+\z// } @lines;
		
		foreach (@lines) {
			next if ($_ eq '');
			
			my @elem = split(/<>/, $_, -1);
			if (scalar(@elem) < 6) {
				warn "invalid line in $path";
				#next;
			}
			
			my $id = $elem[0];
			$elem[4] = '' if (!defined $elem[4]);
			$elem[5] = '' if (!defined $elem[5]);
			$this->{'NAME'}->{$id} = $elem[1];
			$this->{'EXPL'}->{$id} = $elem[2];
			$this->{'AUTH'}->{$id} = $elem[3];
			$this->{'CAPS'}->{$id} = $elem[4];
			$this->{'COLOR'}->{$id} = $elem[5];
			$this->{'ISCOMMON'}->{$id} = 1;
		}
	}
	
	if (!$sysgroup) {
		$path = $Sys->Get('BBSPATH') . '/' .  $Sys->Get('BBS') . '/info/capgroups.cgi';
		if (open(my $fh, '<', $path)) {
			flock($fh, 2);
			my @lines = <$fh>;
			close($fh);
			map { s/[\r\n]+\z// } @lines;
			
			foreach (@lines) {
				next if ($_ eq '');
				
				my @elem = split(/<>/, $_, -1);
				if (scalar(@elem) < 6) {
					warn "invalid line in $path";
					#next;
				}
				
				my $id = $elem[0];
				$elem[4] = '' if (!defined $elem[4]);
				$elem[5] = '' if (!defined $elem[5]);
				$this->{'NAME'}->{$id} = $elem[1];
				$this->{'EXPL'}->{$id} = $elem[2];
				$this->{'AUTH'}->{$id} = $elem[3];
				$this->{'CAPS'}->{$id} = $elem[4];
				$this->{'COLOR'}->{$id} = $elem[5];
				$this->{'ISCOMMON'}->{$id} = 0;
			}
		}
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	O[vۑ
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@param	$sysgroup	ʃO[vǂ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Save
{
	my $this = shift;
	my ($Sys, $sysgroup) = @_;
	
	my $commflg = ($sysgroup ? 1 : 0);
	
	my $path;
	if ($commflg) {
		$path = '.' . $Sys->Get('INFO') . '/capgroups.cgi';
	}
	else {
		$path = $Sys->Get('BBSPATH') . '/' .  $Sys->Get('BBS') . '/info/capgroups.cgi';
	}
	
	
	chmod($Sys->Get('PM-ADM'), $path);
	if (open(my $fh, (-f $path ? '+<' : '>'), $path)) {
		flock($fh, 2);
		seek($fh, 0, 0);
		binmode($fh);
		
		foreach (keys %{$this->{'NAME'}}) {
			next if ($this->{'ISCOMMON'}->{$_} ne $commflg);
			
			my $data = join('<>',
				$_,
				$this->{'NAME'}->{$_},
				$this->{'EXPL'}->{$_},
				$this->{'AUTH'}->{$_},
				$this->{'CAPS'}->{$_},
				$this->{'COLOR'}->{$_},
			);
			
			print $fh "$data\n";
		}
		
		truncate($fh, tell($fh));
		close($fh);
	}
	chmod($Sys->Get('PM-ADM'), $path);
}

#------------------------------------------------------------------------------------------------------------
#
#	O[vIDZbg擾
#	-------------------------------------------------------------------------------------
#	@param	$pBuf		IDZbgi[obt@
#	@param	$sysgroup	ʃO[vǂ
#	@return	O[vID
#
#------------------------------------------------------------------------------------------------------------
sub GetKeySet
{
	my $this = shift;
	my ($pBuf, $sysgroup) = @_;
	
	my $n = 0;
	my $commflg = ($sysgroup ? 1 : 0);
	
	foreach (keys %{$this->{'NAME'}}) {
		next if ($this->{'ISCOMMON'}->{$_} ne $commflg);
		$n += push @$pBuf, $_;
	}
	return $n;
}

#------------------------------------------------------------------------------------------------------------
#
#	O[v擾
#	-------------------------------------------------------------------------------------
#	@param	$kind		
#	@param	$key		O[vID
#	@param	$default	ftHg
#	@return	O[v
#
#------------------------------------------------------------------------------------------------------------
sub Get
{
	my $this = shift;
	my ($kind, $key, $default) = @_;
	
	my $val = $this->{$kind}->{$key};
	
	return (defined $val ? $val : (defined $default ? $default : undef));
}

#------------------------------------------------------------------------------------------------------------
#
#	O[vǉ
#	-------------------------------------------------------------------------------------
#	@param	$name		
#	@param	$explan		
#	@param	$authors	Zbg
#	@param	$caps		LbvZbg
#	@return	O[vID
#
#------------------------------------------------------------------------------------------------------------
sub Add
{
	my $this = shift;
	my ($name, $explan, $color, $authors, $caps, $sysgroup) = @_;
	
	my $id = time;
	$this->{'NAME'}->{$id}	= $name;
	$this->{'EXPL'}->{$id}	= $explan;
	$this->{'COLOR'}->{$id}	= $color;
	$this->{'AUTH'}->{$id}	= $authors;
	$this->{'CAPS'}->{$id}	= $caps;
	$this->{'ISCOMMON'}->{$id}	= ($sysgroup ? 1 : 0);
	
	return $id;
}

#------------------------------------------------------------------------------------------------------------
#
#	O[vLbvǉ
#	-------------------------------------------------------------------------------------
#	@param	$id		O[vID
#	@param	$user	ǉLbvID
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub AddCap
{
	my $this = shift;
	my ($id, $cap) = @_;
	
	my @users = split(/\,/, $this->{'CAPS'}->{$id});
	my @match = grep($cap, @users);
	my $nuser = scalar(@match);
	
	# o^ς݂̃Lbv͏do^Ȃ
	if ($nuser == 0) {
		$this->{'CAPS'}->{$id} .= ",$cap";
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	O[vݒ
#	-------------------------------------------------------------------------------------
#	@param	$id		O[vID
#	@param	$kind	
#	@param	$val	ݒl
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Set
{
	my $this = shift;
	my ($id, $kind, $val) = @_;
	
	if (exists $this->{$kind}->{$id}) {
		$this->{$kind}->{$id} = $val;
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	O[v폜
#	-------------------------------------------------------------------------------------
#	@param	$id		폜O[vID
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Delete
{
	my $this = shift;
	my ($id) = @_;
	
	delete $this->{'NAME'}->{$id};
	delete $this->{'EXPL'}->{$id};
	delete $this->{'COLOR'}->{$id};
	delete $this->{'AUTH'}->{$id};
	delete $this->{'CAPS'}->{$id};
	delete $this->{'ISCOMMON'}->{$id};
}

#------------------------------------------------------------------------------------------------------------
#
#	LbvO[v擾
#	-------------------------------------------------------------------------------------
#	@param	$id		LbvID
#	@return	LbvĂO[vID
#
#------------------------------------------------------------------------------------------------------------
sub GetBelong
{
	my $this = shift;
	my ($id) = @_;
	
	my $ret = '';
	
	foreach my $group (keys %{$this->{'CAPS'}}) {
		my @users = split(/\,/, $this->{'CAPS'}->{$group});
		foreach my $user (@users) {
			if ($id eq $user) {
				$ret = $group;
				# ʃO[vD
				if ($this->{'ISCOMMON'}->{$group}) {
					return $ret;
				}
			}
		}
	}
	return $ret;
}


#============================================================================================================
#
#	ZLeBǗpbP[W
#
#============================================================================================================
package SECURITY;

use strict;
use warnings;

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	W[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	
	my $obj = {
		'SYS'	=> undef,
		'CAP'	=> undef,
		'GROUP'	=> undef,
	};
	bless $obj, $class;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Init
{
	my $this = shift;
	my ($Sys) = @_;
	
	$this->{'SYS'} = $Sys;
	
	# 2d[hh~
	if (! defined $this->{'CAP'}) {
		$this->{'CAP'} = UNGOLIANT->new;
		$this->{'GROUP'} = SHELOB->new;
		$this->{'CAP'}->Load($Sys);
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	擾
#	-------------------------------------------------------------------------------------
#	@param	$id			Lbv/O[vID
#	@param	$key		擾L[
#	@param	$f			擾
#	@param	$default	ftHg
#	@return	ȃLbvȂ1Ԃ
#
#------------------------------------------------------------------------------------------------------------
sub Get
{
	my $this = shift;
	my ($id, $key, $f, $default) = @_;
	
	if ($f) {
		return $this->{'CAP'}->Get($key, $id, $default);
	}
	else {
		return $this->{'GROUP'}->Get($key, $id, $default);
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	LbvID擾
#	-------------------------------------------------------------------------------------
#	@param	$pass	pX[h
#	@return	pX[hɑΉLbvID
#
#------------------------------------------------------------------------------------------------------------
sub GetCapID
{
	my $this = shift;
	my ($pass) = @_;
	
	my $Cap = $this->{'CAP'};
	
	my @capSet = ();
	$Cap->GetKeySet('ALL', '', \@capSet);
	foreach my $id (@capSet) {
		my $capPass = $Cap->GetStrictPass($pass, $id);
		if ($capPass eq $Cap->Get('PASS', $id)) {
			return $id;
		}
	}
	return '';
}

#------------------------------------------------------------------------------------------------------------
#
#	OO[v񏀔
#	-------------------------------------------------------------------------------------
#	@param	$bbs	K
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub SetGroupInfo
{
	my $this = shift;
	my ($bbs) = @_;
	
	my $oldBBS = $this->{'SYS'}->Get('BBS');
	
	$this->{'SYS'}->Set('BBS', $bbs);
	$this->{'GROUP'}->Load($this->{'SYS'});
	$this->{'SYS'}->Set('BBS', $oldBBS);
}

#------------------------------------------------------------------------------------------------------------
#
#	
#	-------------------------------------------------------------------------------------
#	@param	$id		LbvID
#	@param	$author	
#	@param	$bbs	K
#	@return	LbvĂ1Ԃ
#
#------------------------------------------------------------------------------------------------------------
sub IsAuthority
{
	my $this = shift;
	my ($id, $author, $bbs) = @_;
	
	# VXeǗO[vȂ疳OK
	my $sysad = $this->{'CAP'}->Get('SYSAD', $id);
	return 1 if ($sysad);
	
	return 0 if ($bbs eq '*');
	
	# ΏBBSɏĂ邩mF
	my $group = $this->{'GROUP'}->GetBelong($id);
	return 0 if ($group eq '');
	
	# Ă邩mF
	my $authors = $this->{'GROUP'}->Get('AUTH', $group);
	my @authors = split(/\,/, $authors);
	foreach my $auth (@authors) {
		return 1 if ($auth == $author);
	}
	return 0;
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
