#============================================================================================================
#
#	httpT[rXW[
#
#============================================================================================================
package HTTPSERVICE;

use strict;
use warnings;

use Socket;

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	httpT[rXIuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	
	my $obj = {
		'METHOD'		=> 'GET',
		'URI'			=> undef,
		'PARAMETER'		=> undef,
		'CONTENT_TYPE'	=> 'application/x-www-form-urlencoded',
		'REFERER'		=> undef,
		'AGENT'			=> 'Mozilla/5.0 Zero-Channel BBS Plus Project',
		'CONNECTION'	=> 'close',
		'LANGUAGE'		=> 'ja,en-us;q=0.7,en;q=0.3',
		'PROXY_HOST'	=> undef,
		'PROXY_PORT'	=> undef,
		'TIMEOUT'		=> 3,
		
		'CODE'			=> 500,
		'HEADER'		=> undef,
		'CONTENT'		=> undef
	};
	bless $obj, $class;
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	httpvM
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	G[R[h
#			1:I
#			-1:URIG[
#			-2:socketG[
#
#------------------------------------------------------------------------------------------------------------
sub request
{
	my $this = shift;
	
	# URI𕪉
	my $uri = $this->{'URI'};
	my ($host, $port, $target) = decompositionURI($uri);
	
	return -1 if (!defined $host);
	
	# vLVgp
	if (defined $this->{'PROXY_HOST'}) {
		$host = $this->{'PROXY_HOST'};
		$port = $this->{'PROXY_PORT'} || 80;
		$target = $uri;
	}
	
	# NGXgNG̍쐬
	my $request = createRequestString($this, $host, $target);
	
	eval
	{
		local $SIG{'ALRM'} = sub { die "connect time out. $!" };
		
		alarm($this->{'TIMEOUT'});
		
		# \Pbg̍쐬
		my $sockaddr = pack_sockaddr_in($port, inet_aton($host));
		socket(SOCKET, PF_INET, SOCK_STREAM, 0);
		select(SOCKET);
		$| = 1;
		select(STDOUT);
		connect(SOCKET, $sockaddr);
		binmode(SOCKET);
		#autoflush SOCKET (1);
		
		# NGXgM
		print SOCKET $request;
		$this->{'REQUEST'} = $request;
		
		my $chunkedflag = 0;
		my $code = -1;
		my $header = '';
		my $content = '';
		
		while (<SOCKET>) {
			$_ =~ s/[\r\n]+\z//;
			
			last if ($_ eq '');
			
			# HTTPXe[^X
			if ($_ =~ m|^HTTP/\d.\d\s+(\d+)|) {
				$code = $1;
			}
			
			# X|Xwb_[̎擾
			$header .= "$_\n";
		}
		
		# Chunked Transfer Coding
		# http://tools.ietf.org/html/rfc2616#section-14.41
		if ($header =~ m|Transfer\-Encoding:\s*chunked|i) {
			$chunkedflag = 1;
		}
		
		# {̎擾
		if ($chunkedflag) {
			# http://tools.ietf.org/html/rfc2616#section-3.6.1
			while (<SOCKET>) {
				$_ = /^([0-9A-F]+)/i;
				my $size = hex $1;
				
				last if ($size eq 0);
				
				read(SOCKET, $_, $size);
				$content .= $_;
				
				<SOCKET>;
			}
			
			# http://tools.ietf.org/html/rfc2616#section-7.1
			while ( <SOCKET> ) {
				$_ =~ s/[\r\n]+\z//;
				
				last if ( $_ eq '' );
				
				# X|Xwb_[̎擾
				$header .= "$_\n";
				
			}
		}
		else {
			while (read(SOCKET, $_, 1024)) {
				$content .= $_;
			}
		}
		
		close(SOCKET);
		
		$this->{'CODE'} = $code;
		$this->{'HEADER'} = $header;
		$this->{'CONTENT'} = $content;
		
		alarm(0);
	};
	
	if ($@) {
		$this->{'CODE'} = -1;
		$this->{'CONTENT'} = $@;
		return -2;
	}
	
	return 1;
}

#------------------------------------------------------------------------------------------------------------
#
#	URI
#	-------------------------------------------------------------------------------------
#	@param	$uri	URI
#	@return	$host	zXg
#			$port	|[gԍ
#
#------------------------------------------------------------------------------------------------------------
sub decompositionURI
{
	
	my ($uri) = @_;
	
	$uri =~ m!(?:(?:http:)?//)?((?:[^:/]*)?)(?::(\d*))?(/.*)!;
	my $host = $1;
	my $port = $2 || 80;
	my $path = $3;
	
	return ($host, $port, $path);
}

#------------------------------------------------------------------------------------------------------------
#
#	httpv̐
#	-------------------------------------------------------------------------------------
#	@param	$host	httpvAhX
#			$target	httpvURI
#	@return	httpvwb_
#
#------------------------------------------------------------------------------------------------------------
sub createRequestString
{
	my $this = shift;
	my ($host, $target) = @_;
	
	# http{fB(p[^)̍쐬
	my $params = '';
	my $len = 0;
	foreach my $key (keys %{$this->{'PARAMETER'}}) {
		my $value = encode($this->{'PARAMETER'}->{$key});
		$params .= "&$key=$value";
	}
	if ($params ne '') {
		$params = substr($params, 1);
		$len = length $params;
	}
	
	my $request = '';
	$request .= "$this->{'METHOD'} $target HTTP/1.1\r\n";
	$request .= "Host: $host\r\n";
	$request .= "User-Agent: $this->{'AGENT'}\r\n";
	$request .= "Accept-Language: $this->{'LANGUAGE'}\r\n";
	$request .= "Content-Type: $this->{'CONTENT_TYPE'}\r\n";
	$request .= "Keep-Alive: 115\r\n";
	$request .= "Referer: $this->{'REFERER'}\r\n" if ($this->{'REFERER'});
	$request .= "Connection: $this->{'CONNECTION'}\r\n";
	$request .= "Content-Length: $len\r\n" if ($this->{'METHOD'} eq 'POST');
	
	$request .= "\r\n";
	
	$request .= $params if ($this->{'METHOD'} eq 'POST');
	
	return $request;
}

#------------------------------------------------------------------------------------------------------------
#
#	URLGR[h
#	-------------------------------------------------------------------------------------
#	@param	$text	GR[h
#	@return	URLGR[h
#
#------------------------------------------------------------------------------------------------------------
sub encode
{
	
	my ($str) = @_;
	$str =~ s/([^\w ])/'%'.unpack('H2', $1)/eg;
	$str =~ tr/ /+/;
	return $str;
}

#------------------------------------------------------------------------------------------------------------
#
#	httpwb_[擾
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	httpwb_[
#
#------------------------------------------------------------------------------------------------------------
sub getHeader
{
	my $this = shift;
	return $this->{'HEADER'};
}

#------------------------------------------------------------------------------------------------------------
#
#	httpHTTPXe[^X擾
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	httpXe[^X
#
#------------------------------------------------------------------------------------------------------------
sub getStatus
{
	my $this = shift;
	return $this->{'CODE'};
}

#------------------------------------------------------------------------------------------------------------
#
#	httpRec擾
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	http擾Rec httpvsocketG[Nꍇ̓G[bZ[W
#
#------------------------------------------------------------------------------------------------------------
sub getContent
{
	my $this = shift;
	return $this->{'CONTENT'};
}

#------------------------------------------------------------------------------------------------------------
#
#	httpvuriݒ
#	-------------------------------------------------------------------------------------
#	@param	$uri	URI
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setURI
{
	my $this = shift;
	my ($uri) = @_;
	$this->{'URI'} = $uri;
}

#------------------------------------------------------------------------------------------------------------
#
#	httpv|[gݒ
#	-------------------------------------------------------------------------------------
#	@param	$port	|[gԍ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setPort
{
	my $this = shift;
	my ($port) = @_;
	$this->{'PORT'} = $port;
}

#------------------------------------------------------------------------------------------------------------
#
#	httpv\bhݒ
#	-------------------------------------------------------------------------------------
#	@param	$method	\bh
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setMethod
{
	my $this = shift;
	my ($method) = @_;
	$this->{'METHOD'} = $method;
}


#------------------------------------------------------------------------------------------------------------
#
#	UserAgentݒ
#	-------------------------------------------------------------------------------------
#	@param	$agent	UserAgent
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setAgent
{
	my $this = shift;
	my ($agent) = @_;
	$this->{'AGENT'} = $agent;
}

#------------------------------------------------------------------------------------------------------------
#
#	^CAEgݒ
#	-------------------------------------------------------------------------------------
#	@param	$time	^CAEg(b)
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setTimeout
{
	my $this = shift;
	my ($time) = @_;
	$this->{'TUMEOUT'} = $time;
}

#------------------------------------------------------------------------------------------------------------
#
#	Reg^Cvݒ
#	-------------------------------------------------------------------------------------
#	@param	$type	Reg^Cv
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setContentType
{
	my $this = shift;
	my ($type) = @_;
	$this->{'CONTENT_TYPE'} = $type;
}

#------------------------------------------------------------------------------------------------------------
#
#	RlNVݒ
#	-------------------------------------------------------------------------------------
#	@param	$conn	RlNV
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setConnection
{
	my $this = shift;
	my ($conn) = @_;
	$this->{'CONNECTION'} = $conn;
}

#------------------------------------------------------------------------------------------------------------
#
#	t@ݒ
#	-------------------------------------------------------------------------------------
#	@param	$ref	t@
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setReferer
{
	my $this = shift;
	my ($ref) = @_;
	$this->{'REFERER'} = $ref;
}

#------------------------------------------------------------------------------------------------------------
#
#	vLVݒ
#	-------------------------------------------------------------------------------------
#	@param	$proxy	vLV ( [host]:[port]` )
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setProxy
{
	my $this = shift;
	my ($proxy) = @_;
	my ($host, $port) = split(/:/, $proxy);
	$this->{'PROXY_HOST'} = $host;
	$this->{'PROXY_PORT'} = $port;
}

#------------------------------------------------------------------------------------------------------------
#
#	ݒ
#	-------------------------------------------------------------------------------------
#	@param	$lang	
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setLanguage
{
	my $this = shift;
	my ($lang) = @_;
	$this->{'LANGUAGE'} = $lang;
}

#------------------------------------------------------------------------------------------------------------
#
#	httpvp[^ݒ
#	-------------------------------------------------------------------------------------
#	@param	$key	p[^L[
#	@param	$value	p[^l
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setParameter
{
	my $this = shift;
	my ($key, $value) = @_;
	$this->{'PARAMETER'}->{$key} = $value;
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
