#============================================================================================================
#
#	NG[hǗW[
#
#============================================================================================================
package	WORMTONGUE;

use strict;
#use warnings;

#------------------------------------------------------------------------------------------------------------
#
#	W[RXgN^ - new
#	-------------------------------------------
#	@FȂ
#	߂lFW[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	
	my $obj = {
		'METHOD'	=> undef,
		'SUBSTITUTE'=> undef,
		'NGWORD'	=> undef,
		'REPLACE'	=> undef,
	};
	
	bless $obj, $class;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	NG[hǂݍ - Load
#	-------------------------------------------
#	@F$Sys : MELKOR
#	߂lFȂ
#
#------------------------------------------------------------------------------------------------------------
sub Load
{
	my $this = shift;
	my ($Sys) = @_;
	
	$this->{'NGWORD'} = [];
	$this->{'REPLACE'} = [];
	my $path = $Sys->Get('BBSPATH') . '/' . $Sys->Get('BBS') . '/info/ngwords.cgi';
	
	if (open(my $fh, '<', $path)) {
		flock($fh, 2);
		my @datas = <$fh>;
		close($fh);
		map { s/[\r\n]+\z// } @datas;
		
		my @head = split(/<>/, shift @datas);
		$this->{'METHOD'} = $head[0];
		$this->{'SUBSTITUTE'} = $head[1];
		
		foreach (@datas) {
			my ($word, $repl) = split(/<>/, $_, -1);
			next if (!defined $word || $word eq '');
			push @{$this->{'NGWORD'}}, $word;
			if (defined $repl) {
				$this->{'REPLACE'}->[$#{$this->{'NGWORD'}}] = $repl;
			}
		}
		return 0;
	}
	return 1;
}

#------------------------------------------------------------------------------------------------------------
#
#	NG[h - Save
#	-------------------------------------------
#	@F$Sys : MELKOR
#	߂lF0
#
#------------------------------------------------------------------------------------------------------------
sub Save
{
	my $this = shift;
	my ($Sys) = @_;
	
	my $path = $Sys->Get('BBSPATH') . '/' . $Sys->Get('BBS') . "/info/ngwords.cgi";
	
	if (open(my $fh, (-f $path ? '+<' : '>'), $path)) {
		flock($fh, 2);
		seek($fh, 0, 0);
		binmode($fh);
		
		print $fh "$this->{'METHOD'}<>$this->{'SUBSTITUTE'}\n";
		foreach my $i (0 .. $#{$this->{'NGWORD'}}) {
			print $fh $this->{'NGWORD'}->[$i];
			print $fh '<>'.$this->{'REPLACE'}->[$i] if (defined $this->{'REPLACE'}->[$i]);
			print $fh "\n";
		}
		
		truncate($fh, tell($fh));
		close($fh);
	}
	chmod($Sys->Get('PM-ADM'), $path);
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	NG[hǉ - Set
#	-------------------------------------------
#	@F$key : NG[h
#	߂lFȂ
#
#------------------------------------------------------------------------------------------------------------
sub Add
{
	my $this = shift;
	my ($word, $repl) = @_;
	
	return if (!defined $word || $word eq '');
	$word =~ s/</&lt;/g;
	$word =~ s/>/&gt;/g;
	push @{$this->{'NGWORD'}}, $word;
	if (defined $repl) {
		$repl =~ s/</&lt;/g;
		$repl =~ s/>/&gt;/g;
		$this->{'REPLACE'}->[$#{$this->{'NGWORD'}}] = $repl;
	}
	return 1;
}

#------------------------------------------------------------------------------------------------------------
#
#	NG[hf[^擾 - Get
#	-------------------------------------------
#	@F$key : 擾L[
#			$default : ftHg
#	߂lFf[^
#
#------------------------------------------------------------------------------------------------------------
sub Get
{
	my $this = shift;
	my ($key, $default) = @_;
	
	my $val = $this->{$key};
	
	return (defined $val ? $val : (defined $default ? $default : undef));
}

#------------------------------------------------------------------------------------------------------------
#
#	NG[hf[^ݒ - SetData
#	-------------------------------------------
#	@F$key  : ݒL[
#			$data : ݒf[^
#	߂lFȂ
#
#------------------------------------------------------------------------------------------------------------
sub Set
{
	my $this = shift;
	my ($key, $data) = @_;
	
	$this->{$key} = $data;
}

#------------------------------------------------------------------------------------------------------------
#
#	NG[hNA - Clear
#	-------------------------------------------
#	@FȂ
#	߂lFȂ
#
#------------------------------------------------------------------------------------------------------------
sub Clear
{
	my $this = shift;
	
	$this->{'NGWORD'} = [];
	$this->{'REPLACE'} = [];
}

#------------------------------------------------------------------------------------------------------------
#
#	NG[h - Check
#	-------------------------------------------
#	@F$Form  : SAMWISE
#			$pList : `FbNXg(t@X)
#	߂lFmԍ
#
#------------------------------------------------------------------------------------------------------------
sub Check
{
	my $this = shift;
	my ($Form, $pList) = @_;
	
	foreach my $word (@{$this->{'NGWORD'}}) {
		next if ($word eq '');
		foreach my $key (@$pList) {
			my $work = $Form->Get($key);
			if ($work =~ /\Q$word\E/) {
				if ($this->{'METHOD'} eq 'host') {
					return 2;
				}
				elsif ($this->{'METHOD'} eq 'disable') {
					return 3;
				}
				else {
					return 1;
				}
			}
		}
	}
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	NG[h - Method
#	-------------------------------------------
#	@F$Form  : SAMWISE
#			$pList : `FbNXg(t@X)
#	߂lFȂ
#
#------------------------------------------------------------------------------------------------------------
sub Method
{
	my $this = shift;
	my ($Form, $pList) = @_;
	
	# ʂւ폜̏ꍇ̂ݏ
	return unless ($this->{'METHOD'} eq 'delete' || $this->{'METHOD'} eq 'substitute');
	
	# ֗pݒ
	my $substitute = '';
	if ($this->{'METHOD'} eq 'delete') {
		#$substitute = '<b><font color=red>폜</font></b>';
		$substitute = '';
	}
	else {
		$substitute = $this->{'SUBSTITUTE'};
		$substitute = '' if (!defined $substitute);
	}
	
	foreach my $i (0 .. $#{$this->{'NGWORD'}}) {
		my $word = $this->{'NGWORD'}->[$i];
		next if ($word eq '');
		foreach my $key (@$pList) {
			my $work = $Form->Get($key);
			my $subst = $substitute;
			$subst = $this->{'REPLACE'}->[$i] if (defined $this->{'REPLACE'}->[$i]);
			if ($work =~ s/\Q$word\E/$subst/g) {
				$Form->Set($key, $work);
			}
		}
	}
}

#============================================================================================================
#	W[I[
#============================================================================================================
1;
