#============================================================================================================
#
#	t@C샆[eBeBW[
#	earendil.pl
#	-------------------------------------------------------------------------------------
#	2004.02.20 start
#	-------------------------------------------------------------------------------------
#	Copy					: t@CRs[
#	Move					: t@Cړ
#	DeleteDirectory			: fBNg폜
#	GetFileInfoList			: t@C񃊃Xg擾
#	GetFileList				: t@Cꗗ擾
#
#============================================================================================================
package	EARENDIL;

#------------------------------------------------------------------------------------------------------------
#
#	t@CRs[
#	-------------------------------------------------------------------------------------
#	@param	$src	Rs[t@CpX
#	@param	$dst	Rs[t@CpX
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Copy
{
	my		($src,$dst) = @_;
	my		($perm);
	
	eval{
		if	(-e $src){
			$perm = (stat($src))[2];												# p[~bV擾
			open(SRC,"<$src");
			open(DST,">$dst");
			flock(DST,2);
			binmode(SRC);
			binmode(DST);
			while	(<SRC>){
				print DST $_;
			}
			close(DST);
			close(SRC);
			chmod($perm,$dst);														# p[~bVݒ
		}
	};
}

#------------------------------------------------------------------------------------------------------------
#
#	t@Cړ
#	-------------------------------------------------------------------------------------
#	@param	$src	ړt@CpX
#	@param	$dst	ړt@CpX
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Move
{
	my		($src,$dst) = @_;
	my		($perm);
	
	eval{
		if	(-e $src){
			$perm = (stat($src))[2];												# p[~bV擾
			open(SRC,"<$src");
			open(DST,">$dst");
			flock(DST,2);
			binmode(SRC);
			binmode(DST);
			while	(<SRC>){
				print DST $_;
			}
			close(DST);
			close(SRC);
			chmod($perm,$dst);														# p[~bVݒ
			unlink($src);															# Rs[폜
		}
	};
}

#------------------------------------------------------------------------------------------------------------
#
#	fBNgċA폜
#	-------------------------------------------------------------------------------------
#	@param	$path	폜pX
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub DeleteDirectory
{
	my		($path) = @_;
	my		(%fileList,$file,$attr,$dumy);
	
	# t@C擾
	GetFileInfoList($path,\%fileList);
	
	foreach	$file (keys(%fileList)){
		if	($file ne '.' && $file ne '..'){
			($dumy,$dumy,$attr) = split(/<>/,$fileList{$file});
			if	($attr & 1){														# fBNgȂ
				DeleteDirectory($path . '/' . $file);								# ċAĂяo
			}
			else{																	# t@CȂ
				unlink($path . '/' . $file);										# ̂܂܍폜
			}
		}
	}
	rmdir($path);
}

#------------------------------------------------------------------------------------------------------------
#
#	t@Cꗗ擾
#	-------------------------------------------------------------------------------------
#	@param	$Path	ꗗ擾pX
#	@param	$pList	ꗗi[nbV̎Q
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub GetFileInfoList
{
	my		($Path,$pList) = @_;
	my		(@arFiles,$file,$Full,$Attr,$Size,$Perm);
	
	opendir(DIR,$Path);
	@arFiles = readdir(DIR);
	closedir(DIR);
	
	# fBNg̑St@C𑖍
	foreach	$file (@arFiles){
		$Full = $Path . '/' . $file;
		$Attr = 0;
		$Size = -s $Full;															# TCY擾
		$Perm = substr(sprintf("%o",(stat($Full))[2]),-4,4);						# p[~bV擾
		$Attr |= 1	if	(-d	$Full);													# fBNgH
		$Attr |= 2	if	(-T	$Full);													# eLXgt@CH
		$pList->{$file} = "$Size<>$Perm<>$Attr";
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	wt@Cꗗ擾
#	-------------------------------------------------------------------------------------
#	@param	$path	ꗗ擾pX
#	@param	$pList	ꗗi[z̎Q
#	@param	$opt	oIvV(K\)
#	@return	t@C
#
#------------------------------------------------------------------------------------------------------------
sub GetFileList
{
	my		($path,$pList,$opt) = @_;
	my		(@files,$file,$num);
	
	$num = 0;
	opendir(DIR,$path);
	@files = readdir(DIR);
	closedir(DIR);
	
	foreach	$file (@files){
		# fBNgȂovzɃvbV
		if	(!(-d "$path/$file")){
			if	($file =~ /$opt/){
				push(@$pList,$file);
				$num ++;
			}
		}
	}
	return $num;
}

#------------------------------------------------------------------------------------------------------------
#
#	fBNg쐬
#	-------------------------------------------------------------------------------------
#	@param	$path	쐬pX
#	@param	$perm	fBNg̃p[~bV
#	@return	쐬ɐ1Ԃ
#
#------------------------------------------------------------------------------------------------------------
sub CreateDirectory
{
	my		($path,$perm) = @_;
	
	if	(! -e $path){
		return mkdir($path,$perm);
	}
	return 0;
}

#-------------------------------------------------------------------------------------------------------------
#
#	fBNg쐬
#	------------------------------------------------------------------
#	@param	$path	pX
#	@return	Ȃ
#
#-------------------------------------------------------------------------------------------------------------
sub CreateFolderHierarchy
{
	my	($path) = @_;
	
	while	(1){
		if	(-d $path){
			return;
		}
		else{
			if	(mkdir($path,0777)){
				return;
			}
			# fBNg쐬s͍ċAI1̊Kw쐬
			else{
				my	@elem = split(/[\\\/]/,$path);
				my	$n = $#elem - 1;
				my	@parts = @elem[0..$n];
				my	$upath = join('/',@parts);
				
				CreateFolderHierarchy($upath);
			}
		}
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	fBNg
#	-------------------------------------------------------------------------------------
#	@param	$path	pX
#	@param	$pHash	ʊi[pnbV
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub GetFolderHierarchy
{
	my		($path,$pHash) = @_;
	my		(@elements,$elem);
	
	opendir(DIR,"$path");
	@elements = readdir(DIR);
	closedir(DIR);
	
	foreach	$elem (sort(@elements)){
		# fBNgċAIɒT
		if	((-d "$path/$elem") && $elem ne '.' && $elem ne '..'){
			my	(%folders);
			GetFolderHierarchy("$path/$elem",\%folders);
			if	(keys(%folders) > 0){
				$pHash->{$elem} = \%folders;
			}
			else{
				$pHash->{$elem} = undef;
			}
		}
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	fBNgXg擾
#	GetFolderHierarchyŎ擾nbVfBNgꗗ̔z擾
#	-------------------------------------------------------------------------------------
#	@param	$pHash	GetFolderHierarchyŎ擾nbV
#	@param	$pList	ʊi[pz
#	@param	$base	x[XpX
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub GetFolderList
{
	my		($pHash,$pList,$base) = @_;
	my		($key);
	
	foreach	$key (keys(%$pHash)){
		push(@$pList,"$base/$key");
		if	($pHash->{$key} ne undef){
			GetFolderList($pHash->{$key},$pList,"$base/$key");
		}
	}
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
