#============================================================================================================
#
#	httpT[rXW[
#	httpservice.pl
#	-------------------------------------------------------------------------------------
#	2005.11.09 start
#
#============================================================================================================
package HTTPSERVICE;

use Socket;
use strict;
#use warnings;


#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	httpT[rXIuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $this = shift;
	my ($obj, %PARAMETER);
	
	$obj = {
		'METHOD'		=> 'GET',
		'URI'			=> undef,
		'PORT'			=> 80,
		'PARAMETER'		=> \%PARAMETER,
		'AGENT'			=> 'Monazilla/1.00 0ch.4.00 (1000)',
		'CONTENT_TYPE'	=> 'application/x-www-form-urlencoded',
		'CONNECTION'	=> 'close',
		'REFERER'		=> '0ch.mine.nu',
		'RESPONSE'		=> undef
	};
	bless $obj, $this;
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	(RXgN^ŏȂꍇp)
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	httpT[rXIuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub init
{
	my $this = shift;
	
	$this->{'PORT'} = 80;
	$this->{'AGENT'} = '0ch/Monazilla';
	$this->{'METHOD'} = 'GET';
	$this->{'CONTENT_TYPE'} = 'application/x-www-form-urlencoded';
	$this->{'CONNECTION'} = 'Keep-Alive';
}

#------------------------------------------------------------------------------------------------------------
#
#	httpvM
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	G[R[h
#			1:I
#			-1:URIG[
#			-100:socketG[
#
#------------------------------------------------------------------------------------------------------------
sub request
{
	my $this = shift;
	my (@uris, $host, $uri, $request);
	
	# httpNGXg̐
	@uris = split(/\//, $this->{'URI'});
	if (! defined ($host = getTargetAddress($uris[2]))) {
		return -1;
	}
	$uri = $this->{'URI'};
	$request = createRequestString($this, $host, $uri);
	
#	eval
	{
		my ($sockaddr, $response, $uri);
		
		# \Pbg̍쐬
		socket(SOCK, PF_INET, SOCK_STREAM, getprotobyname('tcp')) || die('ERROR');
		select SOCK;
		$| =1;
		select STDOUT;
		$sockaddr = sockaddr_in($this->{'PORT'}, inet_aton($host));
		connect(SOCK, $sockaddr) || die('ERROR');
		
		# NGXgM
		print SOCK $request;
		
		# X|XM
		while (<SOCK>) {
		    $response .= $_;
		}
		close SOCK;
		
		$this->{'RESPONSE'} = $response;
	};
	if ($@ ne '') {
		$this->{'RESPONSE'} = $@;
		return -100;
	}
	
	return 1;
}

#------------------------------------------------------------------------------------------------------------
#
#	http擾
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	http.httpvsocketG[Nꍇ̓G[bZ[W
#
#------------------------------------------------------------------------------------------------------------
sub getResponse
{
	my $this = shift;
	return $this->{'RESPONSE'};
}

#------------------------------------------------------------------------------------------------------------
#
#	httpvuriݒ
#	-------------------------------------------------------------------------------------
#	@param	$uri	URI
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setURI
{
	my $this = shift;
	my ($uri) = @_;
	$this->{'URI'} = $uri;
}

#------------------------------------------------------------------------------------------------------------
#
#	httpv|[gݒ
#	-------------------------------------------------------------------------------------
#	@param	$port	|[gԍ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setPort
{
	my $this = shift;
	my ($port) = @_;
	$this->{'PORT'} = $port;
}

#------------------------------------------------------------------------------------------------------------
#
#	httpv\bhݒ
#	-------------------------------------------------------------------------------------
#	@param	$method	\bh
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setMethod
{
	my $this = shift;
	my ($method) = @_;
	$this->{'METHOD'} = $method;
}


#------------------------------------------------------------------------------------------------------------
#
#	UserAgentݒ
#	-------------------------------------------------------------------------------------
#	@param	$agent	UserAgent
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setAgent
{
	my $this = shift;
	my ($agent) = @_;
	$this->{'AGENT'} = $agent;
}

#------------------------------------------------------------------------------------------------------------
#
#	httpvp[^ݒ
#	-------------------------------------------------------------------------------------
#	@param	$key	p[^L[
#	@param	$value	p[^l
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setParameter
{
	my $this = shift;
	my ($key, $value) = @_;
	$this->{'PARAMETER'}->{$key} = $value;
}

#------------------------------------------------------------------------------------------------------------
#
#	Reg^Cvݒ
#	-------------------------------------------------------------------------------------
#	@param	$type	Reg^Cv
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setContentType
{
	my $this = shift;
	my ($type) = @_;
	$this->{'CONTENT_TYPE'} = $type;
}

#------------------------------------------------------------------------------------------------------------
#
#	RlNVݒ
#	-------------------------------------------------------------------------------------
#	@param	$conn	RlNV
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setConnection
{
	my $this = shift;
	my ($conn) = @_;
	$this->{'CONNECTION'} = $conn;
}

#------------------------------------------------------------------------------------------------------------
#
#	t@ݒ
#	-------------------------------------------------------------------------------------
#	@param	$ref	t@
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setReferer
{
	my $this = shift;
	my ($ref) = @_;
	$this->{'REFERER'} = $ref;
}

#------------------------------------------------------------------------------------------------------------
#
#	httpvAhX擾
#	-------------------------------------------------------------------------------------
#	@param	$host	httpvzXg
#	@return	httpvAhX
#
#------------------------------------------------------------------------------------------------------------
sub getTargetAddress
{
	my ($host) = @_;
	my (@addrs, $addr);
	
	@addrs = unpack('C4', (gethostbyname $host)[4]);
	if ($addrs[0] !~ /^[0-9]+$/ || $addrs[0] < 0 || $addrs[0] > 256 ||
	    $addrs[1] !~ /^[0-9]+$/ || $addrs[1] < 0 || $addrs[1] > 256 ||
	    $addrs[2] !~ /^[0-9]+$/ || $addrs[2] < 0 || $addrs[2] > 256 ||
	    $addrs[3] !~ /^[0-9]+$/ || $addrs[3] < 0 || $addrs[3] > 256) {
		return undef;
	}
	$addr = join('.', @addrs);
	
	return $addr;
}

#------------------------------------------------------------------------------------------------------------
#
#	httpvURI(zXg̑URI)擾
#	-------------------------------------------------------------------------------------
#	@param	$uriList	httpvURI'/'ŕXg
#	@return	httpvURI
#
#------------------------------------------------------------------------------------------------------------
sub getRelativeURI
{
	my ($uriList) = @_;
	my ($i, $count, $uri);
	
	$count = @$uriList;
	$uri = '';
	for($i = 3;$i < $count;$i++) {
		$uri .= '/' . $uriList->[$i];
	}
	
	if ($uri eq '') {
		$uri = '/';
	}
	return $uri;
}

#------------------------------------------------------------------------------------------------------------
#
#	httpv̐
#	-------------------------------------------------------------------------------------
#	@param	$host	httpvAhX
#	@param	$uri	httpv摊URI
#	@return	httpvwb_
#
#------------------------------------------------------------------------------------------------------------
sub createRequestString
{
	my $this = shift;
	my ($host, $uri) = @_;
	my ($request, $params, $len);
	
	# http{fB(p[^)̍쐬
	foreach (keys %{$this->{'PARAMETER'}}) {
		$params .= "$_=" . encode($this->{'PARAMETER'}->{$_}) . '&';
	}
	if ($params ne '') {
		$params = substr($params, 0, length($params) - 1);
		$len = length $params;
	}
	
	# httpNGXgwb_̍쐬
	$request .= $this->{'METHOD'} . " $uri HTTP/1.0\r\n";
	$request .= 'User-Agent: ' . $this->{'AGENT'} . "\r\n";
	$request .= "Host: $host\r\n";
	$request .= 'Connection: ' . $this->{'CONNECTION'} . "\r\n";
	$request .= 'Content-Type: ' . $this->{'CONTENT_TYPE'} . "\r\n";
	$request .= "Content-Length: $len\r\n";
	$request .= "\r\n";
	
	# http{fBA
	if ($len > 0) {
		$request .= $params;
	}
	
	return $request;
}

#------------------------------------------------------------------------------------------------------------
#
#	URLGR[h
#	-------------------------------------------------------------------------------------
#	@param	$text	GR[h
#	@return	URLGR[h
#
#------------------------------------------------------------------------------------------------------------
sub encode
{
	my ($text) = @_;
	$text =~ s/(\W)/sprintf('%%%02X', unpack('C', $1))/eg;
	return($text);
}

#------------------------------------------------------------------------------------------------------------
#
#	httpv^CAEgnh
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub onTimeout
{
	die 'ERRROR';
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
